/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.yoko.orb.OB.CodeConverters;
import org.apache.yoko.orb.OB.CodeSetDatabase;
import org.apache.yoko.orb.OB.CodeSetInfo;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CORBA.portable.InputStream;
import org.omg.IOP.ServiceContext;

public final class CodeSetUtil {
    private static final List<CodeSetInfo> SUPPORTED_CHAR_CODESETS = Collections.unmodifiableList(CodeSetUtil.getSupportedCharCodeSets());
    private static final List<CodeSetInfo> SUPPORTED_WCHAR_CODESETS = Collections.unmodifiableList(Arrays.asList(CodeSetInfo.UTF_16));

    private static List<CodeSetInfo> getLocaleSpecificCodeSets() {
        String language;
        switch (language = Locale.getDefault().getLanguage()) {
            case "C": 
            case "POSIX": {
                return Arrays.asList(CodeSetInfo.ISO_LATIN_1);
            }
        }
        switch (language.substring(0, 2)) {
            case "de": 
            case "en": 
            case "fr": 
            case "nl": 
            case "pt": {
                return Arrays.asList(CodeSetInfo.ISO_LATIN_1);
            }
            case "da": 
            case "fi": 
            case "is": 
            case "no": 
            case "sv": {
                return Arrays.asList(CodeSetInfo.ISO_LATIN_4);
            }
            case "it": {
                return Arrays.asList(CodeSetInfo.ISO_LATIN_3);
            }
            case "cs": 
            case "hu": 
            case "pl": 
            case "sk": 
            case "sl": {
                return Arrays.asList(CodeSetInfo.ISO_LATIN_2);
            }
            case "el": {
                return Arrays.asList(CodeSetInfo.ISO_8859_7);
            }
            case "ru": {
                return Arrays.asList(CodeSetInfo.ISO_8859_5);
            }
            case "tr": {
                return Arrays.asList(CodeSetInfo.ISO_8859_9);
            }
        }
        return Collections.emptyList();
    }

    private static List<CodeSetInfo> getSupportedCharCodeSets() {
        ArrayList<CodeSetInfo> result = new ArrayList<CodeSetInfo>();
        result.addAll(CodeSetUtil.getLocaleSpecificCodeSets());
        result.add(CodeSetInfo.ISO_646_IRV);
        result.add(CodeSetInfo.UTF_8);
        return result;
    }

    static CodeSetComponent createCodeSetComponent(int id, boolean wChar) {
        CodeSetComponent codeSetComponent = new CodeSetComponent();
        codeSetComponent.native_code_set = id;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (CodeSetInfo csi : wChar ? SUPPORTED_WCHAR_CODESETS : SUPPORTED_CHAR_CODESETS) {
            if (id == csi.id) continue;
            ids.add(csi.id);
        }
        codeSetComponent.conversion_code_sets = new int[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            codeSetComponent.conversion_code_sets[i] = (Integer)ids.get(i);
        }
        return codeSetComponent;
    }

    static CodeSetComponentInfo getCodeSetInfoFromComponents(ORBInstance orbInstance, ProfileInfo profileInfo) {
        if (profileInfo.major == 1 && profileInfo.minor > 0) {
            for (int i = 0; i < profileInfo.components.length; ++i) {
                if (profileInfo.components[i].tag != 1) continue;
                org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(profileInfo.components[i].component_data);
                in._OB_readEndian();
                return CodeSetComponentInfoHelper.read((InputStream)in);
            }
        } else if (orbInstance.extendedWchar()) {
            return new CodeSetComponentInfo(new CodeSetComponent(CodeSetInfo.ISO_LATIN_1.id, new int[0]), new CodeSetComponent(CodeSetInfo.UCS_2.id, new int[0]));
        }
        return null;
    }

    static CodeConverters getCodeConverters(ORBInstance orbInstance, ProfileInfo profileInfo) {
        CodeSetComponentInfo info = CodeSetUtil.getCodeSetInfoFromComponents(orbInstance, profileInfo);
        if (info == null) {
            return CodeConverters.create(orbInstance, CodeSetInfo.ISO_LATIN_1.id, orbInstance.getDefaultWcs());
        }
        CodeSetComponent client_cs = CodeSetUtil.createCodeSetComponent(orbInstance.getNativeCs(), false);
        CodeSetComponent client_wcs = CodeSetUtil.createCodeSetComponent(orbInstance.getNativeWcs(), true);
        int tcs_c = CodeSetDatabase.determineTCS(client_cs, info.ForCharData, CodeSetInfo.UTF_8.id);
        int tcs_wc = CodeSetDatabase.determineTCS(client_wcs, info.ForWcharData, CodeSetInfo.UTF_16.id);
        return CodeConverters.create(orbInstance, tcs_c, tcs_wc);
    }

    static CodeSetContext extractCodeSetContext(ServiceContext csSC) {
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(csSC.context_data);
        in._OB_readEndian();
        return CodeSetContextHelper.read((InputStream)in);
    }
}

