/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.resource.ResourceException;

public final class J2CUtilityClass {
    public static final String _defaultThrowableDelimiter = ":";
    private static final TraceComponent tc = Tr.register(J2CUtilityClass.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");
    public static final Hashtable<String, Object> pmiNameToCompAlias = new Hashtable();

    public static String generateExceptionString(Throwable t) {
        return J2CUtilityClass.generateExceptionString(t, _defaultThrowableDelimiter);
    }

    public static String generateExceptionString(Throwable t, String delim) {
        StringBuffer sb = new StringBuffer();
        if (t != null) {
            sb.append(t.toString());
            Throwable nextThrowable = J2CUtilityClass.getNextThrowable(t);
            if (nextThrowable != null) {
                sb.append(delim);
                sb.append(J2CUtilityClass.generateExceptionString(J2CUtilityClass.getNextThrowable(t), delim));
            }
        }
        return sb.toString();
    }

    public static Throwable getNextThrowable(Throwable t) {
        Throwable nextThrowable = null;
        if (t != null && (nextThrowable = t.getCause()) == null) {
            if (t instanceof SQLException) {
                nextThrowable = ((SQLException)t).getNextException();
            } else if (t instanceof ResourceException) {
                nextThrowable = ((ResourceException)t).getCause();
            }
        }
        return nextThrowable;
    }

    public static final boolean isContainerAtBoundary(EmbeddableWebSphereTransactionManager tm) {
        UOWCoordinator uowCoord;
        boolean isContainerResolved = false;
        UOWCurrent uowCurrent = (UOWCurrent)tm;
        UOWCoordinator uOWCoordinator = uowCoord = uowCurrent == null ? null : uowCurrent.getUOWCoord();
        if (uowCoord != null) {
            if (!uowCoord.isGlobal()) {
                isContainerResolved = ((LocalTransactionCoordinator)uowCoord).isContainerResolved();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isContainerAtBoundary unexpectedly called within a global tran and the value is defaulted to APPLICATION", (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isContainerAtBoundary=" + isContainerResolved), (Object[])new Object[0]);
        }
        return isContainerResolved;
    }
}

