/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence.service;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.EntityManagerBuilder;
import io.openliberty.data.internal.persistence.cdi.DataExtension;
import jakarta.data.exceptions.DataException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.CheckClassAdapter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RecordTransformer {
    private static final TraceComponent tc = Tr.register(RecordTransformer.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    static final long serialVersionUID = -4758606323039763054L;

    public static byte[] generateEntityClassBytes(Class<?> recordClass, String entityClassName, J2EEName jeeName, Set<Class<?>> repositoryInterfaces) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        String CTOR = "<init>";
        String TO_RECORD = "toRecord";
        String _recordClassName = recordClass.getName().replace(".", "/");
        String _recordClassNameDesc = Type.getDescriptor(recordClass);
        String _entityClassName = entityClassName.replace('.', '/');
        String _objectClassName = Object.class.getName().replace('.', '/');
        String _sourceFileName = entityClassName.substring(entityClassName.lastIndexOf(".") + 1) + ".java";
        if (recordClass.getTypeParameters().length != 0) {
            throw DataExtension.exc(DataException.class, "CWWKD1071.record.with.type.var", recordClass.getName(), EntityManagerBuilder.getClassNames(repositoryInterfaces), jeeName, Arrays.asList(recordClass.getTypeParameters()));
        }
        LinkedHashMap<String, RecordComponentInfo> recordComponents = new LinkedHashMap<String, RecordComponentInfo>();
        for (RecordComponent component : recordClass.getRecordComponents()) {
            RecordComponentInfo info = new RecordComponentInfo(component);
            RecordComponentInfo previous = recordComponents.put(info.getMethodName(""), info);
            if (previous != null) {
                throw DataExtension.exc(DataException.class, "CWWKD1072.record.comp.conflict", recordClass.getName(), EntityManagerBuilder.getClassNames(repositoryInterfaces), jeeName, info.name, previous.name);
            }
            if (!trace || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)info.toString(), (Object[])new Object[0]);
        }
        ClassWriter cw = new ClassWriter(3);
        cw.visit(61, 33, _entityClassName, null, _objectClassName, null);
        cw.visitSource(_sourceFileName, null);
        for (Object rcInfo : recordComponents.values()) {
            if (trace && tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("visitField: " + String.valueOf(Arrays.asList("ACC_PRIVATE", ((RecordComponentInfo)rcInfo).name, ((RecordComponentInfo)rcInfo).descriptor, ((RecordComponentInfo)rcInfo).fieldSignature, null))), (Object[])new Object[0]);
            }
            FieldVisitor fieldVisitor = cw.visitField(2, ((RecordComponentInfo)rcInfo).name, ((RecordComponentInfo)rcInfo).descriptor, ((RecordComponentInfo)rcInfo).fieldSignature, null);
            fieldVisitor.visitEnd();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("visitMethod(ctor): " + String.valueOf(Arrays.asList("ACC_PUBLIC", "<init>", "()V", null, null))), (Object[])new Object[0]);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, _objectClassName, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        if (trace && tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("visitMethod(ctor): " + String.valueOf(Arrays.asList("ACC_PUBLIC", "<init>", "(" + _recordClassNameDesc + ")V", null, null))), (Object[])new Object[0]);
        }
        mv = cw.visitMethod(1, "<init>", "(" + _recordClassNameDesc + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, _objectClassName, "<init>", "()V", false);
        for (Iterator rcInfo : recordComponents.values()) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, _recordClassName, ((RecordComponentInfo)((Object)rcInfo)).name, "()" + ((RecordComponentInfo)((Object)rcInfo)).descriptor, false);
            mv.visitFieldInsn(181, _entityClassName, ((RecordComponentInfo)((Object)rcInfo)).name, ((RecordComponentInfo)((Object)rcInfo)).descriptor);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        if (trace && tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("visitMethod: " + String.valueOf(Arrays.asList("ACC_PUBLIC", "toRecord", "()" + _recordClassNameDesc, null, null))), (Object[])new Object[0]);
        }
        mv = cw.visitMethod(1, "toRecord", "()" + _recordClassNameDesc, null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, _recordClassName);
        mv.visitInsn(89);
        StringBuffer paramDesc = new StringBuffer();
        paramDesc.append("(");
        for (RecordComponentInfo rcInfo : recordComponents.values()) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, _entityClassName, rcInfo.name, rcInfo.descriptor);
            paramDesc.append(rcInfo.descriptor);
        }
        paramDesc.append(")V");
        mv.visitMethodInsn(183, _recordClassName, "<init>", paramDesc.toString(), false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        for (RecordComponentInfo rcInfo : recordComponents.values()) {
            if (trace && tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("visitMethod(set): " + String.valueOf(Arrays.asList("ACC_PUBLIC", rcInfo.getMethodName("set"), rcInfo.setterDescriptor, rcInfo.setterSignature, null))), (Object[])new Object[0]);
            }
            mv = cw.visitMethod(1, rcInfo.getMethodName("set"), rcInfo.setterDescriptor, rcInfo.setterSignature, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(rcInfo.type.getOpcode(21), 1);
            mv.visitFieldInsn(181, _entityClassName, rcInfo.name, rcInfo.descriptor);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            if (trace && tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("visitMethod(get): " + String.valueOf(Arrays.asList("ACC_PUBLIC", rcInfo.getMethodName("get"), rcInfo.getterDescriptor, rcInfo.getterSignature, null))), (Object[])new Object[0]);
            }
            mv = cw.visitMethod(1, rcInfo.getMethodName("get"), rcInfo.getterDescriptor, rcInfo.getterSignature, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, _entityClassName, rcInfo.name, rcInfo.descriptor);
            mv.visitInsn(rcInfo.type.getOpcode(172));
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        StringWriter sw = new StringWriter();
        CheckClassAdapter.verify((ClassReader)new ClassReader(classBytes), (boolean)false, (PrintWriter)new PrintWriter(sw));
        String result = sw.toString();
        if (!result.isBlank()) {
            Tr.warning((TraceComponent)tc, (String)"CWWKD1112.record.entity.verify.err", (Object[])new Object[]{recordClass.getName(), EntityManagerBuilder.getClassNames(repositoryInterfaces), jeeName, result});
        }
        return classBytes;
    }

    @Trivial
    private static final class RecordComponentInfo {
        public final String name;
        public final Type type;
        public final String descriptor;
        public final String getterDescriptor;
        public final String setterDescriptor;
        public final String fieldSignature;
        public final String setterSignature;
        public final String getterSignature;

        public RecordComponentInfo(RecordComponent component) {
            this.name = component.getName();
            this.type = Type.getType(component.getType());
            this.descriptor = this.type.getDescriptor();
            this.getterDescriptor = "()" + this.descriptor;
            this.setterDescriptor = "(" + this.descriptor + ")V";
            String genericSignature = component.getGenericSignature();
            if (genericSignature == null) {
                this.fieldSignature = this.getterSignature = genericSignature;
                this.setterSignature = this.getterSignature;
            } else {
                this.fieldSignature = genericSignature;
                this.setterSignature = "(" + this.fieldSignature + ")V";
                this.getterSignature = "()" + this.fieldSignature;
            }
        }

        public String getMethodName(String prefix) {
            return prefix + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
        }

        public String toString() {
            return "RecordComponentInfo [name=" + this.name + ", type=" + String.valueOf(this.type) + ", descriptor=" + this.descriptor + ", getterDescriptor=" + this.getterDescriptor + ", setterDescriptor=" + this.setterDescriptor + ", fieldSignature=" + this.fieldSignature + ", setterSignature=" + this.setterSignature + ", getterSignature=" + this.getterSignature + "]";
        }
    }
}

