/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class UniqueKeyConstraint
implements Serializable {
    protected String name = "";
    protected Vector<String> sourceFields = new Vector();

    public UniqueKeyConstraint() {
    }

    public UniqueKeyConstraint(String name, String sourceField) {
        this();
        this.name = name;
        this.sourceFields.addElement(sourceField);
    }

    public UniqueKeyConstraint(String name, String[] sourceFields) {
        this();
        this.name = name;
        for (String sourceField : sourceFields) {
            this.sourceFields.addElement(sourceField);
        }
    }

    public void addSourceField(String sourceField) {
        this.getSourceFields().addElement(sourceField);
    }

    public void appendDBString(Writer writer, AbstractSession session) {
        try {
            writer.write("UNIQUE (");
            Enumeration<String> sourceEnum = this.getSourceFields().elements();
            while (sourceEnum.hasMoreElements()) {
                writer.write(sourceEnum.nextElement());
                if (!sourceEnum.hasMoreElements()) continue;
                writer.write(", ");
            }
            writer.write(")");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public String getName() {
        return this.name;
    }

    public Vector<String> getSourceFields() {
        return this.sourceFields;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSourceFields(Vector<String> sourceFields) {
        this.sourceFields = sourceFields;
    }
}

