/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.util.cf;

import com.ibm.bsf.util.IndentWriter;
import com.ibm.bsf.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class CodeFormatter {
    public static final int DEFAULT_MAX = 74;
    public static final int DEFAULT_STEP = 2;
    public static final String DEFAULT_DELIM = "(+";
    public static final String DEFAULT_S_DELIM = ",";
    private int maxLineLength = 74;
    private int indentationStep = 2;
    private String delimiters = "(+";
    private String stickyDelimiters = ",";
    private int indent;
    private int hangingIndent;
    private int origIndent;
    private boolean inCPP_Comment;

    private void addTok(StringBuffer stringBuffer, StringBuffer stringBuffer2, IndentWriter indentWriter) {
        int n = stringBuffer2.length();
        int n2 = stringBuffer.length();
        if (this.indent + n2 + n > this.maxLineLength) {
            if (n2 == 0) {
                indentWriter.println(this.indent, stringBuffer2.toString());
                this.indent = this.hangingIndent;
                stringBuffer.setLength(0);
                return;
            }
            indentWriter.println(this.indent, stringBuffer.toString().trim());
            this.indent = this.hangingIndent;
            stringBuffer.setLength(0);
        }
        stringBuffer.append(stringBuffer2.toString());
    }

    public void formatCode(Reader reader, Writer writer) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        IndentWriter indentWriter = new IndentWriter(new BufferedWriter(writer), true);
        try {
            String string;
            this.origIndent = 0;
            this.inCPP_Comment = false;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() > 0) {
                    this.indent = this.origIndent;
                    this.hangingIndent = this.indent + this.indentationStep;
                    this.printLine(string, indentWriter);
                    continue;
                }
                indentWriter.println();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getDelimiters() {
        return this.delimiters;
    }

    public int getIndentationStep() {
        return this.indentationStep;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public String getStickyDelimiters() {
        return this.stickyDelimiters;
    }

    private void printLine(String string, IndentWriter indentWriter) {
        String string2;
        char[] cArray = string.toCharArray();
        char c = ' ';
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(this.hangingIndent + string.length());
        block13: for (int i = 0; i < cArray.length; ++i) {
            char c2 = cArray[i];
            if (bl) {
                stringBuffer.append(c2);
                bl = false;
                continue;
            }
            if (bl2) {
                switch (c2) {
                    case '\\': {
                        stringBuffer.append('\\');
                        bl = true;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        stringBuffer.append(c2);
                        if (c2 != c) continue block13;
                        this.addTok(stringBuffer2, stringBuffer, indentWriter);
                        stringBuffer.setLength(0);
                        bl2 = false;
                        break;
                    }
                    case '\t': {
                        stringBuffer.append(c2);
                        break;
                    }
                    default: {
                        if (c2 <= '\u001f') continue block13;
                        stringBuffer.append(c2);
                        break;
                    }
                }
                continue;
            }
            if (this.inCPP_Comment) {
                stringBuffer.append(c2);
                if (c2 != '/' || i <= 0 || cArray[i - 1] != '*') continue;
                this.inCPP_Comment = false;
                continue;
            }
            switch (c2) {
                case '/': {
                    stringBuffer.append(c2);
                    if (i <= 0 || cArray[i - 1] != '/') continue block13;
                    String string3 = stringBuffer.append(cArray, i + 1, cArray.length - (i + 1)).toString();
                    indentWriter.println(this.indent, stringBuffer2.append(string3).toString());
                    return;
                }
                case '*': {
                    stringBuffer.append(c2);
                    if (i <= 0 || cArray[i - 1] != '/') continue block13;
                    this.inCPP_Comment = true;
                    continue block13;
                }
                case '\"': 
                case '\'': {
                    this.addTok(stringBuffer2, stringBuffer, indentWriter);
                    stringBuffer.setLength(0);
                    stringBuffer.append(c2);
                    c = c2;
                    bl2 = true;
                    continue block13;
                }
                case '\t': {
                    stringBuffer.append(StringUtils.getChars(this.indentationStep, ' '));
                    continue block13;
                }
                case '{': {
                    stringBuffer.append(c2);
                    this.origIndent += this.indentationStep;
                    continue block13;
                }
                case '}': {
                    stringBuffer.append(c2);
                    this.origIndent -= this.indentationStep;
                    if (i != 0) continue block13;
                    this.indent = this.origIndent;
                    continue block13;
                }
                default: {
                    if (c2 <= '\u001f') continue block13;
                    if (this.delimiters.indexOf(c2) != -1) {
                        this.addTok(stringBuffer2, stringBuffer, indentWriter);
                        stringBuffer.setLength(0);
                        stringBuffer.append(c2);
                        continue block13;
                    }
                    if (this.stickyDelimiters.indexOf(c2) != -1) {
                        stringBuffer.append(c2);
                        this.addTok(stringBuffer2, stringBuffer, indentWriter);
                        stringBuffer.setLength(0);
                        continue block13;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
        if (stringBuffer.length() > 0) {
            this.addTok(stringBuffer2, stringBuffer, indentWriter);
        }
        if ((string2 = stringBuffer2.toString().trim()).length() > 0) {
            indentWriter.println(this.indent, string2);
        }
    }

    public void setDelimiters(String string) {
        this.delimiters = string;
    }

    public void setIndentationStep(int n) {
        this.indentationStep = n < 0 ? 0 : n;
    }

    public void setMaxLineLength(int n) {
        this.maxLineLength = n < 0 ? 0 : n;
    }

    public void setStickyDelimiters(String string) {
        this.stickyDelimiters = string;
    }
}

