/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.BrowserSessionProxy;
import com.ibm.ws.sib.comms.client.DestinationSessionProxy;
import com.ibm.ws.sib.comms.client.proxyqueue.BrowserProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ConversationHelper;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ConversationHelperImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ProxyQueueConversationGroupImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.QueueData;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.ReadAheadQueue;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

public class BrowserProxyQueueImpl
implements BrowserProxyQueue {
    private static String CLASS_NAME = BrowserProxyQueueImpl.class.getName();
    private static final TraceComponent tc = SibTr.register(BrowserProxyQueueImpl.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private short proxyQueueId;
    private ConversationHelper convHelper;
    private ReadAheadQueue queue;
    private BrowserSessionProxy browserSession = null;
    private ProxyQueueConversationGroupImpl owningGroup;
    private volatile boolean closed = false;

    public BrowserProxyQueueImpl(ProxyQueueConversationGroupImpl group, short id, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{group, id, conversation});
        }
        this.owningGroup = group;
        this.convHelper = new ConversationHelperImpl(conversation, 0);
        this.proxyQueueId = id;
        this.queue = new ReadAheadQueue(id, this.convHelper);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    protected BrowserProxyQueueImpl(ProxyQueueConversationGroupImpl group, short id, ConversationHelper convHelper) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{group, id, convHelper});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"test form of constructor invoked");
        }
        this.owningGroup = group;
        this.proxyQueueId = id;
        this.convHelper = convHelper;
        this.queue = new ReadAheadQueue(id, this.convHelper);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public JsMessage next() throws MessageDecodeFailedException, SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SINotAuthorizedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"next");
        }
        JsMessage retMsg = null;
        retMsg = this.queue.get(this.proxyQueueId);
        if (retMsg == null) {
            this.convHelper.flushConsumer();
            retMsg = this.queue.get(this.proxyQueueId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"next", (Object)retMsg);
        }
        return retMsg;
    }

    @Override
    public void close() throws SIResourceException, SIConnectionLostException, SIErrorException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close");
        }
        if (!this.closed) {
            this.convHelper.closeSession();
            this.queue.purge(this.proxyQueueId);
            this.owningGroup.notifyClose(this);
            this.closed = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    @Override
    public short getId() {
        return this.proxyQueueId;
    }

    @Override
    public void put(CommsByteBuffer msgBuffer, short msgBatch, boolean lastInBatch, boolean chunk) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"put", (Object)new Object[]{msgBuffer, msgBatch, lastInBatch, chunk});
        }
        QueueData queueData = null;
        if (chunk) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Dealing with a chunked message");
            }
            byte flags = msgBuffer.get();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Flags:", (Object)("" + flags));
            }
            if ((flags & 1) == 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"First chunk received");
                }
                queueData = new QueueData(this, lastInBatch, chunk, msgBuffer);
                this.queue.put(queueData, msgBatch);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Middle / Last chunk received");
                }
                boolean lastChunk = (flags & 4) == 4;
                this.queue.appendToLastMessage(msgBuffer, lastChunk);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Dealing with the entire message");
            }
            queueData = new QueueData(this, lastInBatch, chunk, msgBuffer);
            this.queue.put(queueData, msgBatch);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put");
        }
    }

    @Override
    public void setBrowserSession(BrowserSessionProxy browserSession) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBrowserSession", (Object)browserSession);
        }
        if (this.browserSession != null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("RESET_OF_BROWSER_SESSION_SICO1035", null, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".setBrowserSession"), (String)"2-008-0001", (Object)this);
            throw e;
        }
        if (browserSession == null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("NULL_BROWSER_SESSION_SICO1036", null, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".setBrowserSession"), (String)"2-008-0002", (Object)this);
            throw e;
        }
        this.browserSession = browserSession;
        this.convHelper.setSessionId(browserSession.getProxyID());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBrowserSession");
        }
    }

    @Override
    public void reset() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reset");
        }
        this.convHelper.exchangeResetBrowse();
        this.queue.purge(this.proxyQueueId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    public String toString() {
        return "BrowserPQ@" + Integer.toHexString(this.hashCode()) + ": " + this.queue.toString();
    }

    @Override
    public ConversationHelper getConversationHelper() {
        return this.convHelper;
    }

    @Override
    public DestinationSessionProxy getDestinationSessionProxy() {
        return this.browserSession;
    }

    @Override
    public void conversationDroppedNotification() {
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/impl/BrowserProxyQueueImpl.java, SIB.comms, WASX.SIB, uu1215.01 1.29");
        }
    }
}

