/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collector;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collector.Target;
import com.ibm.ws.logging.synch.ThreadLocalHandler;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EventsBuffer {
    private static final TraceComponent tc = Tr.register(EventsBuffer.class, null, null);
    private final long bufferMaxSize;
    private final Target target;
    private List<Object> events;
    private Timer timer;
    private final long period;
    static final long serialVersionUID = 4327101304240152343L;

    public EventsBuffer(Target target, long bufferMaxSize, long period) {
        this.target = target;
        this.bufferMaxSize = bufferMaxSize;
        this.events = new ArrayList<Object>();
        this.period = period;
    }

    public synchronized void start() {
        if (this.timer == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Starting timer", (Object[])new Object[]{this.target, this.bufferMaxSize, this.period});
            }
            this.timer = new Timer("EventBufferTimer");
            this.timer.schedule((TimerTask)new EventsBufferTimerTask(), 0L, this.period);
        }
    }

    public synchronized void stop() {
        if (this.timer != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Stopping timer", (Object[])new Object[]{this.target});
            }
            this.timer.cancel();
            this.timer = null;
        }
    }

    public synchronized void add(Object event) {
        this.events.add(event);
        if ((long)this.events.size() >= this.bufferMaxSize) {
            this.flushBuffer();
        }
    }

    public synchronized void flushBuffer() {
        if (this.events.size() > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Events: " + this.events.size()), (Object[])new Object[0]);
            }
            long startTime = System.nanoTime();
            this.target.sendEvents(this.events);
            this.events = new ArrayList<Object>();
            EventsBuffer.traceTime(tc, startTime, "Flush");
        }
    }

    private static void traceTime(TraceComponent tc, long startTime, String label) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            long endTime = System.nanoTime();
            String s = String.format(label + ": %10.3f ms", Float.valueOf((float)(endTime - startTime) / 1000000.0f));
            Tr.event((TraceComponent)tc, (String)s, (Object[])new Object[0]);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class EventsBufferTimerTask
    extends TimerTask {
        static final long serialVersionUID = 5870035571993928679L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        EventsBufferTimerTask() {
        }

        @Override
        @Trivial
        public void run() {
            ThreadLocalHandler.set((Boolean)Boolean.TRUE);
            EventsBuffer.this.flushBuffer();
            ThreadLocalHandler.remove();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collector.EventsBuffer$EventsBufferTimerTask", EventsBufferTimerTask.class, null, null);
        }
    }
}

