/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.BrowserProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueueConversationGroup;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.AsynchConsumerProxyQueueImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.BrowserProxyQueueImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.IdAllocatorException;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.NonReadAheadSessionProxyQueueImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.OrderedSessionProxyQueueImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ProxyQueueConversationGroupFactoryImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ReadAheadSessionProxyQueueImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ShortIdAllocator;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ProxyQueueConversationGroupImpl
implements ProxyQueueConversationGroup {
    private static String CLASS_NAME = ProxyQueueConversationGroupImpl.class.getName();
    private static final TraceComponent tc = SibTr.register(ProxyQueueConversationGroup.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private Conversation conversation = null;
    private ProxyQueueConversationGroupFactoryImpl factory = null;
    private ShortIdAllocator idAllocator = new ShortIdAllocator(false);
    private boolean closed = false;
    private MutableId mutableId = new MutableId();
    private final HashMap<ImmutableId, ProxyQueue> idToProxyQueueMap;

    public ProxyQueueConversationGroupImpl(Conversation conversation, ProxyQueueConversationGroupFactoryImpl factory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{conversation, factory});
        }
        this.conversation = conversation;
        this.factory = factory;
        this.idToProxyQueueMap = new HashMap();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public synchronized BrowserProxyQueue createBrowserProxyQueue() throws SIResourceException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createBrowserProxyQueue");
        }
        this.checkClosed();
        short id = this.nextId();
        BrowserProxyQueueImpl proxyQueue = new BrowserProxyQueueImpl(this, id, this.conversation);
        this.idToProxyQueueMap.put(new ImmutableId(id), proxyQueue);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createBrowserProxyQueue", (Object)proxyQueue);
        }
        return proxyQueue;
    }

    @Override
    public synchronized AsynchConsumerProxyQueue createAsynchConsumerProxyQueue(OrderingContext oc) throws SIResourceException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createAsynchConsumerProxyQueue");
        }
        short id = this.nextId();
        AsynchConsumerProxyQueueImpl proxyQueue = null;
        proxyQueue = oc == null ? new NonReadAheadSessionProxyQueueImpl(this, id, this.conversation) : new OrderedSessionProxyQueueImpl(this, id, this.conversation, oc);
        this.idToProxyQueueMap.put(new ImmutableId(id), proxyQueue);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createAsynchConsumerProxyQueue", (Object)proxyQueue);
        }
        return proxyQueue;
    }

    @Override
    public synchronized AsynchConsumerProxyQueue createAsynchConsumerProxyQueue(short id, short seqNumber, OrderingContext oc) throws SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createAsynchConsumerProxyQueue");
        }
        this.checkClosed();
        AsynchConsumerProxyQueueImpl proxyQueue = null;
        proxyQueue = oc == null ? new NonReadAheadSessionProxyQueueImpl(this, id, this.conversation) : new OrderedSessionProxyQueueImpl(this, id, this.conversation, oc);
        this.idToProxyQueueMap.put(new ImmutableId(id), proxyQueue);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createAsynchConsumerProxyQueue", (Object)proxyQueue);
        }
        return proxyQueue;
    }

    @Override
    public synchronized AsynchConsumerProxyQueue createReadAheadProxyQueue(Reliability unrecoverableReliability) throws SIResourceException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createReadAheadProxyQueue");
        }
        this.checkClosed();
        short id = this.nextId();
        ReadAheadSessionProxyQueueImpl proxyQueue = new ReadAheadSessionProxyQueueImpl(this, id, this.conversation, unrecoverableReliability);
        this.idToProxyQueueMap.put(new ImmutableId(id), proxyQueue);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createReadAheadProxyQueue", (Object)proxyQueue);
        }
        return proxyQueue;
    }

    @Override
    public synchronized AsynchConsumerProxyQueue createOrderedProxyQueue(OrderingContext context) throws SIResourceException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createOrderedProxyQueue", (Object)context);
        }
        short id = this.nextId();
        AsynchConsumerProxyQueue proxyQueue = this.createOrderedProxyQueue(context, id, (short)0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createOrderedProxyQueue", (Object)proxyQueue);
        }
        return proxyQueue;
    }

    @Override
    public synchronized AsynchConsumerProxyQueue createOrderedProxyQueue(OrderingContext context, short id, short seqNumber) throws SIResourceException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createOrderedProxyQueue", (Object)context);
        }
        this.checkClosed();
        OrderedSessionProxyQueueImpl proxyQueue = new OrderedSessionProxyQueueImpl(this, id, this.conversation, context);
        this.idToProxyQueueMap.put(new ImmutableId(id), proxyQueue);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createOrderedProxyQueue", (Object)proxyQueue);
        }
        return proxyQueue;
    }

    @Override
    public synchronized void bury(ProxyQueue queue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"bury");
        }
        short id = queue.getId();
        this.mutableId.setValue(id);
        this.idToProxyQueueMap.remove(this.mutableId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"bury");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeNotification() throws SIResourceException, SIConnectionLostException, SIErrorException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeNotification");
        }
        LinkedList<ProxyQueue> closeList = null;
        ProxyQueueConversationGroupImpl proxyQueueConversationGroupImpl = this;
        synchronized (proxyQueueConversationGroupImpl) {
            if (!this.closed) {
                this.closed = true;
                closeList = new LinkedList<ProxyQueue>();
                closeList.addAll(this.idToProxyQueueMap.values());
            }
        }
        if (closeList != null) {
            SIException caughtException = null;
            for (ProxyQueue queue : closeList) {
                try {
                    if (queue.getDestinationSessionProxy() instanceof ConsumerSessionProxy) {
                        ((ConsumerSessionProxy)queue.getDestinationSessionProxy()).close(true);
                        continue;
                    }
                    queue.getDestinationSessionProxy().close();
                }
                catch (SIException e) {
                    caughtException = e;
                }
            }
            if (caughtException != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"exception caught when closing queues");
                }
                SIConnectionLostException closeException = new SIConnectionLostException(nls.getFormattedMessage("ERROR_CLOSING_PROXYQUEUE_GROUP_SICO1025", new Object[]{caughtException}, null));
                closeException.initCause((Throwable)caughtException);
                throw closeException;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeNotification");
        }
    }

    @Override
    public synchronized ProxyQueue find(short proxyQueueId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"find", (Object)("" + proxyQueueId));
        }
        this.mutableId.setValue(proxyQueueId);
        ProxyQueue retQueue = this.idToProxyQueueMap.get(this.mutableId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"find", (Object)retQueue);
        }
        return retQueue;
    }

    @Override
    public Conversation getConversation() throws SIIncorrectCallException {
        this.checkClosed();
        return this.conversation;
    }

    public Map getProxyQueues() {
        return this.idToProxyQueueMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyClose(ProxyQueue queue) {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"notifyClose", (Object)queue);
            }
            try {
                short id = queue.getId();
                this.idAllocator.releaseId(id);
                ProxyQueueConversationGroupImpl proxyQueueConversationGroupImpl = this;
                synchronized (proxyQueueConversationGroupImpl) {
                    this.idToProxyQueueMap.remove(new ImmutableId(id));
                }
            }
            catch (IdAllocatorException e) {
                FFDCFilter.processException((Throwable)((Object)e), (String)(CLASS_NAME + ".notifyClose"), (String)"2-002-0002", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyClose");
        }
    }

    private short nextId() throws SIResourceException {
        short id;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"nextId");
        }
        try {
            id = this.idAllocator.allocateId();
        }
        catch (IdAllocatorException e) {
            SIResourceException resourceException = new SIResourceException(nls.getFormattedMessage("MAX_SESSIONS_REACHED_SICO1019", new Object[]{"32767"}, null));
            resourceException.initCause((Throwable)((Object)e));
            throw resourceException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"nextId", (Object)("" + id));
        }
        return id;
    }

    private void checkClosed() throws SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkClosed", (Object)("" + this.closed));
        }
        if (this.closed) {
            throw new SIIncorrectCallException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.comms.CWSICMessages", (String)"PROXY_QUEUE_CONVERSATION_GROUP_CLOSED_SICO1059", null, (String)"PROXY_QUEUE_CONVERSATION_GROUP_CLOSED_SICO1059"));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkClosed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
        }
        ProxyQueueConversationGroupImpl proxyQueueConversationGroupImpl = this;
        synchronized (proxyQueueConversationGroupImpl) {
            if (this.closed) {
                this.idToProxyQueueMap.clear();
                this.factory.groupCloseNotification(this.conversation, this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void conversationDroppedNotification() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"conversationDroppedNotification");
        }
        LinkedList<ProxyQueue> notifyList = null;
        ProxyQueueConversationGroupImpl proxyQueueConversationGroupImpl = this;
        synchronized (proxyQueueConversationGroupImpl) {
            notifyList = new LinkedList<ProxyQueue>();
            notifyList.addAll(this.idToProxyQueueMap.values());
        }
        for (ProxyQueue queue : notifyList) {
            queue.conversationDroppedNotification();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"conversationDroppedNotification");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/impl/ProxyQueueConversationGroupImpl.java, SIB.comms, WASX.SIB, uu1215.01 1.50");
        }
    }

    private class MutableId
    extends ImmutableId {
        public MutableId() {
            super((short)0);
        }

        public void setValue(short value) {
            this.value = value;
        }
    }

    private class ImmutableId {
        protected short value;

        public ImmutableId(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object o) {
            boolean result = false;
            if (o != null && o instanceof ImmutableId) {
                result = this.value == ((ImmutableId)o).value;
            }
            return result;
        }
    }
}

