/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.clientcontainer.security;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxws.clientcontainer.security.JaxWsSSLManager;
import com.ibm.ws.jaxws.security.JaxWsSecurityConfigurationService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JaxWsSecurityConfigurationService.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=false, property={"service.vendor=IBM"})
public class JaxWsSecurityConfigurationServiceImpl
implements JaxWsSecurityConfigurationService {
    private static final TraceComponent tc = Tr.register(JaxWsSecurityConfigurationServiceImpl.class, null, null);
    private final AtomicServiceReference<SSLSupport> sslSupportSR = new AtomicServiceReference("SSLSupportService");
    static final long serialVersionUID = -4438916512306682280L;

    @Activate
    protected void activate(ComponentContext cCtx) {
        this.sslSupportSR.activate(cCtx);
    }

    @Deactivate
    protected void deactivate(ComponentContext cCtx) {
        this.sslSupportSR.deactivate(cCtx);
    }

    @Reference(name="SSLSupportService", service=SSLSupport.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSSLSupportService(ServiceReference<SSLSupport> serviceRef) {
        this.sslSupportSR.setReference(serviceRef);
        JaxWsSSLManager.init(this.sslSupportSR);
    }

    protected void unsetSSLSupportService(ServiceReference<SSLSupport> serviceRef) {
        this.sslSupportSR.unsetReference(serviceRef);
    }

    public void configBasicAuth(Conduit conduit, String userName, ProtectedString password) {
        if (null == userName || null == password) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The userName or the password is empty", (Object[])new Object[0]);
            }
            return;
        }
        if (conduit instanceof HTTPConduit) {
            HTTPConduit httpConduit = (HTTPConduit)conduit;
            AuthorizationPolicy authPolicy = httpConduit.getAuthorization();
            if (null == authPolicy) {
                authPolicy = new AuthorizationPolicy();
            }
            String decodedPwd = PasswordUtil.passwordDecode((String)new String(password.getChars()));
            authPolicy.setUserName(userName);
            authPolicy.setPassword(decodedPwd);
            httpConduit.setAuthorization(authPolicy);
        }
    }

    public void configClientSSL(Conduit conduit, String sslRef, String certAlias) {
        HTTPConduit httpConduit;
        TLSClientParameters tlsClientParams;
        HashMap<String, Object> overrideProps = new HashMap<String, Object>();
        if (null != certAlias) {
            overrideProps.put("com.ibm.ssl.keyStoreClientAlias", certAlias);
        }
        if (conduit instanceof HTTPConduit && null != (tlsClientParams = this.retriveHTTPTLSClientParametersUsingSSLRef(httpConduit = (HTTPConduit)conduit, sslRef, overrideProps))) {
            httpConduit.setTlsClientParameters(tlsClientParams);
        }
    }

    private TLSClientParameters retriveHTTPTLSClientParametersUsingSSLRef(HTTPConduit httpConduit, String sslRef, Map<String, Object> overrideProps) {
        TLSClientParameters tlsClientParams = httpConduit.getTlsClientParameters();
        SSLSocketFactory sslSocketFactory = null;
        if (!StringUtils.isEmpty((String)sslRef)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Use the sslRef = " + sslRef + " to create the SSLSocketFactory."), (Object[])new Object[0]);
            }
            sslSocketFactory = JaxWsSSLManager.getProxySSLSocketFactoryBySSLRef(sslRef, overrideProps);
        }
        if (null == sslSocketFactory) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Use the default SSL configuration of the server", (Object[])new Object[0]);
            }
            sslSocketFactory = JaxWsSSLManager.getProxyDefaultSSLSocketFactory(overrideProps);
        }
        if (null != sslSocketFactory) {
            if (null == tlsClientParams) {
                tlsClientParams = new TLSClientParameters();
            }
            tlsClientParams.setSSLSocketFactory(sslSocketFactory);
            if (null == sslRef) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Set the disableCNCheck is true as using the default server ssl configuration, and the server should trust itself.", (Object[])new Object[0]);
                }
                tlsClientParams.setDisableCNCheck(true);
            }
        }
        return tlsClientParams;
    }
}

