/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.netty.internal.tcp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.openliberty.accesslists.AddressAndHostNameAccessLists;
import java.net.InetAddress;
import java.net.InetSocketAddress;

@ChannelHandler.Sharable
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AccessListHandler
extends ChannelInboundHandlerAdapter {
    private static final TraceComponent tc = Tr.register(AccessListHandler.class, (String)"Netty", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    AddressAndHostNameAccessLists accessLists;
    static final long serialVersionUID = 5113544750097867721L;

    public AccessListHandler(AddressAndHostNameAccessLists acl) {
        this.accessLists = acl;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        InetAddress addr = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress();
        if (this.accessLists.accessDenied(addr)) {
            ctx.close();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("connection rejected due to access list configuration: " + ctx.channel()), (Object[])new Object[0]);
            }
        } else {
            super.channelActive(ctx);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }
}

