/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine.processor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.injectionengine.processor.DataSourceDefinitionInjectionBinding;
import com.ibm.ws.javaee.dd.common.DataSource;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionProcessor;
import jakarta.annotation.sql.DataSourceDefinition;
import jakarta.annotation.sql.DataSourceDefinitions;
import java.lang.reflect.Member;
import java.util.List;

public class DataSourceDefinitionProcessor
extends InjectionProcessor<DataSourceDefinition, DataSourceDefinitions> {
    private static final TraceComponent tc = Tr.register(DataSourceDefinitionProcessor.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");

    public DataSourceDefinitionProcessor() {
        super(DataSourceDefinition.class, DataSourceDefinitions.class);
    }

    @Override
    public void processXML() throws InjectionException {
        List<? extends DataSource> dsds;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processXML : " + this), (Object[])new Object[0]);
        }
        if ((dsds = this.ivNameSpaceConfig.getDataSourceDefinitions()) != null) {
            for (DataSource dataSource : dsds) {
                DataSourceDefinitionInjectionBinding binding;
                String jndiName = dataSource.getName();
                InjectionBinding injectionBinding = (InjectionBinding)this.ivAllAnnotationsCollection.get(jndiName);
                if (injectionBinding != null) {
                    binding = (DataSourceDefinitionInjectionBinding)injectionBinding;
                } else {
                    binding = new DataSourceDefinitionInjectionBinding(jndiName, this.ivNameSpaceConfig);
                    this.addInjectionBinding(binding);
                }
                binding.mergeXML(dataSource);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processXML : " + this));
        }
    }

    @Override
    public void resolve(InjectionBinding<DataSourceDefinition> binding) throws InjectionException {
        ((DataSourceDefinitionInjectionBinding)binding).resolve();
    }

    @Override
    public InjectionBinding<DataSourceDefinition> createInjectionBinding(DataSourceDefinition annotation, Class<?> instanceClass, Member member, String jndiName) throws InjectionException {
        DataSourceDefinitionInjectionBinding injectionBinding = new DataSourceDefinitionInjectionBinding(jndiName, this.ivNameSpaceConfig);
        injectionBinding.merge(annotation, instanceClass, (Member)null);
        return injectionBinding;
    }

    @Override
    public String getJndiName(DataSourceDefinition annotation) {
        return annotation.name();
    }

    public DataSourceDefinition[] getAnnotations(DataSourceDefinitions annotation) {
        return annotation.value();
    }
}

