/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.metatype.EquinoxAttributeDefinition;
import org.eclipse.equinox.metatype.impl.ExtendableHelper;
import org.eclipse.equinox.metatype.impl.LocalizationElement;
import org.eclipse.equinox.metatype.impl.LogTracker;
import org.eclipse.equinox.metatype.impl.MetaTypeInformationImpl;
import org.eclipse.equinox.metatype.impl.MetaTypeMsg;
import org.eclipse.equinox.metatype.impl.Persistence;
import org.eclipse.equinox.metatype.impl.ValueTokenizer;
import org.eclipse.osgi.util.NLS;

public class AttributeDefinitionImpl
extends LocalizationElement
implements EquinoxAttributeDefinition,
Cloneable {
    private final String _name;
    private final String _id;
    private final String _description;
    private final int _cardinality;
    private final int _dataType;
    private final Object _minValue;
    private final Object _maxValue;
    private final boolean _isRequired;
    private final LogTracker logger;
    private final ExtendableHelper helper;
    private volatile String[] _defaults = null;
    private volatile ArrayList<String> _values = new ArrayList(7);
    private volatile ArrayList<String> _labels = new ArrayList(7);

    public AttributeDefinitionImpl(String id, String name, String description, int type, int cardinality, Object min, Object max, boolean isRequired, String localization, LogTracker logger, Map<String, Map<String, String>> extensionAttributes) {
        this(id, name, description, type, cardinality, min, max, isRequired, localization, logger, new ExtendableHelper(extensionAttributes));
    }

    private AttributeDefinitionImpl(String id, String name, String description, int type, int cardinality, Object min, Object max, boolean isRequired, String localization, LogTracker logger, ExtendableHelper helper) {
        super(localization);
        this._id = id;
        this._name = name;
        this._description = description;
        this._dataType = type;
        this._cardinality = cardinality;
        this._minValue = min;
        this._maxValue = max;
        this._isRequired = isRequired;
        this.logger = logger;
        this.helper = helper;
    }

    public Object clone() {
        AttributeDefinitionImpl ad = new AttributeDefinitionImpl(this._id, this._name, this._description, this._dataType, this._cardinality, this._minValue, this._maxValue, this._isRequired, this.getLocalization(), this.logger, this.helper);
        String[] curDefaults = this._defaults;
        if (curDefaults != null) {
            ad.setDefaultValue((String[])curDefaults.clone());
        }
        ArrayList labels = (ArrayList)this._labels.clone();
        ArrayList values = (ArrayList)this._values.clone();
        ad.setOption(labels, values, false);
        return ad;
    }

    @Override
    public String getName() {
        return this.getLocalized(this._name);
    }

    @Override
    public String getID() {
        return this._id;
    }

    @Override
    public String getDescription() {
        return this.getLocalized(this._description);
    }

    @Override
    public int getCardinality() {
        return this._cardinality;
    }

    @Override
    public int getType() {
        return this._dataType;
    }

    boolean isRequired() {
        return this._isRequired;
    }

    @Override
    public String[] getOptionLabels() {
        ArrayList<String> curLabels = this._labels;
        if (curLabels.isEmpty()) {
            return null;
        }
        String[] returnedLabels = new String[curLabels.size()];
        int i = 0;
        for (String labelKey : curLabels) {
            returnedLabels[i] = this.getLocalized(labelKey);
            ++i;
        }
        return returnedLabels;
    }

    @Override
    public String[] getOptionValues() {
        ArrayList<String> curValues = this._values;
        if (curValues.isEmpty()) {
            return null;
        }
        return curValues.toArray(MetaTypeInformationImpl.emptyStringArray);
    }

    void setOption(ArrayList<String> labels, ArrayList<String> values, boolean needValidation) {
        if (labels == null || values == null) {
            this.logger.log(1, NLS.bind((String)MetaTypeMsg.NULL_OPTIONS, (Object)this.getID()));
            return;
        }
        if (labels.size() != values.size()) {
            this.logger.log(1, NLS.bind((String)MetaTypeMsg.INCONSISTENT_OPTIONS, (Object)this.getID()));
            return;
        }
        if (needValidation) {
            int index = 0;
            while (index < values.size()) {
                ValueTokenizer vt = new ValueTokenizer(values.get(index), this.logger);
                values.set(index, vt.getValuesAsString());
                String reason = vt.validate(this);
                if (reason != null && reason.length() > 0) {
                    this.logger.log(2, NLS.bind((String)MetaTypeMsg.INVALID_OPTIONS, (Object[])new Object[]{values.get(index), this.getID(), reason}));
                    labels.remove(index);
                    values.remove(index);
                    --index;
                }
                ++index;
            }
        }
        this._labels = labels;
        this._values = values;
    }

    boolean containsInvalidValue(String value) {
        ArrayList<String> curValues = this._values;
        return !curValues.isEmpty() && !curValues.contains(value);
    }

    @Override
    public String[] getDefaultValue() {
        return this._defaults;
    }

    void setDefaultValue(String defaults_str, boolean needValidation) {
        ValueTokenizer vt = new ValueTokenizer(defaults_str, this.logger);
        String reason = vt.validate(this);
        if (reason != null && reason.length() > 0) {
            this.logger.log(2, NLS.bind((String)MetaTypeMsg.INVALID_DEFAULTS, (Object[])new Object[]{vt.getValuesAsString(), this.getID(), reason}));
            return;
        }
        String[] defaults = vt.getValuesAsArray();
        if (this._cardinality != 0 && defaults.length == 1 && defaults[0].length() == 0) {
            this.setDefaultValue(new String[0]);
        } else {
            this.setDefaultValue(vt.getValuesAsArray());
        }
    }

    private void setDefaultValue(String[] defaults) {
        this._defaults = defaults;
    }

    @Override
    public String validate(String value) {
        ValueTokenizer vt = new ValueTokenizer(value, this.logger);
        return vt.validate(this);
    }

    @Override
    public Map<String, String> getExtensionAttributes(String schema) {
        return this.helper.getExtensionAttributes(schema);
    }

    @Override
    public Set<String> getExtensionUris() {
        return this.helper.getExtensionUris();
    }

    @Override
    public String getMax() {
        return this._maxValue == null ? null : String.valueOf(this._maxValue);
    }

    @Override
    public String getMin() {
        return this._minValue == null ? null : String.valueOf(this._minValue);
    }

    Object getMaxValue() {
        return this._maxValue;
    }

    Object getMinValue() {
        return this._minValue;
    }

    void getStrings(Set<String> strings) {
        String[] curDefaults = this._defaults;
        if (curDefaults != null) {
            String[] stringArray = curDefaults;
            int n = curDefaults.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                strings.add(string);
                ++n2;
            }
        }
        strings.add(this._description);
        strings.add(this._id);
        strings.add(this._name);
        strings.add(this.getLocalization());
        for (String string : this._values) {
            strings.add(string);
        }
        for (String string : this._labels) {
            strings.add(string);
        }
        this.helper.getStrings(strings);
        if (this.getType() == 1 || this.getType() == 12) {
            if (this._maxValue != null) {
                strings.add(this.getMax());
            }
            if (this._minValue != null) {
                strings.add(this.getMin());
            }
        }
    }

    public static AttributeDefinitionImpl load(Persistence.Reader reader, LogTracker logger) throws IOException {
        String id = reader.readString();
        String description = reader.readString();
        String name = reader.readString();
        int type = reader.readInt();
        int cardinality = reader.readInt();
        boolean isRequired = reader.readBoolean();
        String localization = reader.readString();
        String[] defaults = null;
        if (reader.readBoolean()) {
            int numDefaults = reader.readInt();
            defaults = new String[numDefaults];
            int i = 0;
            while (i < numDefaults) {
                defaults[i] = reader.readString();
                ++i;
            }
        }
        int numLabels = reader.readInt();
        ArrayList<String> labels = new ArrayList<String>(numLabels);
        int i = 0;
        while (i < numLabels) {
            labels.add(reader.readString());
            ++i;
        }
        int numValues = reader.readInt();
        ArrayList<String> values = new ArrayList<String>();
        int i2 = 0;
        while (i2 < numValues) {
            values.add(reader.readString());
            ++i2;
        }
        ExtendableHelper helper = ExtendableHelper.load(reader);
        Object min = AttributeDefinitionImpl.readMinMax(type, reader);
        Object max = AttributeDefinitionImpl.readMinMax(type, reader);
        AttributeDefinitionImpl result = new AttributeDefinitionImpl(id, name, description, type, cardinality, min, max, isRequired, localization, logger, helper);
        result.setDefaultValue(defaults);
        result.setOption(labels, values, false);
        return result;
    }

    public void write(Persistence.Writer writer) throws IOException {
        writer.writeString(this._id);
        writer.writeString(this._description);
        writer.writeString(this._name);
        writer.writeInt(this._dataType);
        writer.writeInt(this._cardinality);
        writer.writeBoolean(this._isRequired);
        writer.writeString(this.getLocalization());
        String[] curDefaults = this._defaults;
        if (curDefaults == null) {
            writer.writeBoolean(false);
        } else {
            writer.writeBoolean(true);
            writer.writeInt(curDefaults.length);
            String[] stringArray = curDefaults;
            int n = curDefaults.length;
            int n2 = 0;
            while (n2 < n) {
                String defaultValue = stringArray[n2];
                writer.writeString(defaultValue);
                ++n2;
            }
        }
        ArrayList<String> curLabels = this._labels;
        writer.writeInt(curLabels.size());
        for (String label : curLabels) {
            writer.writeString(label);
        }
        ArrayList<String> curValues = this._values;
        writer.writeInt(curValues.size());
        for (String value : curValues) {
            writer.writeString(value);
        }
        this.helper.write(writer);
        this.writeMinMax(this._minValue, writer);
        this.writeMinMax(this._maxValue, writer);
    }

    private static Object readMinMax(int dataType, Persistence.Reader reader) throws IOException {
        boolean isNull = reader.readBoolean();
        if (isNull) {
            return null;
        }
        switch (dataType) {
            case 1: 
            case 12: {
                return reader.readString();
            }
            case 2: {
                return reader.readLong();
            }
            case 3: {
                return reader.readInt();
            }
            case 4: {
                return reader.readShort();
            }
            case 5: {
                return Character.valueOf(reader.readCharacter());
            }
            case 6: {
                return reader.readByte();
            }
            case 7: {
                return reader.readDouble();
            }
            case 8: {
                return Float.valueOf(reader.readFloat());
            }
            case 9: {
                return new BigInteger(reader.readString());
            }
            case 10: {
                return new BigDecimal(reader.readString());
            }
            case 11: {
                return reader.readBoolean();
            }
        }
        return reader.readString();
    }

    private void writeMinMax(Object v, Persistence.Writer writer) throws IOException {
        if (v == null) {
            writer.writeBoolean(true);
            return;
        }
        writer.writeBoolean(false);
        switch (this._dataType) {
            case 1: 
            case 12: {
                writer.writeString((String)v);
                return;
            }
            case 2: {
                writer.writeLong((Long)v);
                return;
            }
            case 3: {
                writer.writeInt((Integer)v);
                return;
            }
            case 4: {
                writer.writeShort((Short)v);
                return;
            }
            case 5: {
                writer.writeCharacter((Character)v);
                return;
            }
            case 6: {
                writer.writeByte((Byte)v);
                return;
            }
            case 7: {
                writer.writeDouble((Double)v);
                return;
            }
            case 8: {
                writer.writeFloat((Float)v);
                return;
            }
            case 9: {
                writer.writeString(v.toString());
                return;
            }
            case 10: {
                writer.writeString(v.toString());
                return;
            }
            case 11: {
                writer.writeBoolean((Boolean)v);
                return;
            }
        }
        writer.writeString(String.valueOf(v));
    }
}

