/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sequencing;

import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sequencing.QuerySequence;
import org.eclipse.persistence.sequencing.TableSequence;

public class NativeSequence
extends QuerySequence {
    protected boolean shouldUseIdentityIfPlatformSupports = true;
    protected boolean shouldUseGeneratedKeysIfPlatformSupports = false;
    protected QuerySequence delegateSequence;

    public NativeSequence() {
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(boolean shouldUseIdentityIfPlatformSupports) {
        this.setShouldSkipUpdate(true);
        this.setShouldUseIdentityIfPlatformSupports(shouldUseIdentityIfPlatformSupports);
    }

    public NativeSequence(String name) {
        super(name);
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(String name, boolean shouldUseIdentityIfPlatformSupports) {
        super(name);
        this.setShouldSkipUpdate(true);
        this.setShouldUseIdentityIfPlatformSupports(shouldUseIdentityIfPlatformSupports);
    }

    public NativeSequence(String name, int size) {
        super(name, size);
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(String name, int size, boolean shouldUseIdentityIfPlatformSupports) {
        super(name, size);
        this.setShouldSkipUpdate(true);
        this.setShouldUseIdentityIfPlatformSupports(shouldUseIdentityIfPlatformSupports);
    }

    public NativeSequence(String name, int size, int initialValue) {
        super(name, size, initialValue);
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(String name, int size, int initialValue, boolean shouldUseIdentityIfPlatformSupports) {
        super(name, size, initialValue);
        this.setShouldSkipUpdate(true);
        this.setShouldUseIdentityIfPlatformSupports(shouldUseIdentityIfPlatformSupports);
    }

    @Override
    public boolean isNative() {
        if (this.delegateSequence != null) {
            return this.delegateSequence.isNative();
        }
        return true;
    }

    public void setShouldUseIdentityIfPlatformSupports(boolean shouldUseIdentityIfPlatformSupports) {
        this.shouldUseIdentityIfPlatformSupports = shouldUseIdentityIfPlatformSupports;
    }

    public boolean shouldUseIdentityIfPlatformSupports() {
        return this.shouldUseIdentityIfPlatformSupports;
    }

    public void setShouldUseGeneratedKeysIfPlatformSupports(boolean shouldUseGeneratedKeysIfPlatformSupports) {
        this.shouldUseGeneratedKeysIfPlatformSupports = shouldUseGeneratedKeysIfPlatformSupports;
    }

    public boolean shouldUseGeneratedKeysIfPlatformSupports() {
        return this.shouldUseGeneratedKeysIfPlatformSupports;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NativeSequence) {
            return NativeSequence.equalNameAndSize(this, (NativeSequence)obj);
        }
        return false;
    }

    @Override
    protected ValueReadQuery buildSelectQuery() {
        if (this.delegateSequence != null) {
            return this.delegateSequence.buildSelectQuery();
        }
        if (this.shouldAcquireValueAfterInsert()) {
            return ((DatasourcePlatform)this.getDatasourcePlatform()).buildSelectQueryForIdentity();
        }
        return ((DatasourcePlatform)this.getDatasourcePlatform()).buildSelectQueryForSequenceObject();
    }

    @Override
    protected ValueReadQuery buildSelectQuery(String seqName, Integer size) {
        if (this.delegateSequence != null) {
            return this.delegateSequence.buildSelectQuery(seqName, size);
        }
        if (this.shouldAcquireValueAfterInsert()) {
            return ((DatabasePlatform)this.getDatasourcePlatform()).buildSelectQueryForIdentity(this.getQualified(seqName), size);
        }
        return ((DatasourcePlatform)this.getDatasourcePlatform()).buildSelectQueryForSequenceObject(this.getQualified(seqName), size);
    }

    public boolean hasDelegateSequence() {
        return this.delegateSequence != null;
    }

    public QuerySequence getDelegateSequence() {
        return this.delegateSequence;
    }

    public void setDelegateSequence(QuerySequence delegateSequence) {
        this.delegateSequence = delegateSequence;
    }

    @Override
    public void onConnect() {
        DatasourcePlatform platform = (DatasourcePlatform)this.getDatasourcePlatform();
        if ((platform.supportsIdentity() || platform.supportsReturnGeneratedKeys()) && this.shouldUseIdentityIfPlatformSupports()) {
            this.setShouldAcquireValueAfterInsert(true);
            if (platform.supportsReturnGeneratedKeys()) {
                this.setShouldUseGeneratedKeysIfPlatformSupports(true);
            }
        } else if (platform.supportsSequenceObjects() && !this.shouldUseIdentityIfPlatformSupports()) {
            this.setShouldAcquireValueAfterInsert(false);
        } else {
            if (platform.getDefaultNativeSequenceToTable() || !platform.supportsNativeSequenceNumbers()) {
                this.delegateSequence = new TableSequence();
                this.delegateSequence.setName(this.getName());
                this.delegateSequence.onConnect(platform);
                this.setShouldUseTransaction(this.delegateSequence.shouldUseTransaction());
                this.setShouldAcquireValueAfterInsert(this.delegateSequence.shouldAcquireValueAfterInsert());
                this.setShouldSkipUpdate(this.delegateSequence.shouldSkipUpdate());
                this.setShouldSelectBeforeUpdate(this.delegateSequence.shouldSelectBeforeUpdate());
                this.setUpdateQuery(this.delegateSequence.getUpdateQuery());
                super.onConnect();
                return;
            }
            this.setShouldAcquireValueAfterInsert(platform.supportsIdentity());
        }
        this.setShouldUseTransaction(platform.shouldNativeSequenceUseTransaction());
        super.onConnect();
    }

    @Override
    public void onDisconnect() {
        this.delegateSequence = null;
        this.setShouldAcquireValueAfterInsert(false);
        this.setShouldUseTransaction(false);
        super.onDisconnect();
    }
}

