/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Holder;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class HolderInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String CLIENT_HOLDERS = "client.holders";
    private static final Logger LOG = LogUtils.getLogger(HolderInInterceptor.class);
    static final long serialVersionUID = 6178149571167058723L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HolderInInterceptor() {
        super("pre-invoke");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.HolderInInterceptor", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.HolderInInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(@Sensitive Message message) throws Fault {
        Exchange exchange;
        BindingOperationInfo bop;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive org.apache.cxf.message.Message>";
            LOG.entering("org.apache.cxf.jaxws.interceptors.HolderInInterceptor", "handleMessage", objectArray);
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        MessageContentsList inObjects = MessageContentsList.getContentsList((Message)message);
        if (isFinestEnabled) {
            LOG.finest("MessageContentsList that is obtained from message: " + inObjects);
        }
        if ((bop = (exchange = message.getExchange()).getBindingOperationInfo()) == null) {
            if (isFinestEnabled) {
                LOG.finest("BindingOperationInfo is null. handleMessage won't be executing.");
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.interceptors.HolderInInterceptor", "handleMessage");
            }
            return;
        }
        OperationInfo op = bop.getOperationInfo();
        if (op == null || !op.hasOutput() || op.getOutput().size() == 0) {
            if (isFinestEnabled) {
                LOG.finest("OperationInfo is null or empty. handleMessage won't be executing.");
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.interceptors.HolderInInterceptor", "handleMessage");
            }
            return;
        }
        List parts = op.getOutput().getMessageParts();
        boolean client = this.isRequestor(message);
        if (isFinestEnabled) {
            LOG.finest("Is requestor: " + client);
        }
        if (client) {
            List outHolders = CastUtils.cast((List)((List)message.getExchange().getOutMessage().get((Object)CLIENT_HOLDERS)));
            for (MessagePartInfo part : parts) {
                Holder holder;
                if (part.getIndex() == 0 || part.getTypeClass() == null || (holder = (Holder)outHolders.get(part.getIndex() - 1)) == null) continue;
                holder.value = inObjects.get(part);
                inObjects.put(part, (Object)holder);
                if (!isFinestEnabled) continue;
                LOG.finest("Holder added to message content list for client side: " + holder);
            }
        } else {
            for (MessagePartInfo part : parts) {
                int idx = part.getIndex() - 1;
                if (idx < 0 || part.getTypeClass() == null) continue;
                if (inObjects == null) {
                    inObjects = new MessageContentsList();
                    message.setContent(List.class, (Object)inObjects);
                    if (isFinestEnabled) {
                        LOG.finest("Null message contents list is replaced with an empty one for server side.");
                    }
                }
                if (idx >= inObjects.size()) {
                    inObjects.set(idx, (Object)new Holder());
                    if (!isFinestEnabled) continue;
                    LOG.finest("Message contents list is enlarged to match message parts size for server side with new empty Holder<Object>().");
                    continue;
                }
                Object o = inObjects.get(idx);
                inObjects.set(idx, (Object)new Holder(o));
                if (!isFinestEnabled) continue;
                LOG.finest("The object in message contents list is wrapped in a holder:" + inObjects.get(idx));
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.HolderInInterceptor", "handleMessage");
        }
    }
}

