/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.wim.Service;
import com.ibm.websphere.security.wim.ras.WIMTraceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.ConfigManager;
import com.ibm.ws.security.wim.ProfileManager;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Root;
import java.rmi.RemoteException;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServiceProvider
implements Service {
    private static final TraceComponent tc = Tr.register(ServiceProvider.class, (String)"wimUtil", (String)"com.ibm.ws.security.wim.util.resources.WimUtilMessages");
    private static final AtomicServiceReference<ConfigManager> configRef = new AtomicServiceReference("vmmConfiguration");
    private static final AtomicServiceReference<ProfileManager> profileManager = new AtomicServiceReference("profileservice");
    private volatile boolean activated = false;
    static final long serialVersionUID = -2221659684809742819L;

    protected void setProfileservice(ServiceReference<ProfileManager> ref) {
        profileManager.setReference(ref);
    }

    public static ProfileManager getProfileService() {
        return (ProfileManager)profileManager.getService();
    }

    protected void unsetProfileservice(ServiceReference<ProfileManager> ref) {
        profileManager.unsetReference(ref);
    }

    public void activate(ComponentContext cc, Map<String, Object> properties) {
        profileManager.activate(cc);
        configRef.activate(cc);
        this.activated = true;
        this.updateFederatedManagerService();
    }

    public void deactivate(ComponentContext cc) {
        this.activated = false;
        Tr.info((TraceComponent)tc, (String)"FEDERATED_MANAGER_SERVICE_STOPPED", (Object[])new Object[0]);
        profileManager.deactivate(cc);
        configRef.deactivate(cc);
    }

    protected void setConfiguration(ServiceReference<ConfigManager> reference) {
        configRef.setReference(reference);
    }

    protected void unsetConfiguration(ServiceReference<ConfigManager> reference) {
        configRef.unsetReference(reference);
    }

    private void updateFederatedManagerService() {
        if (!this.activated) {
            return;
        }
        if (profileManager.getReference() != null) {
            Tr.info((TraceComponent)tc, (String)"FEDERATED_MANAGER_SERVICE_READY", (Object[])new Object[0]);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Some required federated manager services are not available.", (Object[])new Object[0]);
        }
    }

    public Root createRootObject() throws WIMException {
        String METHODNAME = "createRootObject";
        Root result = null;
        result = new Root();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createRootObject " + WIMTraceHelper.trace((Object)result)), (Object[])new Object[0]);
        }
        return result;
    }

    public Root get(Root root) throws WIMException {
        String METHODNAME = "get";
        Root result = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("get " + WIMTraceHelper.trace((Object)root)), (Object[])new Object[0]);
        }
        result = ServiceProvider.getProfileService().get(root);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("get " + WIMTraceHelper.trace((Object)result)), (Object[])new Object[0]);
        }
        return result;
    }

    public Root search(Root root) throws WIMException {
        String METHODNAME = "search";
        Root result = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("search " + WIMTraceHelper.trace((Object)root)), (Object[])new Object[0]);
        }
        result = ServiceProvider.getProfileService().search(root);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("search " + WIMTraceHelper.trace((Object)result)), (Object[])new Object[0]);
        }
        return result;
    }

    public Root login(Root root) throws WIMException {
        String METHODNAME = "login";
        Root result = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("login " + WIMTraceHelper.trace((Object)root)), (Object[])new Object[0]);
        }
        result = ServiceProvider.getProfileService().login(root);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("login " + WIMTraceHelper.trace((Object)result)), (Object[])new Object[0]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Root delete(Root root) throws WIMException {
        Root result = null;
        try {
            result = ServiceProvider.getProfileService().delete(root);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.wim.ServiceProvider", (String)"176", (Object)this, (Object[])new Object[]{root});
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Root create(Root root) throws WIMException {
        Root result = null;
        try {
            result = ServiceProvider.getProfileService().create(root);
        }
        catch (Exception exception) {
            void toCatch;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.wim.ServiceProvider", (String)"214", (Object)this, (Object[])new Object[]{root});
            toCatch.getMessage();
        }
        return result;
    }

    public String getRealmName() throws WIMException {
        String result = null;
        result = ServiceProvider.getProfileService().getDefaultRealmName();
        return result;
    }

    public Root update(Root root) throws WIMException, RemoteException {
        return null;
    }
}

