/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.IdGenerator;
import com.ibm.websphere.servlet.cache.MetaDataGenerator;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.command.CommandCacheProcessor;
import com.ibm.ws.cache.config.CacheId;
import com.ibm.ws.cache.config.Component;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.Invalidation;
import com.ibm.ws.cache.config.Property;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.ESISupport;
import com.ibm.ws.cache.servlet.FragmentInfo;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.servlet.Servlet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public class FragmentCacheProcessor
extends CommandCacheProcessor {
    protected static TraceComponent tc = Tr.register(FragmentCacheProcessor.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static final String PROPERTY_EDGEABLE = "edgeable";
    public static final String PROPERTY_CONSUME_SUBFRAGMENTS = "consume-subfragments";
    public static final String PROPERTY_DO_NOT_CONSUME = "do-not-consume";
    public static final String PROPERTY_EXTERNALCACHE = "externalcache";
    public static final String PROPERTY_ALTERNATE_URL = "alternate_url";
    public static final String PROPERTY_SAVE_ATTRIBUTES = "save-attributes";
    public static final String PROPERTY_STORE_COOKIES = "store-cookies";
    public static final String PROPERTY_IGNORE_GET_POST = "ignore-get-post";
    public static final String PROPERTY_IGNORE_CHAR_ENCODING = "ignore-char-encoding";
    protected static final int SLOT_EDGEABLE = 6;
    protected static final int SLOT_CONSUME_SUBFRAGMENTS = 7;
    protected static final int SLOT_EXTERNALCACHE = 8;
    protected static final int SLOT_ALTERNATE_URL = 9;
    protected static final int SLOT_CONTAINS_EDGEABLE_PATHINFO = 10;
    protected static final int SLOT_ESI_VALUE_CACHE = 11;
    protected static final int SLOT_ESI_PATHINFO_VALUES = 12;
    protected static final int SLOT_CONTAINS_EDGEABLE_SERVLETPATH = 13;
    protected static final int SLOT_ESI_SERVLETPATH_VALUES = 14;
    protected static final int SLOT_SAVE_ATTRIBUTES = 15;
    protected static final int SLOT_STORE_COOKIES = 16;
    protected static final int SLOT_DO_NOT_CONSUME = 17;
    protected static final int SLOT_ATTRIBUTE_EXCLUDE_LIST = 18;
    protected static final int SLOT_IGNORE_GET_POST = 19;
    protected static final int SLOT_COOKIE_EXCLUDE_LIST = 20;
    protected static final int SLOT_CONSUME_EXCLUDE_LIST = 21;
    protected static final int SLOT_IGNORE_CHAR_ENCODING = 22;
    protected static final int PROCESSOR_SLOTS = 23;
    protected CacheProxyRequest request = null;
    protected CacheProxyResponse response = null;
    protected static HashMap ESICache = new HashMap();
    protected static HashMap ESIQueryCache = new HashMap();
    String externalCacheGroupId;
    boolean edgeable = false;
    String esiQueryString = null;
    String esiId = null;
    boolean consumeSubfragments = false;
    boolean doNotConsume = false;
    String baseName = null;
    String altUrl = null;
    String pathInfo = null;
    String servletpath = null;
    boolean ignoreGetPost = false;
    boolean ignoreCharEnc = false;
    String[] consumeExcludeList = null;
    HashMap rrdRules = new HashMap(2);

    @Override
    public void reset(ConfigEntry ce) {
        super.reset(ce);
        this.request = null;
        this.response = null;
        this.externalCacheGroupId = null;
        this.consumeSubfragments = false;
        this.doNotConsume = false;
        this.edgeable = false;
        this.altUrl = null;
        this.pathInfo = null;
        this.servletpath = null;
        if (ce != null) {
            this.sharingPolicy = ce.sharingPolicy;
        }
        this.esiQueryString = null;
        this.esiId = null;
        this.baseName = null;
        this.ignoreGetPost = false;
        this.ignoreCharEnc = false;
        this.consumeExcludeList = null;
        this.rrdRules.clear();
    }

    public boolean preProcess(ConfigEntry configEntry) {
        int i;
        String[] excludeList;
        String val;
        configEntry.processorData = new Object[23];
        boolean valid = super.preProcess(configEntry);
        Property p = (Property)configEntry.properties.get(PROPERTY_EDGEABLE);
        String string = val = p != null ? p.value : null;
        if (val != null) {
            val = val.trim();
        }
        Boolean b = new Boolean(val);
        configEntry.processorData[6] = b;
        if (b.booleanValue()) {
            p = (Property)configEntry.properties.get(PROPERTY_ALTERNATE_URL);
            String string2 = val = p != null ? p.value : null;
            if (val != null) {
                val = val.trim();
                configEntry.processorData[9] = val;
            }
        }
        String string3 = val = (p = (Property)configEntry.properties.get(PROPERTY_CONSUME_SUBFRAGMENTS)) != null ? p.value : null;
        if (val != null) {
            val = val.trim();
            excludeList = null;
            if (p != null && p.excludeList != null) {
                excludeList = new String[p.excludeList.length];
                for (i = 0; i < p.excludeList.length; ++i) {
                    excludeList[i] = p.excludeList[i];
                }
            }
            configEntry.processorData[21] = excludeList;
        }
        configEntry.processorData[7] = new Boolean(val);
        p = (Property)configEntry.properties.get(PROPERTY_DO_NOT_CONSUME);
        String string4 = val = p != null ? p.value : null;
        if (val != null) {
            val = val.trim();
        }
        configEntry.processorData[17] = new Boolean(val);
        p = (Property)configEntry.properties.get(PROPERTY_EXTERNALCACHE);
        String string5 = val = p != null ? p.value : null;
        if (val != null) {
            val = val.trim();
            configEntry.processorData[8] = val;
        }
        String string6 = val = (p = (Property)configEntry.properties.get(PROPERTY_SAVE_ATTRIBUTES)) != null ? p.value : null;
        if (val != null) {
            val = val.trim();
            b = new Boolean(val);
            excludeList = null;
            if (p != null && p.excludeList != null) {
                excludeList = new String[p.excludeList.length];
                for (i = 0; i < p.excludeList.length; ++i) {
                    excludeList[i] = p.excludeList[i];
                }
            }
            configEntry.processorData[18] = excludeList;
        } else {
            b = Boolean.TRUE;
        }
        configEntry.processorData[15] = b;
        p = (Property)configEntry.properties.get(PROPERTY_STORE_COOKIES);
        val = p != null ? p.value : null;
        configEntry.processorData[16] = val;
        if (val != null) {
            excludeList = null;
            if (p != null && p.excludeList != null) {
                excludeList = new String[p.excludeList.length];
                for (i = 0; i < p.excludeList.length; ++i) {
                    excludeList[i] = p.excludeList[i];
                }
            }
            configEntry.processorData[20] = excludeList;
        }
        String string7 = val = (p = (Property)configEntry.properties.get(PROPERTY_IGNORE_GET_POST)) != null ? p.value : null;
        if (val != null) {
            val = val.trim();
        }
        configEntry.processorData[19] = new Boolean(val);
        p = (Property)configEntry.properties.get(PROPERTY_IGNORE_CHAR_ENCODING);
        String string8 = val = p != null ? p.value : null;
        if (val != null) {
            val = val.trim();
        }
        configEntry.processorData[22] = new Boolean(val);
        for (int i2 = 0; i2 < configEntry.cacheIds.length; ++i2) {
            valid &= this.preProcess(configEntry.cacheIds[i2]);
        }
        boolean edgeablePathInfo = false;
        boolean edgeableServletPath = false;
        Boolean gb = (Boolean)configEntry.processorData[6];
        boolean globalEdgeable = gb != null && gb != false;
        for (int i3 = 0; i3 < configEntry.cacheIds.length; ++i3) {
            CacheId ci = configEntry.cacheIds[i3];
            b = (Boolean)ci.processorData[6];
            if (!globalEdgeable && (b == null || !b.booleanValue())) continue;
            for (int j = 0; j < ci.components.length; ++j) {
                HashSet hs;
                if (ci.components[j].iType == 12) {
                    edgeablePathInfo = true;
                    hs = (HashSet)configEntry.processorData[12];
                    if (hs == null) {
                        hs = new HashSet();
                    }
                    hs.addAll(ci.components[j].values.keySet());
                    configEntry.processorData[12] = hs;
                    continue;
                }
                if (ci.components[j].iType != 13) continue;
                edgeableServletPath = true;
                hs = (HashSet)configEntry.processorData[14];
                if (hs == null) {
                    hs = new HashSet();
                }
                hs.addAll(ci.components[j].values.keySet());
                configEntry.processorData[14] = hs;
            }
        }
        configEntry.processorData[10] = new Boolean(edgeablePathInfo);
        configEntry.processorData[13] = new Boolean(edgeableServletPath);
        if (edgeablePathInfo || edgeableServletPath) {
            configEntry.processorData[11] = new HashMap();
        }
        return valid;
    }

    public boolean preProcess(CacheId cacheId) {
        cacheId.processorData = new Object[23];
        boolean valid = super.preProcess(cacheId);
        if (cacheId.properties != null) {
            String val;
            Property p = (Property)cacheId.properties.get(PROPERTY_EDGEABLE);
            String string = val = p != null ? p.value : null;
            if (val != null) {
                val = val.trim();
                Boolean b = new Boolean(val);
                cacheId.processorData[6] = b;
                if (b.booleanValue()) {
                    p = (Property)cacheId.properties.get(PROPERTY_ALTERNATE_URL);
                    String string2 = val = p != null ? p.value : null;
                    if (val != null) {
                        val = val.trim();
                        cacheId.processorData[9] = val;
                    }
                }
            }
            if (cacheId.processorData[7] == null || !((Boolean)cacheId.processorData[7]).booleanValue()) {
                p = (Property)cacheId.properties.get(PROPERTY_CONSUME_SUBFRAGMENTS);
                String string3 = val = p != null ? p.value : null;
                if (val != null) {
                    val = val.trim();
                    String[] excludeList = null;
                    if (p != null && p.excludeList != null) {
                        excludeList = new String[p.excludeList.length];
                        for (int i = 0; i < p.excludeList.length; ++i) {
                            excludeList[i] = p.excludeList[i];
                        }
                    }
                    cacheId.processorData[21] = excludeList;
                    cacheId.processorData[7] = new Boolean(val);
                }
            }
            if (cacheId.processorData[17] == null || !((Boolean)cacheId.processorData[17]).booleanValue()) {
                p = (Property)cacheId.properties.get(PROPERTY_DO_NOT_CONSUME);
                String string4 = val = p != null ? p.value : null;
                if (val != null) {
                    val = val.trim();
                    cacheId.processorData[17] = new Boolean(val);
                }
            }
            String string5 = val = (p = (Property)cacheId.properties.get(PROPERTY_EXTERNALCACHE)) != null ? p.value : null;
            if (val != null) {
                val = val.trim();
                cacheId.processorData[8] = val;
            }
            if (cacheId.processorData[19] == null || !((Boolean)cacheId.processorData[19]).booleanValue()) {
                p = (Property)cacheId.properties.get(PROPERTY_IGNORE_GET_POST);
                String string6 = val = p != null ? p.value : null;
                if (val != null) {
                    val = val.trim();
                    cacheId.processorData[19] = new Boolean(val);
                }
            }
            if (cacheId.processorData[22] == null || !((Boolean)cacheId.processorData[22]).booleanValue()) {
                p = (Property)cacheId.properties.get(PROPERTY_IGNORE_CHAR_ENCODING);
                String string7 = val = p != null ? p.value : null;
                if (val != null) {
                    val = val.trim();
                    cacheId.processorData[22] = new Boolean(val);
                }
            }
        }
        return valid;
    }

    public void processCacheIdProperties(CacheId cacheid) {
        super.processCacheIdProperties(cacheid);
        if (cacheid.processorData[6] != null) {
            this.edgeable = (Boolean)cacheid.processorData[6];
        }
        if (cacheid.processorData[7] != null) {
            this.consumeSubfragments = (Boolean)cacheid.processorData[7];
        }
        if (cacheid.processorData[8] != null) {
            this.externalCacheGroupId = (String)cacheid.processorData[8];
        }
        if (cacheid.processorData[9] != null) {
            this.altUrl = (String)cacheid.processorData[9];
        }
        if (cacheid.processorData[17] != null) {
            this.doNotConsume = (Boolean)cacheid.processorData[17];
        }
        if (cacheid.processorData[19] != null) {
            this.ignoreGetPost = (Boolean)cacheid.processorData[19];
        }
        if (cacheid.processorData[22] != null) {
            this.ignoreCharEnc = (Boolean)cacheid.processorData[22];
        }
        if (cacheid.processorData[21] != null) {
            this.consumeExcludeList = (String[])cacheid.processorData[21];
        }
    }

    public void processConfigEntryProperties() {
        super.processConfigEntryProperties();
        if (this.configEntry.processorData[6] != null) {
            this.edgeable = (Boolean)this.configEntry.processorData[6];
        }
        if (this.configEntry.processorData[7] != null) {
            this.consumeSubfragments = (Boolean)this.configEntry.processorData[7];
        }
        if (this.configEntry.processorData[8] != null) {
            this.externalCacheGroupId = (String)this.configEntry.processorData[8];
        }
        if (this.configEntry.processorData[9] != null) {
            this.altUrl = (String)this.configEntry.processorData[9];
        }
        if (this.configEntry.processorData[17] != null) {
            this.doNotConsume = (Boolean)this.configEntry.processorData[17];
        }
        if (this.configEntry.processorData[19] != null) {
            this.ignoreGetPost = (Boolean)this.configEntry.processorData[19];
        }
        if (this.configEntry.processorData[22] != null) {
            this.ignoreCharEnc = (Boolean)this.configEntry.processorData[22];
        }
        if (this.configEntry.processorData[21] != null) {
            this.consumeExcludeList = (String[])this.configEntry.processorData[21];
        }
    }

    @Override
    public String getBaseName() {
        if (this.baseName == null) {
            this.baseName = this.configEntry.name;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getBaseName: " + this.configEntry.name), (Object[])new Object[0]);
        }
        if (this.configEntry.name.contains("com.ibm.ws.webcontainer.osgi.extension.DefaultExtensionProcessor.class")) {
            String changedBaseName = String.copyValueOf(this.configEntry.name.toCharArray());
            this.baseName = changedBaseName.replace("com.ibm.ws.webcontainer.osgi.extension.DefaultExtensionProcessor.class", "com.ibm.ws.webcontainer.servlet.SimpleFileServlet.class");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getBaseName returns: " + this.baseName), (Object[])new Object[0]);
        }
        return this.baseName;
    }

    public void populateFragmentInfo(FragmentInfo fi) {
        fi.setId(this.getId());
        int portletMethod = this.request.getPortletMethod();
        fi.addTemplate(this.getBaseName());
        fi.setInstanceName(this.configEntry.instanceName);
        fi.setSkipCacheAttribute(this.configEntry.skipCacheAttribute);
        if (!this.cacheable) {
            return;
        }
        boolean storeAttrib = (Boolean)this.configEntry.processorData[15];
        fi.setStoreAttributes(storeAttrib);
        String[] excludeList = (String[])this.configEntry.processorData[18];
        fi.setAttributeExcludeList(excludeList);
        String storeCookies = (String)this.configEntry.processorData[16];
        if (storeCookies != null) {
            fi.setStoreCookies(new Boolean(storeCookies.trim()));
            fi.setCookieExcludeList((String[])this.configEntry.processorData[20]);
        } else {
            DCache cache = ServerCache.getCache((String)this.configEntry.instanceName);
            if (cache != null) {
                fi.setStoreCookies(cache.getCacheConfig().isCacheInstanceStoreCookies());
            } else {
                fi.setStoreCookies(true);
            }
        }
        fi.setSharingPolicy(this.sharingPolicy);
        fi.setPersistToDisk(this.persistToDisk);
        fi.setTimeLimit(this.timeout);
        fi.setInactivity(this.inactivity);
        fi.setIgnoreGetPost(this.ignoreGetPost);
        fi.setIgnoreCharEnc(this.ignoreCharEnc);
        fi.setDoNotCache(this.doNotCache);
        if (this.priority > 0) {
            fi.setPriority(this.priority);
        }
        if (this.groupIds != null) {
            for (int i = 0; i < this.groupIds.size(); ++i) {
                fi.addDataId((String)this.groupIds.get(i));
            }
        }
        if (this.edgeable) {
            String cid = this.getESICacheId(this.configEntry);
            if (cid != null) {
                fi.setEdgeable(true);
                fi.setESICacheId(cid);
                fi.setESIQueryString(this.esiQueryString);
            }
            if (this.altUrl != null) {
                fi.setAlternateUrl(this.altUrl);
            }
        }
        fi.setConsumeSubfragments(this.consumeSubfragments);
        fi.setConsumeExcludeList(this.consumeExcludeList);
        fi.setDoNotConsume(this.doNotConsume);
        if (this.externalCacheGroupId != null) {
            fi.setExternalCacheGroupId(this.externalCacheGroupId);
        }
        if (this.cacheIdForMetaDataGenerator != null) {
            CacheId cacheid = (CacheId)this.cacheIdForMetaDataGenerator.clone();
            if (this.cacheIdForMetaDataGenerator.idGeneratorImpl != null) {
                cacheid.idGeneratorImpl = this.cacheIdForMetaDataGenerator.idGeneratorImpl;
            }
            this.processMetaDataGenerator(cacheid);
            this.cacheIdForMetaDataGenerator = cacheid;
        }
    }

    public boolean execute(CacheProxyRequest request, CacheProxyResponse response, Servlet servlet) {
        String sc;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("execute: " + this.configEntry.name), (Object[])new Object[0]);
        }
        this.request = request;
        this.response = response;
        super.execute();
        if (this.cacheable) {
            String encoding = request.getCharacterEncoding();
            if (encoding != null && !this.ignoreCharEnc) {
                this.id.append(':').append(encoding);
            } else if (this.ignoreCharEnc) {
                Tr.debug((TraceComponent)tc, (String)"ignore-char-encoding SET. Char Encoding will be ignored whilc creating cacheids", (Object[])new Object[0]);
            }
            String requestType = request.getMethod();
            if (this.ignoreGetPost) {
                if (!requestType.equals("GET") && !requestType.equals("POST")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Request type is not GET or POST, value of property ignore-get-post will be set to false for this request.", (Object[])new Object[0]);
                    }
                    this.ignoreGetPost = false;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ignore-get-post property is set to true, will not differentiate between GET and POST requests types unless defined explicitly in the cache policy.", (Object[])new Object[0]);
                }
            }
            if (this.id.toString().indexOf("requestType=" + requestType) == -1 && (requestType.equals("GET") || requestType.equals("POST")) && !this.ignoreGetPost) {
                this.id.append(':').append("requestType=" + requestType);
            }
        }
        if ((sc = ESISupport.getHeaderDirect(request, "Surrogate-Capability")) != null && sc.indexOf("ESI/0.8") != -1) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"esiVersion: ESI/0.8, must set edgeable to true", (Object[])new Object[0]);
            }
            this.edgeable = true;
            this.configEntry.processorData[6] = new Boolean(true);
            request.setAttribute("IBM-DYNACACHE-RRD-ESI", this.rrdRules.clone());
        }
        if (this.edgeable) {
            Boolean s;
            Boolean b = (Boolean)this.configEntry.processorData[10];
            if (b.booleanValue()) {
                String dispatch_type = (String)request.getAttribute("com.ibm.servlet.engine.webapp.dispatch_type");
                this.pathInfo = dispatch_type != null && dispatch_type.equals("include") ? (String)request.getAttribute("javax.servlet.include.path_info") : request.getPathInfo();
            }
            if ((s = (Boolean)this.configEntry.processorData[13]).booleanValue()) {
                String dispatch_type = (String)request.getAttribute("com.ibm.servlet.engine.webapp.dispatch_type");
                this.servletpath = dispatch_type != null && dispatch_type.equals("include") ? (String)request.getAttribute("javax.servlet.include.servlet_path") : request.getServletPath();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"execute");
        }
        return this.cacheable;
    }

    protected boolean processCacheId(CacheId cacheid) {
        boolean success = super.processCacheId(cacheid);
        if (success) {
            this.esiQueryString = this.getESIQueryString(cacheid);
        }
        return success;
    }

    @Override
    protected Object getComponentValue(Component c) {
        if (c == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"FragmentCacheProcessor.getComponentValue(): null component passed in, returning null.", (Object[])new Object[0]);
            }
            return null;
        }
        Object result = null;
        switch (c.iType) {
            case 3: {
                if (!c.id.equals("*")) {
                    return this.request.getParameter(c.id);
                }
                if (!this.response.getFragmentComposer().getInclude()) {
                    result = this.request.getQueryString();
                    break;
                }
                result = (String)this.request.getAttribute("javax.servlet.include.query_string");
                break;
            }
            case 11: {
                result = this.request.getAttribute(c.id);
                if (c.index <= -1) break;
                if (result instanceof Collection) {
                    result = ((Collection)result).toArray();
                }
                if (!(result instanceof Object[]) || ((Object[])result).length <= c.index) break;
                result = result[c.index];
                break;
            }
            case 2: {
                HttpSession s = this.request.getSession(false);
                if (s == null) break;
                result = s.getAttribute(c.id);
                break;
            }
            case 4: {
                Cookie[] cookies = this.request.getCookies();
                if (cookies == null) break;
                for (int i = 0; result == null && i < cookies.length; ++i) {
                    if (!cookies[i].getName().equals(c.id)) continue;
                    result = cookies[i].getValue();
                }
                break;
            }
            case 5: {
                return this.request.getHeader(c.id);
            }
            case 6: {
                result = this.request.getLocale();
                this.rrdRules.put("locale", result);
                break;
            }
            case 12: {
                if (!this.response.getFragmentComposer().getInclude()) {
                    result = this.request.getPathInfo();
                    break;
                }
                result = (String)this.request.getAttribute("javax.servlet.include.path_info");
                break;
            }
            case 13: {
                if (!this.response.getFragmentComposer().getInclude()) {
                    result = this.request.getServletPath();
                    break;
                }
                result = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
                break;
            }
            case 14: {
                Object[] pv = this.request.getParameterValues(c.id);
                if (pv == null) break;
                Arrays.sort(pv);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < pv.length; ++i) {
                    sb.append((String)pv[i]);
                    if (i == pv.length - 1) continue;
                    sb.append(',');
                }
                result = sb.toString();
                break;
            }
            case 20: {
                result = this.request.getMethod();
                this.rrdRules.put("requestType", result);
                break;
            }
            case 21: {
                try {
                    Object tilesContext = this.request.getAttribute("org.apache.struts.taglib.tiles.CompContext");
                    Method method = tilesContext.getClass().getMethod("getAttribute", String.class);
                    result = method.invoke(tilesContext, c.id);
                    break;
                }
                catch (Exception ex) {
                    System.out.println("Warning: struts.jar is not in the application or server classpath. Hence component type 'tiles_attribute' is not supported.");
                    return null;
                }
            }
            case 26: {
                HttpSession session = this.request.getSession(false);
                if (session == null) break;
                result = session.getId();
                break;
            }
            default: {
                Tr.error((TraceComponent)tc, (String)"DYNA0040E", (Object[])new Object[]{c.type, this.request.getContextPath() + this.request.getServletPath()});
                return null;
            }
        }
        if (result == null) {
            return null;
        }
        if (c.method != null) {
            result = this.processMethod(c.method, result);
        } else if (c.field != null) {
            result = this.processField(c.field, result);
        }
        return result;
    }

    @Override
    protected String processIdGenerator(CacheId cacheid) {
        if (cacheid.idGeneratorImpl == null) {
            try {
                Class<?> c = Class.forName(cacheid.idGenerator, true, SerializationUtility.getContextClassLoader());
                cacheid.idGeneratorImpl = c.newInstance();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.FragmentCacheProcessor.processIdGenerator", (String)"291", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"dynacache.idgeneratorerror", (Object[])new Object[]{cacheid.idGenerator});
                return null;
            }
        }
        return ((IdGenerator)cacheid.idGeneratorImpl).getId(this.request);
    }

    @Override
    protected void processMetaDataGenerator(CacheId cacheid) {
        if (cacheid.metaDataGeneratorImpl == null) {
            try {
                Class<?> c = Class.forName(cacheid.metaDataGenerator, true, SerializationUtility.getContextClassLoader());
                cacheid.metaDataGeneratorImpl = c.newInstance();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.config.FragmentCacheProcessor.processMetaDataGenerator", (String)"306", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"dynacache.metadatageneratorerror", (Object[])new Object[]{cacheid.metaDataGenerator});
                return;
            }
        }
        ((MetaDataGenerator)cacheid.metaDataGeneratorImpl).setMetaData(this.request, this.response);
    }

    @Override
    protected String[] processInvalidationGenerator(Invalidation invalidation) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Servlets do not support custom invalidation generating classes.", (Object[])new Object[0]);
        }
        return null;
    }

    public String getESICacheId(ConfigEntry ce) {
        if (this.esiId != null) {
            return this.esiId;
        }
        HashMap hm = (HashMap)ce.processorData[11];
        if (hm != null) {
            this.esiId = (String)hm.get(this.pathInfo);
            if (this.esiId != null) {
                return this.esiId;
            }
            this.esiId = (String)hm.get(this.servletpath);
            if (this.esiId != null) {
                return this.esiId;
            }
        }
        StringBuffer sb = new StringBuffer(128);
        if (ce.cacheIds != null && ce.cacheIds.length > 0) {
            for (int i = 0; i < ce.cacheIds.length; ++i) {
                CacheId cid = ce.cacheIds[i];
                if ((cid.processorData[6] == null || !((Boolean)cid.processorData[6]).booleanValue()) && (ce.processorData[6] == null || !((Boolean)ce.processorData[6]).booleanValue())) continue;
                this.getESIRule(ce.cacheIds[i], sb, ce.name);
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        sb.insert(0, "cacheid=\"");
        sb.append("\"");
        this.esiId = sb.toString();
        if (((Boolean)ce.processorData[10]).booleanValue() && ((HashSet)ce.processorData[12]).contains(this.pathInfo)) {
            hm.put(this.pathInfo, this.esiId);
        }
        if (((Boolean)ce.processorData[13]).booleanValue() && ((HashSet)ce.processorData[14]).contains(this.servletpath)) {
            hm.put(this.servletpath, this.esiId);
        }
        return this.esiId;
    }

    public String getESIQueryString(CacheId ci) {
        if (this.esiQueryString != null) {
            return this.esiQueryString;
        }
        String absoluteUri = this.request.getAbsoluteUri();
        int index = -1;
        if (absoluteUri != null) {
            index = absoluteUri.indexOf("?");
        }
        String parmStr = null;
        StringTokenizer parmToks = null;
        StringBuffer sb = null;
        String parm = null;
        String parmName = null;
        if (ci.components != null) {
            for (int i = 0; i < ci.components.length; ++i) {
                Component c = ci.components[i];
                boolean addParm = false;
                if (c.type.equals("parameter")) {
                    if (index > -1) {
                        parmStr = this.request.getAbsoluteUri().substring(index + 1);
                        parmToks = new StringTokenizer(parmStr, "&");
                    }
                    if (parmToks != null) {
                        while (parmToks.hasMoreTokens()) {
                            parm = parmToks.nextToken();
                            parmName = parm.substring(0, parm.indexOf("="));
                            if (!parmName.trim().equals(c.id.trim())) continue;
                            addParm = true;
                            break;
                        }
                    }
                    if (sb == null) {
                        sb = new StringBuffer(32 * ci.components.length);
                        sb.append("?");
                    } else {
                        sb.append("&");
                    }
                    if (addParm) {
                        sb.append(parm);
                        continue;
                    }
                    sb.append(c.id).append("=").append("$(QUERY_STRING{" + c.id + "})");
                    continue;
                }
                if (!c.type.equals("cookie")) continue;
                if (sb == null) {
                    sb = new StringBuffer(32 * ci.components.length);
                    sb.append("?");
                } else {
                    sb.append("&");
                }
                sb.append(c.id).append("=").append("$(HTTP_COOKIE{" + c.id + "})");
            }
        }
        this.esiQueryString = sb != null ? sb.toString() : "";
        return this.esiQueryString;
    }

    public void getESIRule(CacheId ci, StringBuffer sb, String identifier) {
        StringBuffer parms = null;
        StringBuffer cookies = null;
        StringBuffer headers = null;
        block9: for (int i = 0; ci.components != null && i < ci.components.length; ++i) {
            Component c = ci.components[i];
            switch (c.iType) {
                case 3: {
                    if (parms == null) {
                        parms = new StringBuffer();
                    } else {
                        parms.append(" ");
                    }
                    c.getESIComponent(parms);
                    continue block9;
                }
                case 5: {
                    if (headers == null) {
                        headers = new StringBuffer();
                    } else {
                        headers.append(" ");
                    }
                    c.getESIComponent(headers);
                    continue block9;
                }
                case 4: {
                    if (cookies == null) {
                        cookies = new StringBuffer();
                    } else {
                        cookies.append(" ");
                    }
                    c.getESIComponent(cookies);
                    continue block9;
                }
                case 12: {
                    if (c.values != null && c.values.size() != 0 && !c.values.containsKey(this.pathInfo)) {
                        return;
                    }
                    if (c.notValues == null || c.notValues.size() == 0 || !c.notValues.containsKey(this.pathInfo)) continue block9;
                    return;
                }
                case 13: {
                    if (c.values != null && c.values.size() != 0 && !c.values.containsKey(this.servletpath)) {
                        return;
                    }
                    if (c.notValues == null || c.notValues.size() == 0 || !c.values.containsKey(this.servletpath)) continue block9;
                    return;
                }
                case 6: {
                    String s1 = ESISupport.getHeaderDirect(this.request, "Surrogate-Capability");
                    if (s1 == null || s1.indexOf("ESI/0.8") != -1) continue block9;
                    Tr.error((TraceComponent)tc, (String)"DYNA0041E", (Object[])new Object[]{c.type, identifier});
                    return;
                }
                case 20: {
                    String s2 = ESISupport.getHeaderDirect(this.request, "Surrogate-Capability");
                    if (s2 == null || s2.indexOf("ESI/0.8") != -1) continue block9;
                    Tr.error((TraceComponent)tc, (String)"DYNA0041E", (Object[])new Object[]{c.type, identifier});
                    return;
                }
                default: {
                    Tr.error((TraceComponent)tc, (String)"DYNA0041E", (Object[])new Object[]{c.type, identifier});
                    return;
                }
            }
        }
        sb.append("(");
        if (parms != null) {
            sb.append(parms.toString());
        }
        if (cookies == null && headers == null) {
            sb.append(")").toString();
            return;
        }
        sb.append(",");
        if (cookies != null) {
            sb.append(cookies.toString());
        }
        if (headers != null) {
            sb.append(",").append(headers.toString());
        }
        sb.append(")");
    }
}

