/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.db;

import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.exception.OAuthDataException;
import com.ibm.ws.security.oauth20.plugins.db.DetectDatabaseType;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class OAuthJDBCImpl {
    private static final TraceComponent tc = Tr.register(OAuthJDBCImpl.class, (String)"OAuth20Provider", null);
    public static final String CONFIG_JDBC_PROVIDER = "oauthjdbc.JDBCProvider";
    public static final String CONFIG_CLIENT_TABLE = "oauthjdbc.client.table";
    public static final String CONFIG_TOKEN_TABLE = "oauthjdbc.token.table";
    public static final String CONFIG_PROVIDER_NAME = "oauth20.provider.id";
    static final String CLASS = OAuthJDBCImpl.class.getName();
    Logger _log = Logger.getLogger(CLASS);
    private DataSource dataSource;
    private String providerName;
    private Object[] credentials;
    private DetectDatabaseType.DBType databaseType;
    static final long serialVersionUID = -445895976375222401L;

    public OAuthJDBCImpl() {
    }

    public OAuthJDBCImpl(DataSource dataSource, @Sensitive Object[] credentials) {
        this.dataSource = dataSource;
        this.credentials = credentials != null ? (Object[])credentials.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    protected void init(OAuthComponentConfiguration config) {
        String methodName = "init";
        this._log.entering(CLASS, methodName);
        boolean finestLoggable = this._log.isLoggable(Level.FINEST);
        try {
            this.providerName = config.getConfigPropertyValue(CONFIG_PROVIDER_NAME);
            if (this.providerName != null) {
                this.credentials = ConfigUtils.getProviderJdbcCredentialsMap().get(this.providerName);
                if (finestLoggable) {
                    this._log.logp(Level.FINEST, CLASS, methodName, "setting credentials for provider " + this.providerName, this.credentials);
                }
            }
            if (finestLoggable) {
                this._log.logp(Level.FINEST, CLASS, methodName, "Using JDBC provider: " + this.dataSource);
            }
        }
        finally {
            this._log.exiting(CLASS, methodName);
        }
    }

    @ManualTrace
    @FFDCIgnore(value={SQLException.class})
    protected Connection getDBConnection() throws OAuthDataException {
        String methodName = "getDBConnection";
        this._log.entering(CLASS, methodName);
        Connection conn = null;
        try {
            if (this._log.isLoggable(Level.FINEST)) {
                this._log.logp(Level.FINEST, CLASS, methodName, "Credentials: ", this.credentials);
                this._log.logp(Level.FINEST, CLASS, methodName, "this: ", this);
            }
            String userid = null;
            if (this.credentials != null && this.credentials[0] != null) {
                userid = (String)this.credentials[0];
            }
            String password = null;
            if (this.credentials != null && this.credentials[1] != null) {
                password = new String(((SerializableProtectedString)this.credentials[1]).getChars());
            }
            if (userid != null || password != null) {
                try {
                    conn = this.dataSource.getConnection(userid, password);
                }
                catch (SQLException e2) {
                    this.getDBClogAndSleep(200);
                    conn = this.dataSource.getConnection(userid, password);
                }
            } else {
                try {
                    conn = this.dataSource.getConnection();
                }
                catch (SQLException e2) {
                    this.getDBClogAndSleep(200);
                    conn = this.dataSource.getConnection();
                }
            }
        }
        catch (SQLException e) {
            throw new OAuthDataException(e);
        }
        finally {
            this._log.exiting(CLASS, methodName);
        }
        return conn;
    }

    @Trivial
    private void getDBClogAndSleep(int msec) {
        String methodName = "getDBClogAndSleep";
        if (this._log.isLoggable(Level.FINEST)) {
            this._log.logp(Level.FINEST, CLASS, methodName, "caught exception getting db connection, will retry in " + msec + " msec");
        }
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.security.oauth20.plugins.db.OAuthJDBCImpl", (String)"145", (Object)this, (Object[])new Object[]{msec});
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    protected void closeConnection(Connection conn, boolean error) {
        String methodName = "closeConnection";
        this._log.entering(CLASS, methodName, new Object[]{"" + error});
        if (conn != null) {
            try {
                try {
                    if (!conn.getAutoCommit()) {
                        if (!error) {
                            conn.commit();
                        } else {
                            conn.rollback();
                        }
                    }
                }
                catch (SQLException sQLException) {
                    void e1;
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.OAuthJDBCImpl", (String)"168", (Object)this, (Object[])new Object[]{conn, error});
                    this._log.logp(Level.FINEST, CLASS, methodName, "Unable to commit or rollback.", (Throwable)e1);
                }
                conn.close();
            }
            catch (SQLException e1) {
                void e;
                FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.security.oauth20.plugins.db.OAuthJDBCImpl", (String)"175", (Object)this, (Object[])new Object[]{conn, error});
                this._log.logp(Level.FINEST, CLASS, methodName, "Unable to close connection.", (Throwable)e);
            }
        }
        this._log.exiting(CLASS, methodName);
    }

    /*
     * WARNING - void declaration
     */
    protected void closeResultSet(ResultSet results) {
        String method = "closeResultSet";
        if (results != null) {
            try {
                results.close();
            }
            catch (SQLException sQLException) {
                void e;
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.OAuthJDBCImpl", (String)"189", (Object)this, (Object[])new Object[]{results});
                this._log.logp(Level.FINEST, CLASS, method, "Unable to close results.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void closeStatement(Statement statement, String methodName) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                void e;
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.OAuthJDBCImpl", (String)"201", (Object)this, (Object[])new Object[]{statement, methodName});
                this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected DetectDatabaseType.DBType getDBType() {
        if (this.databaseType == null) {
            Connection conn = null;
            try {
                conn = this.getDBConnection();
                this.databaseType = DetectDatabaseType.DetectionUtils.detectDbType(conn);
            }
            catch (OAuthDataException oAuthDataException) {
                void e;
                FFDCFilter.processException((Throwable)oAuthDataException, (String)"com.ibm.ws.security.oauth20.plugins.db.OAuthJDBCImpl", (String)"213", (Object)this, (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)("Internal error getting DB connection: " + e.getMessage()), (Object[])new Object[]{e});
            }
            finally {
                if (conn != null) {
                    this.closeConnection(conn, false);
                }
            }
        }
        return this.databaseType;
    }
}

