/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip.netty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.stack.transaction.transport.connections.tls.SSLRepertoire;
import java.util.HashMap;

public class SIPConnectionFactoryImpl {
    private static final TraceComponent tc = Tr.register(SIPConnectionFactoryImpl.class);
    private static int s_chains = 0;

    private static HashMap getTlsProperties() {
        String contextProvider;
        String trustStorePassword;
        String trustStoreFile;
        String trustStoreProvider;
        String trustStoreType;
        String trustManagerName;
        String keyStorePassword;
        String keyStoreFile;
        String keyStoreProvider;
        String keyStoreType;
        String keyManager;
        SSLRepertoire repertoire = com.ibm.ws.sip.stack.transaction.transport.connections.tls.SIPConnectionFactoryImpl.createSSLRepertoire();
        HashMap<String, String> tlsProperties = new HashMap<String, String>();
        String protocol = repertoire.getProtocol();
        if (protocol != null) {
            tlsProperties.put("com.ibm.ssl.sslType", protocol);
        }
        if ((keyManager = repertoire.getKeyManagerName()) != null) {
            tlsProperties.put("com.ibm.ssl.keyManager", keyManager);
        }
        if ((keyStoreType = repertoire.getKeyStoreType()) != null) {
            tlsProperties.put("com.ibm.ssl.keyStoreType", keyStoreType);
        }
        if ((keyStoreProvider = repertoire.getKeyStoreProvider()) != null) {
            tlsProperties.put("com.ibm.ssl.keyStoreProvider", keyStoreProvider);
        }
        if ((keyStoreFile = repertoire.getKeyStoreFile()) != null) {
            tlsProperties.put("com.ibm.ssl.keyStore", keyStoreFile);
        }
        if ((keyStorePassword = repertoire.getKeyStorePassword()) != null) {
            tlsProperties.put("com.ibm.ssl.keyStorePassword", keyStorePassword);
        }
        if ((trustManagerName = repertoire.getTrustManagerName()) != null) {
            tlsProperties.put("com.ibm.ssl.trustManager", trustManagerName);
        }
        if ((trustStoreType = repertoire.getTrustStoreType()) != null) {
            tlsProperties.put("com.ibm.ssl.trustStoreType", trustStoreType);
        }
        if ((trustStoreProvider = repertoire.getTrustStoreProvider()) != null) {
            tlsProperties.put("com.ibm.ssl.trustStoreProvider", trustStoreProvider);
        }
        if ((trustStoreFile = repertoire.getTrustStoreFile()) != null) {
            tlsProperties.put("com.ibm.ssl.trustStore", trustStoreFile);
        }
        if ((trustStorePassword = repertoire.getTrustStorePassword()) != null) {
            tlsProperties.put("com.ibm.ssl.trustStorePassword", trustStorePassword);
        }
        if ((contextProvider = repertoire.getContextProvider()) != null) {
            tlsProperties.put("com.ibm.ssl.contextProvider", contextProvider);
        }
        boolean clientAuthentication = repertoire.isClientAuthenticationEnabled();
        tlsProperties.put("com.ibm.ssl.clientAuthentication", Boolean.toString(clientAuthentication));
        return tlsProperties;
    }
}

