/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.parser;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.parser.MessageParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transaction.util.Debug;
import jain.protocol.ip.sip.message.Message;

public class DatagramMessageParser
extends MessageParser {
    private static final LogMgr s_logger = Log.get(DatagramMessageParser.class);
    private static final ThreadLocal<DatagramMessageParser> s_instances = new ThreadLocal<DatagramMessageParser>(){

        @Override
        protected DatagramMessageParser initialValue() {
            return new DatagramMessageParser();
        }
    };

    public static MessageParser getGlobalInstance() {
        return s_instances.get();
    }

    @Override
    public Message parse(SipMessageByteBuffer buffer) {
        CharsBuffer line = CharsBuffersPool.getBuffer();
        Message message = this.parse(buffer, line);
        buffer.reset();
        CharsBuffersPool.putBufferBack(line);
        return message;
    }

    private Message parse(SipMessageByteBuffer buffer, CharsBuffer line) {
        Message message = this.parseStartLine(buffer, line);
        if (message == null) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("Error: datagram does not contain a full start-line");
            }
            if (s_logger.isTraceFailureEnabled()) {
                StringBuffer failure = new StringBuffer();
                failure.append("bad start-line in packet:\n");
                Debug.hexDump(buffer.getBytes(), 0, buffer.getMarkedBytesNumber(), failure);
                s_logger.traceFailure(failure.toString());
            }
            return null;
        }
        if (!this.parseHeaders(buffer, message, line)) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("Error: datagram does not contain a full header section");
            }
            if (s_logger.isTraceFailureEnabled()) {
                StringBuffer failure = new StringBuffer();
                failure.append("bad header at offset [");
                failure.append(Integer.toHexString(buffer.getReadPos()));
                failure.append("] in packet:\n");
                Debug.hexDump(buffer.getBytes(), 0, buffer.getMarkedBytesNumber(), failure);
                s_logger.traceFailure(failure.toString());
            }
            this.setError(400, "Bad Message. Incomplete header");
            return null;
        }
        if (!this.parseBody(buffer, message)) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("Error: datagram received with partial body");
            }
            if (s_logger.isTraceFailureEnabled()) {
                StringBuffer failure = new StringBuffer();
                failure.append("incomplete body in packet:\n");
                Debug.hexDump(buffer.getBytes(), 0, buffer.getMarkedBytesNumber(), failure);
                s_logger.traceFailure(failure.toString());
            }
            this.setError(400, "Bad Message. Incomplete body");
        }
        return message;
    }

    @Override
    public boolean hasMore() {
        return false;
    }

    @Override
    protected boolean contentLengthHeaderRequired() {
        return false;
    }

    @Override
    protected void crlfReceived(boolean empty) {
    }
}

