/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.dns.impl.chfw;

import com.ibm.ws.sip.channel.resolver.dns.impl.chfw.Name;
import com.ibm.ws.sip.channel.resolver.dns.impl.chfw.ResourceRecord;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;

public class SOARecord
extends ResourceRecord {
    private Name _mname;
    private Name _rname;
    private int _serial;
    private int _refresh;
    private int _retry;
    private int _expire;
    private int _minTTL;

    protected SOARecord() {
        this._mname = null;
        this._rname = null;
        this._serial = 0;
        this._refresh = 0;
        this._retry = 0;
        this._expire = 0;
        this._minTTL = 0;
    }

    protected SOARecord(WsByteBuffer buffer) {
        super(buffer);
        this._mname = new Name(buffer);
        this._rname = new Name(buffer);
        this._serial = buffer.getInt();
        this._refresh = buffer.getInt();
        this._retry = buffer.getInt();
        this._expire = buffer.getInt();
        this._minTTL = buffer.getInt();
    }

    @Override
    protected void toBuffer(WsByteBuffer buffer) {
        super.toBuffer(buffer);
        this._mname.toBuffer(buffer);
        this._rname.toBuffer(buffer);
        buffer.putInt(this._serial);
        buffer.putInt(this._refresh);
        buffer.putInt(this._retry);
        buffer.putInt(this._expire);
        buffer.putInt(this._minTTL);
    }

    public void setMname(Name n) {
        this._mname = n;
    }

    public void setRname(Name n) {
        this._rname = n;
    }

    public void setSerial(int i) {
        this._serial = i;
    }

    public void setRefresh(int i) {
        this._refresh = i;
    }

    public void setRetry(int i) {
        this._retry = i;
    }

    public void setExpire(int i) {
        this._expire = i;
    }

    public void setMinTTL(int i) {
        this._minTTL = i;
    }

    public short calcrdLength() {
        int length = 0;
        length = this._mname.length() + this._rname.length() + 4 + 4 + 4 + 4 + 4;
        return (short)length;
    }

    public Name getMname() {
        return this._mname;
    }

    public Name getRname() {
        return this._rname;
    }

    @Override
    public String toString() {
        String s = new String();
        s = super.toString();
        s = s + "      mname: " + this._mname.toString() + "\n      rname: " + this._rname.toString() + "\n      serial: " + this._serial + "\n      refresh: " + this._refresh + "\n      retry: " + this._retry + "\n      expire: " + this._expire + "\n      minimum TTL: " + this._minTTL + "\n";
        return s;
    }
}

