/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.extensions.simple;

import com.ibm.ws.jain.protocol.ip.sip.extensions.simple.EventHeader;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersHeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;

public class EventHeaderImpl
extends ParametersHeaderImpl
implements EventHeader {
    private static final long serialVersionUID = -5077878265416815300L;
    protected String m_type;
    private final boolean m_compactForm;

    public EventHeaderImpl() {
        this(false);
    }

    public EventHeaderImpl(boolean compactForm) {
        this.m_compactForm = compactForm;
    }

    @Override
    public void setEventType(String type) throws IllegalArgumentException {
        if (type == null || type.equals("")) {
            throw new IllegalArgumentException("Event header: null or empty type");
        }
        this.m_type = type;
    }

    @Override
    public void setEventId(String id) throws IllegalArgumentException, SipParseException {
        if (id == null || id.equals("")) {
            throw new IllegalArgumentException("Event header: null or empty id");
        }
        this.setParameter("id", id);
    }

    @Override
    public String getEventType() {
        return this.m_type;
    }

    @Override
    public String getEventId() {
        return this.getParameter("id");
    }

    @Override
    public boolean hasId() {
        return this.getParameter("id") != null;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        String eventType = parser.nextToken(';');
        this.setEventType(eventType);
        super.parseValue(parser);
    }

    @Override
    protected void encodeValue(CharsBuffer ret) {
        ret.append(this.m_type);
        super.encodeValue(ret);
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!super.valueEquals(other)) {
            return false;
        }
        if (!(other instanceof EventHeaderImpl)) {
            return false;
        }
        EventHeaderImpl o = (EventHeaderImpl)other;
        if (this.m_type == null || this.m_type.length() == 0) {
            return o.m_type == null || o.m_type.length() == 0;
        }
        if (o.m_type == null || o.m_type.length() == 0) {
            return false;
        }
        return this.m_type.equals(o.m_type);
    }

    @Override
    public String getName() {
        return "Event";
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    protected char getListSeparator() {
        return ';';
    }

    @Override
    protected char getParamSeparator() {
        return ';';
    }

    @Override
    protected boolean escapeParameters() {
        return true;
    }

    @Override
    public String getName(boolean isUseCompactHeaders) {
        if (isUseCompactHeaders) {
            return String.valueOf('o');
        }
        return this.getName();
    }

    @Override
    public boolean isCompactFormSupported() {
        return true;
    }

    @Override
    public boolean isCompactForm() {
        return this.m_compactForm;
    }
}

