/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.service.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.WSATTransaction;
import com.ibm.ws.wsat.service.WSATContext;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.service.impl.RegistrationImpl;
import com.ibm.ws.wsat.tm.impl.TranManagerImpl;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HandlerImpl {
    private static final String CLASS_NAME = HandlerImpl.class.getName();
    private static final TraceComponent TC = Tr.register(HandlerImpl.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private static final HandlerImpl INSTANCE = new HandlerImpl();
    private final TranManagerImpl tranService = TranManagerImpl.getInstance();
    private final RegistrationImpl registrationService = RegistrationImpl.getInstance();
    private final ThreadLocal<WSATTransaction> clientCall = new ThreadLocal();
    private final ThreadLocal<WSATTransaction> serverCall = new ThreadLocal();
    private final ThreadLocal<Boolean> wsatCall = new ThreadLocal<Boolean>(){
        static final long serialVersionUID = 7764971618694024025L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.service.impl.HandlerImpl$1", 1.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
        }
    };
    static final long serialVersionUID = 2115969291648221580L;

    public static HandlerImpl getInstance() {
        return INSTANCE;
    }

    public boolean isTranActive() {
        boolean tranActive = false;
        if (!this.wsatCall.get().booleanValue()) {
            tranActive = this.tranService.isTranActive();
        } else if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Processing a WS-AT service call", (Object[])new Object[0]);
        }
        return tranActive;
    }

    public void setWsatCall(boolean isWsat) {
        this.wsatCall.set(isWsat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSATContext clientRequest() throws WSATException {
        WSATContext ctx = null;
        if (this.tranService.isTranActive()) {
            long timeout = this.tranService.getTimeout();
            String globalId = this.tranService.getGlobalId();
            WSATTransaction wsatTran = WSATTransaction.getTran(globalId);
            try {
                if (!(wsatTran instanceof WSATTransaction)) {
                    ctx = this.registrationService.activate(globalId, timeout, false);
                    if (TC.isDebugEnabled()) {
                        Tr.debug((TraceComponent)TC, (String)"Created new WSAT global transaction: {0}", (Object[])new Object[]{globalId});
                    }
                    wsatTran = WSATTransaction.getTran(globalId);
                } else {
                    ctx = wsatTran.getContext();
                    if (TC.isDebugEnabled()) {
                        Tr.debug((TraceComponent)TC, (String)"Using existing WSAT global transaction: {0}", (Object[])new Object[]{globalId});
                    }
                }
            }
            finally {
                this.tranService.exportTransaction();
                this.clientCall.set(wsatTran);
            }
        }
        return ctx;
    }

    public void clientResponse() throws WSATException {
        this.clientCompletion(false);
    }

    public void clientFault() throws WSATException {
        this.clientCompletion(true);
    }

    private void clientCompletion(boolean isfault) throws WSATException {
        WSATTransaction wsatTran = this.clientCall.get();
        if (wsatTran != null) {
            this.clientCall.set(null);
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)((isfault ? "Fault" : "Response") + " for client WSAT transaction: {0}"), (Object[])new Object[]{wsatTran.getGlobalId()});
            }
            if (isfault) {
                this.tranService.setRollbackOnly(wsatTran.getGlobalId());
            }
            this.tranService.unexportTransaction(wsatTran.getGlobalId());
        } else if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Client response without related WSAT transaction", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverRequest(String ctxId, EndpointReferenceType registration, long expires) throws WSATException {
        WSATTransaction wsatTran = null;
        String globalId = ctxId;
        boolean tranCreated = this.tranService.importTransaction(globalId, (int)expires / 1000);
        try {
            if (tranCreated) {
                if (TC.isDebugEnabled()) {
                    Tr.debug((TraceComponent)TC, (String)"Create new WSAT global transaction: {0}", (Object[])new Object[]{globalId});
                }
                wsatTran = this.registrationService.activate(globalId, registration, expires, false);
                this.registrationService.registerParticipant(globalId, wsatTran);
            } else {
                if (TC.isDebugEnabled()) {
                    Tr.debug((TraceComponent)TC, (String)"Using existing WSAT global transaction: {0}", (Object[])new Object[]{globalId});
                }
                if ((wsatTran = WSATTransaction.getTran(globalId)) == null) {
                    throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"NO_WSAT_TRAN_CWLIB0201", (Object[])new Object[]{globalId}));
                }
            }
            this.serverCall.set(wsatTran);
        }
        catch (Throwable throwable) {
            this.serverCall.set(wsatTran);
            throw throwable;
        }
    }

    public void serverResponse() throws WSATException {
        this.serverCompletion();
    }

    public void serverFault() throws WSATException {
        this.serverCompletion();
    }

    private void serverCompletion() throws WSATException {
        WSATTransaction wsatTran = this.serverCall.get();
        if (wsatTran != null) {
            this.serverCall.set(null);
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Response for server WSAT transaction: {0}", (Object[])new Object[]{wsatTran.getGlobalId()});
            }
            this.tranService.unimportTransaction(wsatTran.getGlobalId());
        } else if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Server response without related WSAT transaction", (Object[])new Object[0]);
        }
    }
}

