/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.v1_1;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.AttributeConstraint;
import io.openliberty.data.internal.QueryType;
import io.openliberty.data.internal.version.DataVersionCompatibility;
import io.openliberty.data.repository.Count;
import io.openliberty.data.repository.Exists;
import io.openliberty.data.repository.IgnoreCase;
import io.openliberty.data.repository.function.AbsoluteValue;
import io.openliberty.data.repository.function.CharCount;
import io.openliberty.data.repository.function.ElementCount;
import io.openliberty.data.repository.function.Extract;
import io.openliberty.data.repository.function.Rounded;
import io.openliberty.data.repository.function.Trimmed;
import io.openliberty.data.repository.update.Add;
import io.openliberty.data.repository.update.Assign;
import io.openliberty.data.repository.update.Divide;
import io.openliberty.data.repository.update.Multiply;
import io.openliberty.data.repository.update.SubtractFrom;
import jakarta.data.Limit;
import jakarta.data.Order;
import jakarta.data.Sort;
import jakarta.data.constraint.AtLeast;
import jakarta.data.constraint.AtMost;
import jakarta.data.constraint.Between;
import jakarta.data.constraint.Constraint;
import jakarta.data.constraint.EqualTo;
import jakarta.data.constraint.GreaterThan;
import jakarta.data.constraint.In;
import jakarta.data.constraint.LessThan;
import jakarta.data.constraint.Like;
import jakarta.data.constraint.NotBetween;
import jakarta.data.constraint.NotEqualTo;
import jakarta.data.constraint.NotIn;
import jakarta.data.constraint.NotLike;
import jakarta.data.constraint.NotNull;
import jakarta.data.constraint.Null;
import jakarta.data.page.PageRequest;
import jakarta.data.repository.By;
import jakarta.data.repository.Delete;
import jakarta.data.repository.Find;
import jakarta.data.repository.Insert;
import jakarta.data.repository.Is;
import jakarta.data.repository.Query;
import jakarta.data.repository.Save;
import jakarta.data.repository.Select;
import jakarta.data.repository.Update;
import jakarta.data.spi.expression.literal.Literal;
import jakarta.persistence.EntityManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"io.openliberty.data.internal.version.1.1"}, configurationPolicy=ConfigurationPolicy.IGNORE, service={DataVersionCompatibility.class})
public class Data_1_1
implements DataVersionCompatibility {
    private static final TraceComponent tc = Tr.register(Data_1_1.class, (String)"data", (String)"io.openliberty.data.internal.resources.CWWKDMessages");
    private static final String FUNCTION_ANNO_PACKAGE = Rounded.class.getPackageName();
    private static final Map<String, String> FUNCTION_CALLS = new HashMap<String, String>();
    private static final Set<Class<? extends Annotation>> LIFECYCLE_ANNOS_STATEFUL;
    private static final Set<Class<? extends Annotation>> LIFECYCLE_ANNOS_STATELESS;
    private static final Set<Class<? extends Annotation>> OP_ANNOS_STATEFUL;
    private static final Set<Class<? extends Annotation>> OP_ANNOS_STATELESS;
    private static final Set<Class<?>> RESOURCE_ACCESSOR_CLASSES_STATEFUL;
    private static final Set<Class<?>> RESOURCE_ACCESSOR_CLASSES_STATELESS;
    private static final Set<Class<?>> SPECIAL_PARAM_TYPES;
    static final long serialVersionUID = 4910582793763769921L;

    @Trivial
    public StringBuilder appendConstraint(StringBuilder q, String o_, String attrName, AttributeConstraint constraint, int qp, boolean isCollection, Annotation[] annos) {
        AttributeConstraint baseConstraint;
        StringBuilder attributeExpr = new StringBuilder();
        ArrayList<Annotation> functionAnnos = new ArrayList<Annotation>();
        boolean ignoreCase = false;
        for (int a = annos.length - 1; a >= 0; --a) {
            if (annos[a] instanceof IgnoreCase) {
                ignoreCase = true;
                continue;
            }
            String annoPackage = annos[a].annotationType().getPackageName();
            if (!FUNCTION_ANNO_PACKAGE.equals(annoPackage)) continue;
            functionAnnos.add(annos[a]);
            String functionType = annos[a] instanceof Extract ? ((Extract)annos[a]).value().name() : (annos[a] instanceof Rounded ? ((Rounded)annos[a]).value().name() : annos[a].annotationType().getSimpleName());
            String functionCall = FUNCTION_CALLS.get(functionType);
            attributeExpr.append(functionCall);
        }
        boolean negated = constraint.isNegative();
        AttributeConstraint attributeConstraint = baseConstraint = negated ? constraint.negate() : constraint;
        if (ignoreCase) {
            attributeExpr.append("LOWER(");
        }
        if (attrName.charAt(attrName.length() - 1) != ')') {
            attributeExpr.append(o_);
        }
        attributeExpr.append(attrName);
        if (ignoreCase) {
            attributeExpr.append(')');
        }
        for (Annotation anno : functionAnnos) {
            if (anno instanceof Rounded && ((Rounded)anno).value() == Rounded.Direction.NEAREST) {
                attributeExpr.append(", 0)");
                continue;
            }
            attributeExpr.append(')');
        }
        if (isCollection && (ignoreCase || baseConstraint != AttributeConstraint.Equal)) {
            throw new UnsupportedOperationException("The " + constraint.constraintName() + " constraint that is applied to entity attribute " + attrName + " is not supported for collection attributes.");
        }
        switch (baseConstraint) {
            case Equal: 
            case GreaterThan: 
            case GreaterThanEqual: 
            case LessThan: 
            case LessThanEqual: {
                q.append((CharSequence)attributeExpr).append(constraint.operator());
                Data_1_1.appendParam(q, ignoreCase, qp);
                break;
            }
            case Between: {
                q.append((CharSequence)attributeExpr).append(constraint.operator());
                Data_1_1.appendParam(q, ignoreCase, qp);
                q.append(" AND ");
                Data_1_1.appendParam(q, ignoreCase, qp + 1);
                break;
            }
            case In: {
                if (ignoreCase) {
                    throw new UnsupportedOperationException();
                }
                q.append((CharSequence)attributeExpr).append(constraint.operator());
                Data_1_1.appendParam(q, ignoreCase, qp);
                break;
            }
            case Like: {
                q.append((CharSequence)attributeExpr).append(constraint.operator());
                Data_1_1.appendParam(q, ignoreCase, qp);
                break;
            }
            case LikeEscaped: {
                q.append((CharSequence)attributeExpr).append(constraint.operator());
                Data_1_1.appendParam(q, ignoreCase, qp);
                q.append(" ESCAPE ");
                Data_1_1.appendParam(q, false, qp + 1);
                break;
            }
            case Null: {
                q.append((CharSequence)attributeExpr).append(constraint.operator());
                break;
            }
            case Contains: {
                q.append((CharSequence)attributeExpr).append(negated ? " NOT" : "").append(" LIKE CONCAT('%', ");
                Data_1_1.appendParam(q, ignoreCase, qp).append(", '%')");
                break;
            }
            case EndsWith: {
                q.append((CharSequence)attributeExpr).append(negated ? " NOT" : "").append(" LIKE CONCAT('%', ");
                Data_1_1.appendParam(q, ignoreCase, qp).append(')');
                break;
            }
            case StartsWith: {
                q.append((CharSequence)attributeExpr).append(negated ? " NOT" : "").append(" LIKE CONCAT(");
                Data_1_1.appendParam(q, ignoreCase, qp).append(", '%')");
                break;
            }
            default: {
                throw new UnsupportedOperationException(constraint.constraintName());
            }
        }
        return q;
    }

    @Trivial
    private static StringBuilder appendParam(StringBuilder q, boolean lower, int num) {
        q.append(lower ? "LOWER(?" : Character.valueOf('?')).append(num);
        return lower ? q.append(')') : q;
    }

    @Trivial
    public boolean atLeast(int major, int minor) {
        return major == 1 && minor <= 1;
    }

    @Trivial
    public Annotation getCountAnnotation(Method method) {
        return method.getAnnotation(Count.class);
    }

    @Trivial
    public Class<?> getEntityClass(Find find) {
        return find.value();
    }

    @Trivial
    public Annotation getExistsAnnotation(Method method) {
        return method.getAnnotation(Exists.class);
    }

    @Trivial
    public String[] getSelections(AnnotatedElement element) {
        Select[] selects = (Select[])element.getAnnotationsByType(Select.class);
        if (selects.length == 0) {
            return NO_SELECTIONS;
        }
        String[] values = new String[selects.length];
        for (int i = 0; i < selects.length; ++i) {
            values[i] = selects[i].value();
        }
        return values;
    }

    @Trivial
    public String[] getUpdateAttributeAndOperation(Annotation[] annos) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        String[] returnValue = null;
        for (Annotation anno : annos) {
            if (anno instanceof Assign) {
                returnValue = new String[]{((Assign)anno).value(), "="};
                break;
            }
            if (anno instanceof Add) {
                returnValue = new String[]{((Add)anno).value(), "+"};
                break;
            }
            if (anno instanceof Multiply) {
                returnValue = new String[]{((Multiply)anno).value(), "*"};
                break;
            }
            if (anno instanceof Divide) {
                returnValue = new String[]{((Divide)anno).value(), "/"};
                break;
            }
            if (!(anno instanceof SubtractFrom)) continue;
            returnValue = new String[]{((SubtractFrom)anno).value(), "-"};
            break;
        }
        if (trace && tc.isDebugEnabled()) {
            Object[] aa = new Object[annos.length];
            for (int a = 0; a < annos.length; ++a) {
                aa[a] = annos[a] == null ? null : annos[a].annotationType().getName();
            }
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getUpdateAttributeAndOperation", (Object[])new Object[]{aa, returnValue});
        }
        return returnValue;
    }

    public int inspectMethodParam(int p, Class<?> paramType, Annotation[] paramAnnos, String[] attrNames, AttributeConstraint[] constraints, char[] updateOps, int qpNext) {
        int qpOriginal = qpNext;
        for (Annotation anno : paramAnnos) {
            if (anno instanceof Is) {
                constraints[p] = Data_1_1.toAttributeConstraint(((Is)anno).value(), paramType);
                continue;
            }
            if (anno instanceof Assign) {
                attrNames[p] = ((Assign)anno).value();
                updateOps[p] = 61;
                ++qpNext;
                continue;
            }
            if (anno instanceof Add) {
                attrNames[p] = ((Add)anno).value();
                updateOps[p] = 43;
                ++qpNext;
                continue;
            }
            if (anno instanceof Multiply) {
                attrNames[p] = ((Multiply)anno).value();
                updateOps[p] = 42;
                ++qpNext;
                continue;
            }
            if (anno instanceof Divide) {
                attrNames[p] = ((Divide)anno).value();
                updateOps[p] = 47;
                ++qpNext;
                continue;
            }
            if (!(anno instanceof SubtractFrom)) continue;
            attrNames[p] = ((SubtractFrom)anno).value();
            updateOps[p] = 45;
            ++qpNext;
        }
        if (constraints[p] == null && Constraint.class.isAssignableFrom(paramType)) {
            constraints[p] = Data_1_1.toAttributeConstraint(null, paramType);
        }
        if (qpNext == qpOriginal) {
            if (constraints[p] == null) {
                constraints[p] = AttributeConstraint.Equal;
            }
            qpNext += constraints[p].numMethodParams();
        } else if (qpNext - qpOriginal > 1) {
            qpNext = -2;
        }
        return qpNext;
    }

    @Trivial
    public boolean isSpecialParamValid(Class<?> paramType, QueryType queryType) {
        return switch (queryType) {
            case QueryType.FIND -> true;
            case QueryType.FIND_AND_DELETE -> {
                if (!PageRequest.class.equals(paramType)) {
                    yield true;
                }
                yield false;
            }
            case QueryType.COUNT, QueryType.EXISTS -> {
                if (Order.class.equals(paramType) || Sort.class.equals(paramType) || Sort[].class.equals(paramType)) {
                    yield true;
                }
                yield false;
            }
            case QueryType.QM_DELETE, QueryType.QM_UPDATE -> false;
            default -> false;
        };
    }

    @Trivial
    public Set<Class<? extends Annotation>> lifeCycleAnnoTypes(boolean stateful) {
        return stateful ? LIFECYCLE_ANNOS_STATEFUL : LIFECYCLE_ANNOS_STATELESS;
    }

    @Trivial
    public Set<Class<? extends Annotation>> operationAnnoTypes(boolean stateful) {
        return stateful ? OP_ANNOS_STATEFUL : OP_ANNOS_STATELESS;
    }

    @Trivial
    public String paramAnnosForUpdate() {
        return By.class.getSimpleName() + ", " + Add.class.getSimpleName() + ", " + Assign.class.getSimpleName() + ", " + Divide.class.getSimpleName() + ", " + Multiply.class.getSimpleName() + ", " + SubtractFrom.class.getSimpleName();
    }

    @Trivial
    public Set<Class<?>> resourceAccessorTypes(boolean stateful) {
        return stateful ? RESOURCE_ACCESSOR_CLASSES_STATEFUL : RESOURCE_ACCESSOR_CLASSES_STATELESS;
    }

    @Trivial
    public String specialParamsForFind() {
        return "Limit, Order, Sort, Sort[], PageRequest, Restriction";
    }

    @Trivial
    public String specialParamsForFindAndDelete() {
        return "Limit, Order, Sort, Sort[], Restriction";
    }

    @Trivial
    public Set<Class<?>> specialParamTypes() {
        return SPECIAL_PARAM_TYPES;
    }

    private static AttributeConstraint toAttributeConstraint(Class<?> isAnnoConstraintType, Class<?> methodParamType) {
        AttributeConstraint constraint;
        Class<?> type;
        Class<?> clazz = type = isAnnoConstraintType == null || Constraint.class.isAssignableFrom(methodParamType) ? methodParamType : isAnnoConstraintType;
        if (isAnnoConstraintType == null || type != isAnnoConstraintType) {
            // empty if block
        }
        if (AtLeast.class.equals(type)) {
            constraint = AttributeConstraint.GreaterThanEqual;
        } else if (AtMost.class.equals(type)) {
            constraint = AttributeConstraint.LessThanEqual;
        } else if (Between.class.equals(type)) {
            constraint = AttributeConstraint.Between;
        } else if (EqualTo.class.equals(type)) {
            constraint = AttributeConstraint.Equal;
        } else if (GreaterThan.class.equals(type)) {
            constraint = AttributeConstraint.GreaterThan;
        } else if (In.class.equals(type)) {
            constraint = AttributeConstraint.In;
        } else if (LessThan.class.equals(type)) {
            constraint = AttributeConstraint.LessThan;
        } else if (Like.class.equals(type)) {
            constraint = Like.class.equals(methodParamType) ? AttributeConstraint.LikeEscaped : AttributeConstraint.Like;
        } else if (NotBetween.class.equals(type)) {
            constraint = AttributeConstraint.NotBetween;
        } else if (NotEqualTo.class.equals(type)) {
            constraint = AttributeConstraint.Not;
        } else if (NotIn.class.equals(type)) {
            constraint = AttributeConstraint.NotIn;
        } else if (NotLike.class.equals(type)) {
            constraint = Like.class.equals(methodParamType) ? AttributeConstraint.NotLikeEscaped : AttributeConstraint.NotLike;
        } else if (NotNull.class.equals(type)) {
            constraint = AttributeConstraint.NotNull;
        } else if (Null.class.equals(type)) {
            constraint = AttributeConstraint.Null;
        } else {
            throw new UnsupportedOperationException("Constraint: " + type.getName());
        }
        return constraint;
    }

    @Trivial
    public Object[] toConstraintValues(Object constraintOrValue) {
        Object[] values;
        boolean isList = false;
        if (constraintOrValue instanceof AtLeast) {
            AtLeast c = (AtLeast)constraintOrValue;
            values = new Object[]{c.bound()};
        } else if (constraintOrValue instanceof AtMost) {
            AtMost c = (AtMost)constraintOrValue;
            values = new Object[]{c.bound()};
        } else if (constraintOrValue instanceof Between) {
            Between c = (Between)constraintOrValue;
            values = new Object[]{c.lowerBound(), c.upperBound()};
        } else if (constraintOrValue instanceof EqualTo) {
            EqualTo c = (EqualTo)constraintOrValue;
            values = new Object[]{c.expression()};
        } else if (constraintOrValue instanceof GreaterThan) {
            GreaterThan c = (GreaterThan)constraintOrValue;
            values = new Object[]{c.bound()};
        } else {
            isList = constraintOrValue instanceof In;
            if (isList) {
                values = ((In)constraintOrValue).expressions().toArray();
            } else if (constraintOrValue instanceof LessThan) {
                LessThan c = (LessThan)constraintOrValue;
                values = new Object[]{c.bound()};
            } else if (constraintOrValue instanceof Like) {
                Like c = (Like)constraintOrValue;
                values = new Object[]{c.pattern(), Character.valueOf(c.escape())};
            } else if (constraintOrValue instanceof NotBetween) {
                NotBetween c = (NotBetween)constraintOrValue;
                values = new Object[]{c.lowerBound(), c.upperBound()};
            } else if (constraintOrValue instanceof NotEqualTo) {
                NotEqualTo c = (NotEqualTo)constraintOrValue;
                values = new Object[]{c.expression()};
            } else {
                isList = constraintOrValue instanceof NotIn;
                if (isList) {
                    values = ((NotIn)constraintOrValue).expressions().toArray();
                } else if (constraintOrValue instanceof NotLike) {
                    NotLike c = (NotLike)constraintOrValue;
                    values = new Object[]{c.pattern(), Character.valueOf(c.escape())};
                } else if (constraintOrValue instanceof NotNull || constraintOrValue instanceof Null) {
                    values = new Object[]{};
                } else {
                    if (constraintOrValue instanceof Constraint) {
                        throw new UnsupportedOperationException("Constraint: " + constraintOrValue.getClass().getName());
                    }
                    return null;
                }
            }
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof Literal) {
                values[i] = ((Literal)values[i]).value();
                continue;
            }
            if (values[i] instanceof Character) continue;
            throw new UnsupportedOperationException(values[i].getClass().getName());
        }
        if (isList) {
            values = new Object[]{List.of(values)};
        }
        return values;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        FUNCTION_CALLS.put(AbsoluteValue.class.getSimpleName(), "ABS(");
        FUNCTION_CALLS.put(CharCount.class.getSimpleName(), "LENGTH(");
        FUNCTION_CALLS.put(ElementCount.class.getSimpleName(), "SIZE(");
        FUNCTION_CALLS.put(Rounded.Direction.DOWN.name(), "FLOOR(");
        FUNCTION_CALLS.put(Rounded.Direction.NEAREST.name(), "ROUND(");
        FUNCTION_CALLS.put(Rounded.Direction.UP.name(), "CEILING(");
        FUNCTION_CALLS.put(Trimmed.class.getSimpleName(), "TRIM(");
        FUNCTION_CALLS.put(Extract.Field.DAY.name(), "EXTRACT (DAY FROM ");
        FUNCTION_CALLS.put(Extract.Field.HOUR.name(), "EXTRACT (HOUR FROM ");
        FUNCTION_CALLS.put(Extract.Field.MINUTE.name(), "EXTRACT (MINUTE FROM ");
        FUNCTION_CALLS.put(Extract.Field.MONTH.name(), "EXTRACT (MONTH FROM ");
        FUNCTION_CALLS.put(Extract.Field.QUARTER.name(), "EXTRACT (QUARTER FROM ");
        FUNCTION_CALLS.put(Extract.Field.SECOND.name(), "EXTRACT (SECOND FROM ");
        FUNCTION_CALLS.put(Extract.Field.WEEK.name(), "EXTRACT (WEEK FROM ");
        FUNCTION_CALLS.put(Extract.Field.YEAR.name(), "EXTRACT (YEAR FROM ");
        LIFECYCLE_ANNOS_STATEFUL = Set.of();
        LIFECYCLE_ANNOS_STATELESS = Set.of(Delete.class, Insert.class, Update.class, Save.class);
        OP_ANNOS_STATEFUL = Set.of(Find.class, Query.class);
        OP_ANNOS_STATELESS = Set.of(Delete.class, Find.class, Insert.class, Query.class, Save.class, Update.class);
        RESOURCE_ACCESSOR_CLASSES_STATEFUL = Set.of(Connection.class, DataSource.class, EntityManager.class);
        RESOURCE_ACCESSOR_CLASSES_STATELESS = RESOURCE_ACCESSOR_CLASSES_STATEFUL;
        SPECIAL_PARAM_TYPES = Set.of(Limit.class, Order.class, Sort.class, Sort[].class, PageRequest.class);
    }
}

