/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.domain.model;

import io.narayana.lra.coordinator.domain.model.LRAData;
import io.narayana.lra.coordinator.domain.model.Transaction;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.microprofile.lra.annotation.LRAStatus;

public class LRAStatusHolder {
    private String lraId;
    private String clientId;
    private boolean isRecovering;
    private boolean isActive;
    private boolean isTopLevel;
    private int httpStatus;
    private String responseData;
    long startTime;
    long finishTime;
    long timeNow;
    String[] failedParticipants;
    private LRAStatus lraStatus;

    public LRAStatusHolder(Transaction lra) {
        LRAData data = lra.getLRAData();
        this.lraId = data.getLraId();
        this.clientId = data.getClientId();
        this.isRecovering = data.isRecovering();
        this.isActive = data.isActive();
        this.isTopLevel = data.isTopLevel();
        this.httpStatus = lra.getHttpStatus();
        this.responseData = lra.getResponseData();
        this.lraStatus = lra.getLRAStatus();
        this.failedParticipants = lra.getFailedParticipants().values().toArray(new String[0]);
    }

    public String getLraId() {
        return this.lraId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public LRAStatus getStatus() {
        return this.lraStatus;
    }

    private boolean isInState(LRAStatus state) {
        return this.lraStatus != null && this.lraStatus == state;
    }

    public boolean isCancelling() {
        return this.isInState(LRAStatus.Cancelling);
    }

    public boolean isCancelled() {
        return this.isInState(LRAStatus.Cancelled);
    }

    public boolean isClosing() {
        return this.isInState(LRAStatus.Closing);
    }

    public boolean isClosed() {
        return this.isInState(LRAStatus.Closed);
    }

    public boolean isFailedToClose() {
        return this.isInState(LRAStatus.FailedToClose);
    }

    public boolean isFailedToCancel() {
        return this.isInState(LRAStatus.FailedToCancel);
    }

    public boolean isRecovering() {
        return this.isRecovering;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public String getResponseData() {
        return this.responseData;
    }

    public String getEncodedResponseData() throws IOException {
        return this.responseData;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public long getTimeNow() {
        return this.timeNow;
    }

    public String[] getFailedParticipants() {
        return this.failedParticipants;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LRAStatusHolder lraStatus = (LRAStatusHolder)o;
        return Objects.equals(this.lraId, lraStatus.lraId) && this.lraStatus == lraStatus.lraStatus;
    }

    public int hashCode() {
        return Objects.hash(this.lraId);
    }
}

