/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.OpenApiConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ModuleInfo;

public class FilteredIndexView
implements IndexView {
    private final IndexView delegate;
    private final Set<String> scanClasses;
    private final Set<Pattern> scanClassesPatterns;
    private final Set<String> scanPackages;
    private final Set<Pattern> scanPackagesPatterns;
    private final Set<String> scanExcludeClasses;
    private final Set<Pattern> scanExcludeClassesPatterns;
    private final Set<String> scanExcludePackages;
    private final Set<Pattern> scanExcludePackagesPatterns;
    private boolean anyIncludesConfigured;

    public FilteredIndexView(IndexView delegate, OpenApiConfig config) {
        this.delegate = delegate;
        this.scanClasses = new HashSet<String>();
        this.scanClassesPatterns = new HashSet<Pattern>();
        FilteredIndexView.processConfigStrings(config.scanClasses(), this.scanClasses, this.scanClassesPatterns);
        this.scanPackages = new HashSet<String>();
        this.scanPackagesPatterns = new HashSet<Pattern>();
        FilteredIndexView.processConfigStrings(config.scanPackages(), this.scanPackages, this.scanPackagesPatterns);
        this.scanExcludeClasses = new HashSet<String>();
        this.scanExcludeClassesPatterns = new HashSet<Pattern>();
        FilteredIndexView.processConfigStrings(config.scanExcludeClasses(), this.scanExcludeClasses, this.scanExcludeClassesPatterns);
        this.scanExcludePackages = new HashSet<String>();
        this.scanExcludePackagesPatterns = new HashSet<Pattern>();
        FilteredIndexView.processConfigStrings(config.scanExcludePackages(), this.scanExcludePackages, this.scanExcludePackagesPatterns);
        this.anyIncludesConfigured = !this.scanClasses.isEmpty() || !this.scanClassesPatterns.isEmpty() || !this.scanPackages.isEmpty() || !this.scanPackagesPatterns.isEmpty();
    }

    private static void processConfigStrings(Set<String> inputs, Set<String> strings, Set<Pattern> patterns) {
        for (String input : inputs) {
            if (input.startsWith("^") || input.endsWith("$")) {
                patterns.add(Pattern.compile(input));
                continue;
            }
            strings.add(input);
        }
    }

    public boolean accepts(DotName className) {
        return this.accepts(className, true);
    }

    public boolean explicitlyAccepts(DotName className) {
        return this.accepts(className, false);
    }

    public boolean accepts(DotName className, boolean allowImpliedInclusion) {
        String packageName;
        String fqcn = className.toString();
        String simpleName = className.withoutPackagePrefix();
        int index = fqcn.lastIndexOf(46);
        String string = packageName = index > -1 ? fqcn.substring(0, index) : "";
        if (this.scanExcludeClasses.contains(fqcn)) {
            return false;
        }
        if (this.scanClasses.contains(fqcn)) {
            return true;
        }
        String simpleNameExcludeMatch = FilteredIndexView.longestSuffixMatch(fqcn, this.scanExcludeClasses);
        if (!simpleNameExcludeMatch.endsWith(simpleName)) {
            simpleNameExcludeMatch = "";
        }
        simpleNameExcludeMatch = FilteredIndexView.longest(simpleNameExcludeMatch, FilteredIndexView.longestRegexMatch(fqcn, this.scanExcludeClassesPatterns));
        String simpleNameIncludeMatch = FilteredIndexView.longestSuffixMatch(fqcn, this.scanClasses);
        if (!simpleNameIncludeMatch.endsWith(simpleName)) {
            simpleNameIncludeMatch = "";
        }
        simpleNameIncludeMatch = FilteredIndexView.longest(simpleNameIncludeMatch, FilteredIndexView.longestRegexMatch(fqcn, this.scanClassesPatterns));
        if (simpleNameExcludeMatch.length() > 0 && simpleNameExcludeMatch.length() >= simpleNameIncludeMatch.length()) {
            return false;
        }
        if (simpleNameIncludeMatch.length() > 0) {
            return true;
        }
        String packageIncludeMatch = FilteredIndexView.longest(FilteredIndexView.longestPrefixMatch(packageName, this.scanPackages), FilteredIndexView.longestRegexMatch(packageName, this.scanPackagesPatterns));
        String packageExcludeMatch = FilteredIndexView.longest(FilteredIndexView.longestPrefixMatch(packageName, this.scanExcludePackages), FilteredIndexView.longestRegexMatch(packageName, this.scanExcludePackagesPatterns));
        if (packageExcludeMatch.length() > 0 && packageExcludeMatch.length() >= packageIncludeMatch.length()) {
            return false;
        }
        if (packageIncludeMatch.length() > 0) {
            return true;
        }
        return allowImpliedInclusion && !this.anyIncludesConfigured;
    }

    private static String longestPrefixMatch(String name, Set<String> prefixes) {
        String longestPrefix = "";
        for (String prefix : prefixes) {
            if (!name.startsWith(prefix) || prefix.length() <= longestPrefix.length()) continue;
            longestPrefix = prefix;
        }
        return longestPrefix;
    }

    private static String longestSuffixMatch(String name, Set<String> suffixes) {
        String longestSuffix = "";
        for (String suffix : suffixes) {
            if (!name.endsWith(suffix) || suffix.length() <= longestSuffix.length()) continue;
            longestSuffix = suffix;
        }
        return longestSuffix;
    }

    private static String longestRegexMatch(String name, Set<Pattern> patterns) {
        String longestMatch = "";
        for (Pattern pattern : patterns) {
            String match;
            Matcher m = pattern.matcher(name);
            if (!m.find() || (match = m.group()).length() <= longestMatch.length()) continue;
            longestMatch = match;
        }
        return longestMatch;
    }

    private static String longest(String ... strings) {
        String longest = "";
        for (String string : strings) {
            if (string.length() <= longest.length()) continue;
            longest = string;
        }
        return longest;
    }

    public Collection<ClassInfo> getKnownClasses() {
        return this.filterClasses(this.delegate.getKnownClasses());
    }

    public ClassInfo getClassByName(DotName className) {
        if (this.accepts(className)) {
            return this.delegate.getClassByName(className);
        }
        return null;
    }

    public Collection<ClassInfo> getKnownDirectSubclasses(DotName className) {
        return this.filterClasses(this.delegate.getKnownDirectSubclasses(className));
    }

    public Collection<ClassInfo> getAllKnownSubclasses(DotName className) {
        return this.filterClasses(this.delegate.getAllKnownSubclasses(className));
    }

    public Collection<ClassInfo> getKnownDirectSubinterfaces(DotName interfaceName) {
        return this.filterClasses(this.delegate.getKnownDirectSubinterfaces(interfaceName));
    }

    public Collection<ClassInfo> getAllKnownSubinterfaces(DotName interfaceName) {
        return this.filterClasses(this.delegate.getAllKnownSubinterfaces(interfaceName));
    }

    public Collection<ClassInfo> getKnownDirectImplementors(DotName className) {
        return this.filterClasses(this.delegate.getKnownDirectImplementors(className));
    }

    public Collection<ClassInfo> getAllKnownImplementors(DotName interfaceName) {
        return this.filterClasses(this.delegate.getAllKnownImplementors(interfaceName));
    }

    public Collection<AnnotationInstance> getAnnotations(DotName annotationName) {
        return this.filterInstances(this.delegate.getAnnotations(annotationName));
    }

    public Collection<AnnotationInstance> getAnnotationsWithRepeatable(DotName annotationName, IndexView annotationIndex) {
        return this.filterInstances(this.delegate.getAnnotationsWithRepeatable(annotationName, annotationIndex));
    }

    public Collection<ModuleInfo> getKnownModules() {
        return this.delegate.getKnownModules();
    }

    public ModuleInfo getModuleByName(DotName moduleName) {
        return this.delegate.getModuleByName(moduleName);
    }

    public Collection<ClassInfo> getKnownUsers(DotName className) {
        return this.filterClasses(this.delegate.getKnownUsers(className));
    }

    public Collection<ClassInfo> getClassesInPackage(DotName packageName) {
        return this.filterClasses(this.delegate.getClassesInPackage(packageName));
    }

    public Set<DotName> getSubpackages(DotName packageName) {
        return this.delegate.getSubpackages(packageName);
    }

    public Collection<ClassInfo> getAllKnownImplementations(DotName interfaceName) {
        return this.delegate.getAllKnownImplementations(interfaceName);
    }

    public Collection<ClassInfo> getKnownDirectImplementations(DotName interfaceName) {
        return this.delegate.getKnownDirectImplementations(interfaceName);
    }

    private Collection<AnnotationInstance> filterInstances(Collection<AnnotationInstance> annotations) {
        if (annotations != null && !annotations.isEmpty()) {
            return annotations.stream().filter(ai -> {
                AnnotationTarget target = ai.target();
                switch (target.kind()) {
                    case CLASS: {
                        return this.accepts(target.asClass().name());
                    }
                    case FIELD: {
                        return this.accepts(target.asField().declaringClass().name());
                    }
                    case METHOD: {
                        return this.accepts(target.asMethod().declaringClass().name());
                    }
                    case METHOD_PARAMETER: {
                        return this.accepts(target.asMethodParameter().method().declaringClass().name());
                    }
                    case TYPE: {
                        return true;
                    }
                }
                return false;
            }).collect(Collectors.toList());
        }
        return annotations;
    }

    private Collection<ClassInfo> filterClasses(Collection<ClassInfo> classes) {
        return classes.stream().filter(classInfo -> this.accepts(classInfo.name())).collect(Collectors.toList());
    }
}

