/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.scim20.rest;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.wim.scim20.SCIMService;
import com.ibm.websphere.security.wim.scim20.exceptions.AuthorizationException;
import com.ibm.websphere.security.wim.scim20.exceptions.InvalidFilterException;
import com.ibm.websphere.security.wim.scim20.exceptions.InvalidSyntaxException;
import com.ibm.websphere.security.wim.scim20.exceptions.InvalidValueException;
import com.ibm.websphere.security.wim.scim20.exceptions.InvalidVersionException;
import com.ibm.websphere.security.wim.scim20.exceptions.MutabilityException;
import com.ibm.websphere.security.wim.scim20.exceptions.NotFoundException;
import com.ibm.websphere.security.wim.scim20.exceptions.NotImplementedException;
import com.ibm.websphere.security.wim.scim20.exceptions.SCIMException;
import com.ibm.websphere.security.wim.scim20.exceptions.TooManyResultsException;
import com.ibm.websphere.security.wim.scim20.exceptions.UniquenessException;
import com.ibm.websphere.security.wim.scim20.model.ListResponse;
import com.ibm.websphere.security.wim.scim20.model.SearchRequest;
import com.ibm.websphere.security.wim.scim20.model.groups.Group;
import com.ibm.websphere.security.wim.scim20.model.users.User;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.scim20.SCIMServiceV20;
import com.ibm.ws.security.wim.scim20.SCIMUtil;
import com.ibm.ws.security.wim.scim20.rest.RESTUtil;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.root=/scim", "com.ibm.wsspi.rest.handler.custom.security=true"})
public class SCIMRESTHandler
implements RESTHandler {
    private static final String ENDPOINT_GROUPS = "Groups";
    private static final String ENDPOINT_USERS = "Users";
    private static final String ENDPOINT_RESOURCE_TYPES = "ResourceTypes";
    private static final String ENDPOINT_SCHEMAS = "Users";
    private static final String ENDPOINT_ME = "Me";
    private static final String ENDPOINT_SERVICE_PROVIDER_CONFIG = "ServiceProviderConfig";
    private static final String ENDPOINT_SEARCH = ".search";
    private static final Set<String> REQUIRED_ROLES_READ;
    private static final Set<String> REQUIRED_ROLES_WRITE;
    public final SCIMService serviceV20 = new SCIMServiceV20();
    static final long serialVersionUID = 1778210061521583629L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private static void handleDelete(SCIMService service, RESTRequest request, RESTResponse response) throws InvalidSyntaxException, NotFoundException, AuthorizationException {
        SCIMRESTHandler.checkHasWriteRole(request);
        String resourceId = RESTUtil.getResourceId(request.getPath());
        if (resourceId == null || resourceId.trim().isEmpty()) {
            throw new InvalidSyntaxException("No resource ID was found for the DELETE operation.");
        }
        String endpoint = RESTUtil.getEnpoint(request.getPath());
        if (ENDPOINT_GROUPS.equals(endpoint)) {
            service.deleteGroup(resourceId);
        } else if ("Users".equals(endpoint)) {
            service.deleteUser(resourceId);
        } else {
            throw new NotFoundException("The endpoint '" + endpoint + "' does not exist.");
        }
    }

    private static Object handleGet(SCIMService service, RESTRequest request, RESTResponse response) throws NotFoundException, InvalidValueException, InvalidFilterException, TooManyResultsException, AuthorizationException {
        SCIMRESTHandler.checkHasReadRole(request);
        String path = request.getPath();
        String endpoint = RESTUtil.getEnpoint(path);
        String resourceId = RESTUtil.getResourceId(path);
        if (ENDPOINT_GROUPS.equals(endpoint)) {
            if (resourceId != null && !resourceId.trim().isEmpty()) {
                return service.getGroup(resourceId, RESTUtil.getAttributes(request));
            }
            return service.getGroups(RESTUtil.getFilter(request), RESTUtil.getAttributes(request), RESTUtil.getExcludedAttributes(request));
        }
        if (ENDPOINT_RESOURCE_TYPES.equals(endpoint)) {
            if (resourceId != null && !resourceId.trim().isEmpty()) {
                return service.getResourceTypes();
            }
            return service.getResourceType(resourceId);
        }
        if ("Users".equals(endpoint)) {
            if (resourceId != null && !resourceId.trim().isEmpty()) {
                return service.getSchemas(resourceId);
            }
            return service.getSchemas();
        }
        if (ENDPOINT_SERVICE_PROVIDER_CONFIG.equals(endpoint)) {
            return service.getServiceProviderConfig();
        }
        if (ENDPOINT_ME.equals(endpoint)) {
            return service.getMe(RESTUtil.getAttributes(request), RESTUtil.getExcludedAttributes(request));
        }
        if ("Users".equals(endpoint)) {
            if (resourceId != null && !resourceId.trim().isEmpty()) {
                return service.getUser(resourceId, RESTUtil.getAttributes(request), RESTUtil.getExcludedAttributes(request));
            }
            return service.getUsers(RESTUtil.getFilter(request), RESTUtil.getAttributes(request), RESTUtil.getExcludedAttributes(request));
        }
        throw new NotFoundException("The endpoint '" + endpoint + "' does not exist.");
    }

    private static Object handlePost(SCIMService service, RESTRequest request, RESTResponse response) throws InvalidSyntaxException, NotFoundException, JsonParseException, JsonMappingException, UniquenessException, InvalidValueException, IOException, InvalidFilterException, TooManyResultsException, AuthorizationException {
        String endpoint = RESTUtil.getEnpoint(request.getPath());
        String resourceId = RESTUtil.getResourceId(request.getPath());
        if (ENDPOINT_SEARCH.equals(endpoint) || ENDPOINT_SEARCH.equals(resourceId)) {
            if (ENDPOINT_GROUPS.equals(endpoint) || "Users".equals(endpoint) || ENDPOINT_SEARCH.equals(endpoint)) {
                SCIMRESTHandler.checkHasReadRole(request);
                return service.getResources(endpoint, SCIMUtil.deserialize(SCIMRESTHandler.getContent(request), SearchRequest.class));
            }
            throw new NotFoundException("The endpoint '" + endpoint + "' does not exist.");
        }
        SCIMRESTHandler.checkHasWriteRole(request);
        if (ENDPOINT_GROUPS.equals(endpoint)) {
            return service.createGroup(SCIMUtil.deserialize(SCIMRESTHandler.getContent(request), Group.class));
        }
        if ("Users".equals(endpoint)) {
            return service.createUser(SCIMUtil.deserialize(SCIMRESTHandler.getContent(request), User.class));
        }
        throw new NotFoundException("The endpoint '" + endpoint + "' does not exist.");
    }

    private static Object handlePut(SCIMService service, RESTRequest request, RESTResponse response) throws InvalidSyntaxException, NotFoundException, JsonParseException, JsonMappingException, MutabilityException, InvalidValueException, IOException, AuthorizationException {
        SCIMRESTHandler.checkHasWriteRole(request);
        String resourceId = RESTUtil.getResourceId(request.getPath());
        if (resourceId == null || resourceId.trim().isEmpty()) {
            throw new InvalidSyntaxException("The SCIM PUT operation requires a resource ID in the URL.");
        }
        String endpoint = RESTUtil.getEnpoint(request.getPath());
        if (ENDPOINT_GROUPS.equals(endpoint)) {
            return service.updateGroup(resourceId, SCIMUtil.deserialize(SCIMRESTHandler.getContent(request), Group.class));
        }
        if ("Users".equals(endpoint)) {
            return service.updateUser(resourceId, SCIMUtil.deserialize(SCIMRESTHandler.getContent(request), User.class));
        }
        throw new NotFoundException("The endpoint '" + endpoint + "' does not exist.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getContent(RESTRequest request) throws InvalidSyntaxException {
        String content;
        block11: {
            content = null;
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(request.getInputStream(), StandardCharsets.UTF_8));
                String line = null;
                StringBuffer sb = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                content = sb.toString();
                if (reader == null) break block11;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.wim.scim20.rest.SCIMRESTHandler", (String)"323", null, (Object[])new Object[]{request});
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException2) {
                        FFDCFilter.processException((Throwable)iOException2, (String)"com.ibm.ws.security.wim.scim20.rest.SCIMRESTHandler", (String)"329", null, (Object[])new Object[]{request});
                    }
                }
                break block11;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.wim.scim20.rest.SCIMRESTHandler", (String)"329", null, (Object[])new Object[]{request});
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.wim.scim20.rest.SCIMRESTHandler", (String)"329", null, (Object[])new Object[]{request});
            }
        }
        if (content == null) throw new InvalidSyntaxException("It was expected that the request contained content, but no content was found on the request.");
        if (!content.trim().isEmpty()) return content;
        throw new InvalidSyntaxException("It was expected that the request contained content, but no content was found on the request.");
    }

    private SCIMService getServiceForRequest(RESTRequest request) throws InvalidVersionException {
        RESTUtil.getApiVersion(request.getPath());
        return this.serviceV20;
    }

    @FFDCIgnore(value={SCIMException.class})
    public void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        String jsonResponse;
        int status;
        block8: {
            status = 500;
            jsonResponse = null;
            try {
                SCIMService service = this.getServiceForRequest(request);
                String method = request.getMethod();
                if ("GET".equalsIgnoreCase(method)) {
                    Object obj = SCIMRESTHandler.handleGet(service, request, response);
                    status = 200;
                    jsonResponse = SCIMUtil.serialize(obj);
                    break block8;
                }
                if ("DELETE".equalsIgnoreCase(method)) {
                    SCIMRESTHandler.handleDelete(service, request, response);
                    status = 204;
                    break block8;
                }
                if ("POST".equalsIgnoreCase(method)) {
                    Object obj = SCIMRESTHandler.handlePost(service, request, response);
                    status = obj instanceof ListResponse ? 200 : 201;
                    jsonResponse = SCIMUtil.serialize(obj);
                    break block8;
                }
                if ("PUT".equalsIgnoreCase(method)) {
                    Object obj = SCIMRESTHandler.handlePut(service, request, response);
                    status = 200;
                    jsonResponse = SCIMUtil.serialize(obj);
                    break block8;
                }
                throw new NotImplementedException("The SCIM service does not supported the request operation: '" + (method == null ? "null" : method.toUpperCase() + "'"));
            }
            catch (SCIMException e) {
                status = e.getHttpCode();
                jsonResponse = e.asJson();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.scim20.rest.SCIMRESTHandler", (String)"414", (Object)this, (Object[])new Object[]{request, response});
                status = 500;
                jsonResponse = "{\"schemas\" : \"urn:ietf:params:scim:api:messages:2.0:Error\"";
                jsonResponse = jsonResponse + "\"detail\" : \"" + e.getMessage() + "\"";
                jsonResponse = jsonResponse + "\"status\" : 500}";
            }
        }
        response.setStatus(status);
        if (jsonResponse != null) {
            response.getWriter().write(jsonResponse);
        }
        response.setResponseHeader("X-Content-Type-Options", "nosniff");
        response.setResponseHeader("Content-Security-Policy", "default-src 'self'");
        response.getWriter().flush();
        response.getWriter().close();
    }

    private static void checkHasWriteRole(RESTRequest request) throws AuthorizationException {
        if (!request.isUserInRole("Administrator")) {
            throw new AuthorizationException("The 'Administrator' role is required to create, delete, or update a resource.", REQUIRED_ROLES_WRITE);
        }
    }

    private static void checkHasReadRole(RESTRequest request) throws AuthorizationException {
        if (!request.isUserInRole("Reader") && !request.isUserInRole("Administrator")) {
            throw new AuthorizationException("The 'Administrator' or 'Reader' role is required to read a resource.", REQUIRED_ROLES_READ);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.wim.scim20.rest.SCIMRESTHandler", SCIMRESTHandler.class, (String)"SCIM20", (String)"com.ibm.ws.security.wim.scim20.resources.SCIMUtilMessages");
        REQUIRED_ROLES_READ = new HashSet<String>(Arrays.asList("Administrator", "Reader"));
        REQUIRED_ROLES_WRITE = new HashSet<String>(Arrays.asList("Administrator"));
    }
}

