/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.source.utils.AuditUtils;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthorizationDelegationEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(AuthorizationDelegationEvent.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    static final long serialVersionUID = -5677940420058365798L;

    public AuthorizationDelegationEvent() {
        this.set("eventName", "SECURITY_AUTHZ_DELEGATION");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    /*
     * WARNING - void declaration
     */
    public AuthorizationDelegationEvent(HashMap<String, Object> extraAuditData, Integer statusCode) {
        block13: {
            this();
            try {
                HttpServletRequest req = (HttpServletRequest)extraAuditData.get("HTTP_SERVLET_REQUEST");
                if (req != null) {
                    String sessionID;
                    String agent;
                    if (req.getRemoteAddr() != null) {
                        this.set("initiator.host.address", req.getRemoteAddr());
                    }
                    if ((agent = req.getHeader("User-Agent")) != null) {
                        this.set("initiator.host.agent", agent);
                    }
                    this.set("target.name", URLDecoder.decode(req.getRequestURI(), "UTF-8"));
                    this.set("target.appname", AuditUtils.getJ2EEComponentName());
                    if (req.getQueryString() != null) {
                        String str = URLDecoder.decode(req.getQueryString(), "UTF-8");
                        str = AuditUtils.hidePassword(str);
                        this.set("target.params", str);
                    }
                    this.set("target.host.address", req.getLocalAddr() + ":" + req.getLocalPort());
                    this.set("target.credential.type", "BASIC");
                    if (req.getUserPrincipal() != null && req.getUserPrincipal().getName() != null) {
                        this.set("target.credential.token", req.getUserPrincipal().getName());
                    }
                    if ((sessionID = AuditUtils.getSessionID(req)) != null) {
                        this.set("target.session", sessionID);
                    }
                    this.set("target.realm", AuditUtils.getRealmName());
                    if (extraAuditData.get("DELEGATION_USERS_LIST") != null) {
                        ArrayList delUsers = new ArrayList();
                        delUsers = (ArrayList)extraAuditData.get("DELEGATION_USERS_LIST");
                        String users = "";
                        for (int i = 0; i < delUsers.size(); ++i) {
                            users = users.concat((String)delUsers.get(i)).concat("; ");
                        }
                        this.set("target.delegation.users", users.substring(0, users.length() - 2));
                    }
                    if (extraAuditData.get("RUN_AS_ROLE") != null) {
                        this.set("target.runas.role", extraAuditData.get("RUN_AS_ROLE"));
                    }
                    this.set("target.method", AuditUtils.getRequestMethod(req));
                    if (statusCode == 200) {
                        this.setOutcome("success");
                    } else {
                        this.setOutcome("failure");
                    }
                    this.set("reason.reasonCode", statusCode);
                    this.set("reason.reasonType", "EJB");
                }
            }
            catch (Exception req) {
                void e;
                FFDCFilter.processException((Throwable)req, (String)"com.ibm.ws.security.audit.event.AuthorizationDelegationEvent", (String)"105", (Object)((Object)this), (Object[])new Object[]{extraAuditData, statusCode});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating AuthenticationDelegationEvent", (Object[])new Object[]{e});
            }
        }
    }
}

