/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.actions;

import java.lang.invoke.MethodHandles;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public final class LoadClass {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private static final String HIBERNATE_VALIDATOR_CLASS_NAME = "org.hibernate.validator";

    private LoadClass() {
    }

    public static Class<?> action(String className, ClassLoader classLoader) {
        return LoadClass.action(className, classLoader, true);
    }

    public static Class<?> action(String className, ClassLoader classLoader, boolean fallbackOnTCCL) {
        return LoadClass.action(className, classLoader, null, fallbackOnTCCL);
    }

    public static Class<?> action(String className, ClassLoader classLoader, ClassLoader initialThreadContextClassLoader) {
        return LoadClass.action(className, classLoader, initialThreadContextClassLoader, true);
    }

    private static Class<?> action(String className, ClassLoader classLoader, ClassLoader initialThreadContextClassLoader, boolean fallbackOnTCCL) {
        if (className.startsWith(HIBERNATE_VALIDATOR_CLASS_NAME)) {
            return LoadClass.loadClassInValidatorNameSpace(className, classLoader, initialThreadContextClassLoader, fallbackOnTCCL);
        }
        return LoadClass.loadNonValidatorClass(className, classLoader, initialThreadContextClassLoader, fallbackOnTCCL);
    }

    private static Class<?> loadClassInValidatorNameSpace(String className, ClassLoader classLoader, ClassLoader initialThreadContextClassLoader, boolean fallbackOnTCCL) {
        Exception exception;
        ClassLoader loader = HibernateValidator.class.getClassLoader();
        try {
            return Class.forName(className, true, HibernateValidator.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (RuntimeException e) {
            exception = e;
        }
        if (fallbackOnTCCL) {
            ClassLoader contextClassLoader;
            ClassLoader classLoader2 = contextClassLoader = initialThreadContextClassLoader != null ? initialThreadContextClassLoader : Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                try {
                    return Class.forName(className, false, contextClassLoader);
                }
                catch (ClassNotFoundException e) {
                    throw LOG.getUnableToLoadClassException(className, contextClassLoader, e);
                }
            }
            throw LOG.getUnableToLoadClassException(className, loader, exception);
        }
        throw LOG.getUnableToLoadClassException(className, loader, exception);
    }

    private static Class<?> loadNonValidatorClass(String className, ClassLoader classLoader, ClassLoader initialThreadContextClassLoader, boolean fallbackOnTCCL) {
        Exception exception = null;
        if (classLoader != null) {
            try {
                return Class.forName(className, false, classLoader);
            }
            catch (ClassNotFoundException e) {
                exception = e;
            }
            catch (RuntimeException e) {
                exception = e;
            }
        }
        if (fallbackOnTCCL) {
            try {
                ClassLoader contextClassLoader;
                ClassLoader classLoader2 = contextClassLoader = initialThreadContextClassLoader != null ? initialThreadContextClassLoader : Thread.currentThread().getContextClassLoader();
                if (contextClassLoader != null) {
                    return Class.forName(className, false, contextClassLoader);
                }
            }
            catch (ClassNotFoundException contextClassLoader) {
            }
            catch (RuntimeException contextClassLoader) {
                // empty catch block
            }
            ClassLoader loader = LoadClass.class.getClassLoader();
            try {
                return Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException e) {
                throw LOG.getUnableToLoadClassException(className, loader, e);
            }
        }
        throw LOG.getUnableToLoadClassException(className, classLoader, exception);
    }
}

