/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal.requests;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.RequestMethod;
import io.openliberty.mcp.internal.exceptions.jsonrpc.MCPRequestValidationException;
import io.openliberty.mcp.internal.requests.McpRequestId;
import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.bind.Jsonb;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public record McpRequest(String jsonrpc, McpRequestId id, String method, JsonObject params) {
    static final long serialVersionUID = -4086134205779252672L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RequestMethod getRequestMethod() {
        return RequestMethod.getForMethodName(this.method);
    }

    public <T> T getParams(Class<T> type, Jsonb jsonb) {
        String json = jsonb.toJson((Object)this.params);
        return (T)jsonb.fromJson(json, type);
    }

    public static McpRequest createValidMCPRequest(Reader reader) throws JsonException, MCPRequestValidationException {
        JsonObject requestJson = Json.createReader((Reader)reader).readObject();
        ArrayList<String> errors = new ArrayList<String>();
        String jsonRpc = requestJson.getString("jsonrpc", null);
        JsonValue id = (JsonValue)requestJson.getOrDefault((Object)"id", null);
        String method = requestJson.getString("method", null);
        JsonObject params = requestJson.getJsonObject("params");
        McpRequest.validateJsonRpc(jsonRpc, errors);
        McpRequest.validateMethod(method, errors);
        if (id == null) {
            if (!errors.isEmpty()) {
                throw new MCPRequestValidationException(errors);
            }
            return McpRequest.createMCPNotificationRequest(jsonRpc, method, params);
        }
        McpRequestId idObj = McpRequest.parseAndValidateId(id, errors);
        if (!errors.isEmpty()) {
            throw new MCPRequestValidationException(errors);
        }
        return new McpRequest(jsonRpc, idObj, method, params);
    }

    private static McpRequest createMCPNotificationRequest(String jsonRpc, String method, JsonObject params) {
        return new McpRequest(jsonRpc, null, method, params);
    }

    private static void validateJsonRpc(String jsonRpc, List<String> errors) {
        if (!"2.0".equals(jsonRpc)) {
            errors.add("jsonrpc field must be present. Only JSONRPC 2.0 is currently supported");
        }
    }

    private static void validateMethod(String method, List<String> errors) {
        if (method == null || method.isBlank()) {
            errors.add("method must be present and not empty");
        }
    }

    private static McpRequestId parseAndValidateId(JsonValue id, List<String> errors) {
        return switch (id.getValueType()) {
            case JsonValue.ValueType.NUMBER -> new McpRequestId(((JsonNumber)id).bigDecimalValue());
            case JsonValue.ValueType.STRING -> {
                String idString = ((JsonString)id).getString();
                if (idString.isBlank()) {
                    errors.add("id must not be empty");
                    yield null;
                }
                yield new McpRequestId(idString);
            }
            default -> {
                errors.add("id must be a string or number");
                yield null;
            }
        };
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.requests.McpRequest", McpRequest.class, (String)"MCP", null);
    }
}

