/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.HeaderValidation;
import io.openliberty.mcp.internal.McpProtocolVersion;
import io.openliberty.mcp.internal.McpSession;
import io.openliberty.mcp.internal.McpSessionStore;
import io.openliberty.mcp.internal.exceptions.jsonrpc.HttpResponseException;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCErrorCode;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCException;
import io.openliberty.mcp.internal.requests.McpRequest;
import io.openliberty.mcp.internal.requests.McpRequestId;
import io.openliberty.mcp.internal.responses.McpErrorResponse;
import io.openliberty.mcp.internal.responses.McpResultResponse;
import jakarta.json.JsonException;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class McpTransport {
    public static final String MCP_SESSION_ID_HEADER = "Mcp-Session-Id";
    private static final TraceComponent tc = Tr.register(McpTransport.class, (String)"MCP", null);
    private static final String MCP_HEADER = "MCP-Protocol-Version";
    private static final List<String> REQUIRED_MCP_MIME_TYPES = List.of("text/event-stream", "application/json");
    private HttpServletRequest req;
    private HttpServletResponse res;
    private Jsonb jsonb;
    private McpRequest mcpRequest;
    private Writer writer;
    private McpProtocolVersion version;
    private String sessionId;
    private McpSession sessionInfo;
    static final long serialVersionUID = -2991670656440376409L;

    public McpTransport(HttpServletRequest req, HttpServletResponse res, Jsonb jsonb) throws IOException {
        this.req = req;
        this.res = res;
        this.jsonb = jsonb;
        this.writer = res.getWriter();
    }

    @FFDCIgnore(value={NoSuchElementException.class})
    public void init(McpSessionStore sessionStore) throws IOException {
        if (!this.validReqAcceptHeader()) {
            throw new HttpResponseException(406);
        }
        try {
            this.version = this.readProtocolVersionHeader();
        }
        catch (NoSuchElementException e) {
            String supportedValues = Arrays.stream(McpProtocolVersion.values()).map(McpProtocolVersion::getVersion).collect(Collectors.joining(", "));
            throw new HttpResponseException(400, "Unsupported MCP-Protocol-Version header. Supported values: " + supportedValues);
        }
        this.mcpRequest = this.toRequest();
        String sessionIdHeader = this.req.getHeader(MCP_SESSION_ID_HEADER);
        if (sessionIdHeader == null) {
            this.sessionInfo = null;
            return;
        }
        McpSession session = sessionStore.getSession(sessionIdHeader);
        if (session == null) {
            throw new HttpResponseException(404, "Invalid or Expired Session Id");
        }
        this.sessionInfo = session;
    }

    @FFDCIgnore(value={JsonException.class})
    private McpRequest toRequest() throws IOException, JSONRPCException {
        McpRequest mcpRequest = null;
        try {
            BufferedReader re = this.req.getReader();
            mcpRequest = McpRequest.createValidMCPRequest(re);
        }
        catch (JsonException | JsonbException e) {
            throw new JSONRPCException(JSONRPCErrorCode.PARSE_ERROR, List.of(e.getMessage()));
        }
        return mcpRequest;
    }

    /*
     * WARNING - void declaration
     */
    private boolean validReqAcceptHeader() throws IOException {
        try {
            String reqHeaderAcceptedTypes = this.req.getHeader("Accept");
            if (reqHeaderAcceptedTypes == null) {
                return false;
            }
            for (String mcpMime : REQUIRED_MCP_MIME_TYPES) {
                if (HeaderValidation.acceptContains(reqHeaderAcceptedTypes, mcpMime)) continue;
                return false;
            }
            return true;
        }
        catch (Exception reqHeaderAcceptedTypes) {
            void e;
            FFDCFilter.processException((Throwable)reqHeaderAcceptedTypes, (String)"io.openliberty.mcp.internal.McpTransport", (String)"134", (Object)this, (Object[])new Object[0]);
            this.sendError((Exception)e);
            return false;
        }
    }

    private McpProtocolVersion readProtocolVersionHeader() {
        String protocolVersion = this.req.getHeader(MCP_HEADER);
        if (protocolVersion == null) {
            return McpProtocolVersion.V_2025_03_26;
        }
        return McpProtocolVersion.parse(protocolVersion);
    }

    public McpRequest getMcpRequest() {
        return this.mcpRequest;
    }

    void setResponseHeader(String name, String value) {
        this.res.setHeader(name, value);
    }

    public McpSession getSession() {
        return this.sessionInfo;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public <T> T getParams(Class<T> type) {
        return this.mcpRequest.getParams(type, this.jsonb);
    }

    public void sendResponse(Object result) {
        McpResultResponse mcpResponse = new McpResultResponse(this.mcpRequest.id(), result);
        this.res.setContentType("application/json");
        this.jsonb.toJson((Object)mcpResponse, this.writer);
    }

    public void sendEmptyResponse() {
        this.res.setStatus(202);
    }

    public void sendError(Exception e) throws IOException {
        Tr.error((TraceComponent)tc, (String)"Unexpected Server Error. Method={0} RequestURI={1} RequestQuery={2}", (Object[])new Object[]{this.req.getMethod(), this.req.getRequestURI(), this.req.getQueryString()});
        this.res.sendError(500, "An unexpected error occurred. Please try again later.");
    }

    public void sendJsonRpcException(JSONRPCException e) {
        McpErrorResponse mcpResponse = new McpErrorResponse(this.mcpRequest == null ? new McpRequestId("") : this.mcpRequest.id(), e);
        this.res.setContentType("application/json");
        this.jsonb.toJson((Object)mcpResponse, this.writer);
    }

    public void sendHttpException(HttpResponseException e) throws IOException {
        this.res.setStatus(e.getStatusCode());
        if (e.getHeaders() != null) {
            e.getHeaders().forEach((key, val) -> this.res.setHeader(key, val));
        }
        if (e.getMessage() != null) {
            this.res.setContentType("text/plain");
            this.writer.write(e.getMessage());
        }
    }

    public String getRequestIpAddress() {
        String ipAddress = this.req.getRemoteAddr();
        String proxyAddress = this.req.getHeader("X-Forwarded-For");
        if (proxyAddress != null && !proxyAddress.equals(ipAddress)) {
            throw new HttpResponseException(403, "Unknown proxy address.");
        }
        return ipAddress;
    }

    public McpProtocolVersion getProtocolVersion() {
        return this.version;
    }
}

