/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.spi.expression.function;

import jakarta.data.expression.ComparableExpression;
import jakarta.data.expression.NumericExpression;
import jakarta.data.expression.TextExpression;
import jakarta.data.messages.Messages;
import jakarta.data.spi.expression.function.FunctionExpression;
import jakarta.data.spi.expression.function.NumericFunctionExpressionRecord;
import java.util.List;

public interface NumericFunctionExpression<T, N extends Number>
extends FunctionExpression<T, N>,
NumericExpression<T, N> {
    public static final String ABS = "abs";
    public static final String LENGTH = "length";
    public static final String NEG = "-";

    @Override
    public List<? extends ComparableExpression<? super T, ?>> arguments();

    public static <T, N extends Number> NumericFunctionExpression<T, N> of(String name, NumericExpression<? super T, N> expression) {
        Messages.requireNonNull(expression, "expression");
        return new NumericFunctionExpressionRecord(name, List.of(expression));
    }

    public static <T, N extends Number> NumericFunctionExpression<T, N> of(String name, TextExpression<? super T> expression) {
        Messages.requireNonNull(expression, "expression");
        return new NumericFunctionExpressionRecord(name, List.of(expression));
    }
}

