/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.info.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.info.internal.AnnotationValueImpl;
import com.ibm.ws.annocache.info.internal.ClassInfoImpl;
import com.ibm.ws.annocache.info.internal.InfoStoreImpl;
import com.ibm.ws.annocache.info.internal.MethodInfoImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.info.AnnotationInfo;
import com.ibm.wsspi.annocache.info.AnnotationValue;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class AnnotationInfoImpl
implements AnnotationInfo {
    private static final Logger logger = Logger.getLogger("com.ibm.ws.annocache");
    private static final String CLASS_NAME = AnnotationInfoImpl.class.getSimpleName();
    protected String hashText;
    protected InfoStoreImpl infoStore;
    protected String annotationClassName;
    protected ClassInfoImpl annotationClassInfo;
    protected boolean isInherited;
    protected Map<String, AnnotationValueImpl> values;
    static final long serialVersionUID = 9048488126996463530L;

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHashText() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getHashText", new Object[0]);
        }
        String string = this.hashText;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getHashText", string);
        }
        return string;
    }

    public String toString() {
        return this.hashText;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AnnotationInfoImpl(String annotationClassName, InfoStoreImpl infoStore) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "<init>", new Object[]{annotationClassName, infoStore});
        }
        String methodName = "<init>";
        this.hashText = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " ( " + annotationClassName + " )";
        this.infoStore = infoStore;
        this.annotationClassName = infoStore.internClassName(annotationClassName);
        this.annotationClassInfo = null;
        this.isInherited = false;
        this.values = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] in [ {1} ]", new Object[]{this.getHashText(), infoStore.getHashText()});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public InfoStoreImpl getInfoStore() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getInfoStore", new Object[0]);
        }
        InfoStoreImpl infoStoreImpl = this.infoStore;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            infoStoreImpl = infoStoreImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getInfoStore", infoStoreImpl);
        }
        return infoStoreImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getAnnotationClassName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getAnnotationClassName", new Object[0]);
        }
        String string = this.annotationClassName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getAnnotationClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void resolveAnnotationClassInfo() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "resolveAnnotationClassInfo", new Object[0]);
        }
        this.annotationClassInfo = this.getInfoStore().getDelayableClassInfo(this.getAnnotationClassName());
        this.isInherited = this.getAnnotationClassInfo().isAnnotationPresent("java.lang.annotation.Inherited");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "resolveAnnotationClassInfo");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassInfoImpl getAnnotationClassInfo() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getAnnotationClassInfo", new Object[0]);
        }
        if (this.annotationClassInfo == null) {
            this.resolveAnnotationClassInfo();
        }
        ClassInfoImpl classInfoImpl = this.annotationClassInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classInfoImpl = classInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getAnnotationClassInfo", classInfoImpl);
        }
        return classInfoImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isInherited() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "isInherited", new Object[0]);
        }
        if (this.annotationClassInfo == null) {
            this.resolveAnnotationClassInfo();
        }
        boolean bl = this.isInherited;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "isInherited", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isValueDefaulted(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "isValueDefaulted", new Object[]{name});
        }
        boolean bl = this.values == null || !this.values.containsKey(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "isValueDefaulted", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AnnotationValueImpl getValue(String name) {
        AnnotationValueImpl annotationValue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getValue", new Object[]{name});
        }
        String methodName = "getValue";
        AnnotationValueImpl annotationValueImpl = annotationValue = this.values == null ? null : this.values.get(name);
        if (annotationValue == null) {
            ClassInfoImpl useAnnotationClassInfo = this.getAnnotationClassInfo();
            MethodInfoImpl methodInfo = useAnnotationClassInfo.getMethod(name);
            if (methodInfo == null) {
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_ANNOINFO_NO_METHOD [ {1} ] [ {2} ]", new Object[]{this.getHashText(), useAnnotationClassInfo.getHashText(), name});
            } else {
                annotationValue = methodInfo.getAnnotationDefaultValue();
            }
        }
        AnnotationValueImpl annotationValueImpl2 = annotationValue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            annotationValueImpl2 = annotationValueImpl2;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getValue", annotationValueImpl2);
        }
        return annotationValueImpl2;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AnnotationValueImpl getCachedAnnotationValue(String name) {
        AnnotationValueImpl annotationValue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getCachedAnnotationValue", new Object[]{name});
        }
        AnnotationValueImpl annotationValueImpl = annotationValue = this.values == null ? null : this.values.get(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            annotationValueImpl = annotationValueImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getCachedAnnotationValue", annotationValueImpl);
        }
        return annotationValueImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addAnnotationValue(String name, AnnotationValueImpl value) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "addAnnotationValue", new Object[]{name, value});
        }
        String methodName = "addAnnotationValue";
        if (this.values == null) {
            this.values = new HashMap<String, AnnotationValueImpl>();
        }
        AnnotationValueImpl oldValue = this.values.put(name, value);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Value Name [ {1} ] Value Enum Class [ {2} ] Value [ {3} ]", new Object[]{this.getHashText(), name, value.getEnumClassName(), value.getObjectValue()});
            if (oldValue != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Old value Name [ {1} ] Value Enum Class [ {2} ] Value [ {3} ]", new Object[]{this.getHashText(), name, oldValue.getEnumClassName(), oldValue.getObjectValue()});
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "addAnnotationValue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AnnotationValueImpl addAnnotationValue(String name, Object value) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "addAnnotationValue", new Object[]{name, value});
        }
        AnnotationValueImpl annotationValue = new AnnotationValueImpl(value);
        this.addAnnotationValue(name, annotationValue);
        AnnotationValueImpl annotationValueImpl = annotationValue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            annotationValueImpl = annotationValueImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "addAnnotationValue", annotationValueImpl);
        }
        return annotationValueImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AnnotationValueImpl addAnnotationValue(String name, String enumClassName, String enumName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "addAnnotationValue", new Object[]{name, enumClassName, enumName});
        }
        AnnotationValueImpl annotationValue = new AnnotationValueImpl(enumClassName, enumName);
        this.addAnnotationValue(name, annotationValue);
        AnnotationValueImpl annotationValueImpl = annotationValue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            annotationValueImpl = annotationValueImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "addAnnotationValue", annotationValueImpl);
        }
        return annotationValueImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AnnotationInfoImpl getAnnotationValue(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getAnnotationValue", new Object[]{name});
        }
        AnnotationValueImpl annotationValue = this.getValue(name);
        AnnotationInfoImpl annotationInfoImpl = annotationValue == null ? null : annotationValue.getAnnotationValue();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            annotationInfoImpl = annotationInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getAnnotationValue", annotationInfoImpl);
        }
        return annotationInfoImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<? extends AnnotationValue> getArrayValue(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getArrayValue", new Object[]{name});
        }
        AnnotationValueImpl annotationValue = this.getValue(name);
        List<? extends AnnotationValue> list = annotationValue == null ? null : annotationValue.getArrayValue();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getArrayValue", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Boolean getBoolean(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getBoolean", new Object[]{name});
        }
        AnnotationValueImpl annotationValue = this.getValue(name);
        Boolean bl = annotationValue == null ? null : annotationValue.getBoolean();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getBoolean", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean getBooleanValue(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getBooleanValue", new Object[]{name});
        }
        boolean bl = this.getValue(name).getBooleanValue();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getBooleanValue", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Byte getByte(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getByte", new Object[]{name});
        }
        AnnotationValueImpl annotationValue = this.getValue(name);
        Byte by = annotationValue == null ? null : annotationValue.getByte();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            by = by;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getByte", by);
        }
        return by;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public byte getByteValue(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getByteValue", new Object[]{name});
        }
        byte by = this.getValue(name).getByteValue();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            by = by;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getByteValue", by);
        }
        return by;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Character getCharacter(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getCharacter", new Object[]{name});
        }
        AnnotationValueImpl annotationValue = this.getValue(name);
        Character c = annotationValue == null ? null : annotationValue.getCharacter();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            c = c;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getCharacter", c);
        }
        return c;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public char getCharValue(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getCharValue", new Object[]{name});
        }
        char c = this.getValue(name).getCharValue();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            c = c;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getCharValue", Character.valueOf(c));
        }
        return c;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getClassNameValue(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getClassNameValue", new Object[]{name});
        }
        AnnotationValueImpl annotationValue = this.getValue(name);
        String string = annotationValue == null ? null : annotationValue.getClassNameValue();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getClassNameValue", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Double getDouble(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getDouble", new Object[]{name});
        }
        AnnotationValueImpl annotationValue = this.getValue(name);
        Double d = annotationValue == null ? null : annotationValue.getDouble();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            d = d;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getDouble", d);
        }
        return d;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public double getDoubleValue(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getDoubleValue", new Object[]{name});
        }
        double d = this.getValue(name).getDoubleValue();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            d = d;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getDoubleValue", d);
        }
        return d;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getEnumClassName(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getEnumClassName", new Object[]{name});
        }
        AnnotationValueImpl annotationValue = this.getValue(name);
        String string = annotationValue == null ? null : annotationValue.getEnumClassName();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getEnumClassName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getEnumValue(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getEnumValue", new Object[]{name});
        }
        AnnotationValueImpl annotationValue = this.getValue(name);
        String string = annotationValue == null ? null : annotationValue.getEnumValue();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "getEnumValue", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "log", new Object[]{useLogger});
        }
        String methodName = "log";
        if (!useLogger.isLoggable(Level.FINER)) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "log");
            }
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Annotation [ {0} ]", this.getAnnotationClassName());
        for (String valueName : this.values.keySet()) {
            AnnotationValueImpl nextValue = this.getValue(valueName);
            String valueEnumClassName = nextValue.getEnumClassName();
            Object valueValue = nextValue.getObjectValue();
            if (valueEnumClassName != null) {
                useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Value: Name [ {0} ] Enum Type [ {1} ] Value [ {2} ]", new Object[]{valueName, valueEnumClassName, valueValue});
                continue;
            }
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Value: Name [ {0} ] Value [ {1} ]", new Object[]{valueName, valueValue});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.AnnotationInfoImpl", "log");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(TraceComponent tc) {
        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Annotation [ {0} ]", this.getAnnotationClassName()), (Object[])new Object[0]);
        for (String valueName : this.values.keySet()) {
            AnnotationValueImpl nextValue = this.getValue(valueName);
            String valueEnumClassName = nextValue.getEnumClassName();
            Object valueValue = nextValue.getObjectValue();
            if (valueEnumClassName != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("  Value: Name [ {0} ] Enum Type [ {1} ] Value [ {2} ]", valueName, valueEnumClassName, valueValue), (Object[])new Object[0]);
                continue;
            }
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("  Value: Name [ {0} ] Value [ {1} ]", valueName, valueValue), (Object[])new Object[0]);
        }
    }
}

