/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.util.MethodAttribUtils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBUtils;
import com.ibm.ws.ejbcontainer.jitdeploy.JITUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class WSEJBProxy {
    private static final TraceComponent tc = Tr.register(WSEJBProxy.class, (String)"JITDeploy", (String)"com.ibm.ejs.container.container");

    static byte[] generateClassBytes(String proxyClassName, Class proxyInterface, java.lang.reflect.Method[] proxyMethods, EJBMethodInfoImpl[] methodInfos, String ejbClassName, String beanName) throws EJBConfigurationException {
        String[] internalImplements;
        String[] stringArray;
        String internalClassName = JITUtils.convertClassName(proxyClassName);
        String internalInterfaceName = JITUtils.convertClassName(proxyInterface);
        String internalEJBClassName = JITUtils.convertClassName(ejbClassName);
        String internalParentName = "com/ibm/ejs/container/WSEJBProxy";
        if (internalInterfaceName != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = internalInterfaceName;
        } else {
            stringArray = internalImplements = null;
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"generateClassBytes", (Object[])new Object[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("     className = " + internalClassName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("     interface = " + internalInterfaceName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("     parent    = " + internalParentName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("     ejb       = " + internalEJBClassName), (Object[])new Object[0]);
            }
        }
        ClassWriter cw = new ClassWriter(1);
        cw.visit(46, 33, internalClassName, null, internalParentName, internalImplements);
        String sourceFileName = proxyClassName.substring(proxyClassName.lastIndexOf(".") + 1) + ".java";
        cw.visitSource(sourceFileName, null);
        WSEJBProxy.addCtor(cw, internalParentName);
        int methodId = -1;
        for (int i = 0; i < proxyMethods.length; ++i) {
            java.lang.reflect.Method bridgeMethod;
            java.lang.reflect.Method method = proxyMethods[i];
            String implMethodName = method.getName();
            if (implMethodName.startsWith("ejb")) {
                String interfaceName = proxyInterface != null ? proxyInterface.getName() : "WebService Endpoint";
                Tr.error((TraceComponent)tc, (String)"JIT_INVALID_MTHD_PREFIX_CNTR5010E", (Object[])new Object[]{beanName, interfaceName, implMethodName});
                throw new EJBConfigurationException("EJB business method " + implMethodName + " on interface " + interfaceName + " must not start with 'ejb'.");
            }
            ++methodId;
            EJBMethodInfoImpl methodInfo = methodInfos[methodId = EJBUtils.getMethodId(method, proxyMethods, methodId)];
            boolean aroundInvoke = methodInfo.getAroundInterceptorProxies() != null;
            java.lang.reflect.Method ejbMethod = methodInfo.getMethod();
            if (aroundInvoke) {
                WSEJBProxy.addEJBInterceptorMethod(cw, internalClassName, internalEJBClassName, ejbMethod);
            } else {
                WSEJBProxy.addEJBMethod(cw, internalClassName, internalEJBClassName, ejbMethod);
            }
            if (proxyInterface == null || (bridgeMethod = methodInfo.getBridgeMethod()) == null) continue;
            if (aroundInvoke) {
                WSEJBProxy.addEJBInterceptorMethod(cw, internalClassName, internalEJBClassName, bridgeMethod);
                continue;
            }
            WSEJBProxy.addEJBMethod(cw, internalClassName, internalEJBClassName, bridgeMethod);
        }
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JITUtils.writeToClassFile(internalClassName, classBytes);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateClassBytes: " + classBytes.length + " bytes"));
        }
        return classBytes;
    }

    private static void addCtor(ClassWriter cw, String parent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : <init> ()V", (Object[])new Object[0]);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, parent, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void addEJBMethod(ClassWriter cw, String className, String implClassName, java.lang.reflect.Method method) {
        String methodName = method.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding method : " + methodName + " " + MethodAttribUtils.jdiMethodSignature(method) + " : isBridge = " + method.isBridge() + " : aroundInvoke = false"), (Object[])new Object[0]);
        }
        Type returnType = Type.getType(method.getReturnType());
        Type[] argTypes = JITUtils.getTypes(method.getParameterTypes());
        Type[] exceptionTypes = JITUtils.getTypes(method.getExceptionTypes());
        Method m = new Method(methodName, returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        Type implType = Type.getType((String)("L" + implClassName + ";"));
        mg.loadThis();
        mg.visitFieldInsn(180, className, "ivEjbInstance", "Ljava/lang/Object;");
        mg.checkCast(implType);
        mg.loadArgs(0, argTypes.length);
        mg.visitMethodInsn(182, implClassName, methodName, m.getDescriptor());
        mg.returnValue();
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addEJBInterceptorMethod(ClassWriter cw, String className, String implClassName, java.lang.reflect.Method method) throws EJBConfigurationException {
        String methodName = method.getName();
        String methodSignature = MethodAttribUtils.jdiMethodSignature(method);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding method : " + methodName + " " + methodSignature + " : isBridge = " + method.isBridge() + " : aroundInvoke = true"), (Object[])new Object[0]);
        }
        Class<?>[] methodExceptions = method.getExceptionTypes();
        Class<?>[] checkedExceptions = JITUtils.sortExceptions(methodExceptions, true);
        Type returnType = Type.getType(method.getReturnType());
        Type[] argTypes = JITUtils.getTypes(method.getParameterTypes());
        Type[] exceptionTypes = JITUtils.getTypes(methodExceptions);
        Method m = new Method(methodName, returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        int returnValue = -1;
        if (returnType != Type.VOID_TYPE) {
            returnValue = mg.newLocal(returnType);
            switch (returnType.getSort()) {
                case 1: {
                    mg.push(false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    mg.push(0);
                    break;
                }
                case 6: {
                    mg.push(0.0f);
                    break;
                }
                case 7: {
                    mg.push(0L);
                    break;
                }
                case 8: {
                    mg.push(0.0);
                    break;
                }
                default: {
                    mg.visitInsn(1);
                }
            }
            mg.storeLocal(returnValue);
        }
        int args = WSEJBProxy.createParameterArray(mg, argTypes);
        Label main_try_begin = new Label();
        mg.visitLabel(main_try_begin);
        mg.loadThis();
        mg.visitFieldInsn(180, className, "ivContainer", "Lcom/ibm/ejs/container/EJSContainer;");
        mg.loadThis();
        mg.visitFieldInsn(180, className, "ivMethodContext", "Lcom/ibm/ejs/container/EJSDeployedSupport;");
        mg.loadLocal(args);
        mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSContainer", "invoke", "(Lcom/ibm/ejs/container/EJSDeployedSupport;[Ljava/lang/Object;)Ljava/lang/Object;");
        if (returnType == Type.VOID_TYPE) {
            mg.pop();
        } else {
            JITUtils.unbox(mg, returnType);
            mg.storeLocal(returnValue);
        }
        Label main_try_end = new Label();
        mg.visitLabel(main_try_end);
        Label main_tcf_exit = new Label();
        mg.visitJumpInsn(167, main_tcf_exit);
        Label[] main_catch_label = new Label[checkedExceptions.length];
        int caught_ex = mg.newLocal(JITUtils.TYPE_Exception);
        for (int i = 0; i < checkedExceptions.length; ++i) {
            main_catch_label[i] = new Label();
            mg.visitLabel(main_catch_label[i]);
            mg.storeLocal(caught_ex);
            mg.loadLocal(caught_ex);
            mg.visitInsn(191);
        }
        Label main_catch_runtime = new Label();
        mg.visitLabel(main_catch_runtime);
        mg.storeLocal(caught_ex);
        mg.loadLocal(caught_ex);
        mg.visitInsn(191);
        Label main_catch_error = new Label();
        mg.visitLabel(main_catch_error);
        mg.storeLocal(caught_ex);
        mg.loadLocal(caught_ex);
        mg.visitInsn(191);
        Label main_catch_throwable = new Label();
        mg.visitLabel(main_catch_throwable);
        mg.storeLocal(caught_ex);
        mg.loadLocal(caught_ex);
        mg.visitMethodInsn(184, "com/ibm/ejs/container/WSEJBWrapper", "EJBException", "(Ljava/lang/Throwable;)Ljavax/ejb/EJBException;");
        mg.visitInsn(191);
        mg.visitLabel(main_tcf_exit);
        if (returnType != Type.VOID_TYPE) {
            mg.loadLocal(returnValue);
        }
        mg.returnValue();
        for (int i = 0; i < checkedExceptions.length; ++i) {
            mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_label[i], JITUtils.convertClassName(checkedExceptions[i].getName()));
        }
        mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_runtime, "java/lang/RuntimeException");
        mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_error, "java/lang/Error");
        mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_throwable, "java/lang/Throwable");
        mg.endMethod();
        mg.visitEnd();
    }

    private static int createParameterArray(GeneratorAdapter mg, Type[] argTypes) {
        int args = mg.newLocal(JITUtils.TYPE_Object_ARRAY);
        mg.push(argTypes.length);
        mg.visitTypeInsn(189, "java/lang/Object");
        mg.storeLocal(args);
        for (int i = 0; i < argTypes.length; ++i) {
            mg.loadLocal(args);
            mg.push(i);
            switch (argTypes[i].getSort()) {
                case 1: {
                    mg.visitTypeInsn(187, "java/lang/Boolean");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Boolean", "<init>", "(Z)V");
                    break;
                }
                case 2: {
                    mg.visitTypeInsn(187, "java/lang/Character");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Character", "<init>", "(C)V");
                    break;
                }
                case 3: {
                    mg.visitTypeInsn(187, "java/lang/Byte");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Byte", "<init>", "(B)V");
                    break;
                }
                case 4: {
                    mg.visitTypeInsn(187, "java/lang/Short");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Short", "<init>", "(S)V");
                    break;
                }
                case 5: {
                    mg.visitTypeInsn(187, "java/lang/Integer");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Integer", "<init>", "(I)V");
                    break;
                }
                case 6: {
                    mg.visitTypeInsn(187, "java/lang/Float");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Float", "<init>", "(F)V");
                    break;
                }
                case 7: {
                    mg.visitTypeInsn(187, "java/lang/Long");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Long", "<init>", "(J)V");
                    break;
                }
                case 8: {
                    mg.visitTypeInsn(187, "java/lang/Double");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Double", "<init>", "(D)V");
                    break;
                }
                default: {
                    mg.loadArg(i);
                }
            }
            mg.visitInsn(83);
        }
        return args;
    }
}

