/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.DuplicateMemberException;
import org.jboss.classfilewriter.code.BranchEnd;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.classfilewriter.util.Boxing;
import org.jboss.classfilewriter.util.DescriptorUtils;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.bean.proxy.BytecodeMethodResolver;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.bean.proxy.CommonProxiedMethodFilters;
import org.jboss.weld.bean.proxy.InterceptionDecorationContext;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.PrivateMethodHandler;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.bean.proxy.RunWithinInterceptionDecorationContextGenerator;
import org.jboss.weld.bean.proxy.SecurityActions;
import org.jboss.weld.bean.proxy.StackAwareMethodHandler;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.interceptor.proxy.LifecycleMixin;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.security.GetDeclaredMethodsAction;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.MethodInformation;
import org.jboss.weld.util.bytecode.RuntimeMethodInformation;
import org.jboss.weld.util.reflection.Reflections;

public class InterceptedSubclassFactory<T>
extends ProxyFactory<T> {
    public static final String PROXY_SUFFIX = "Subclass";
    private static final String SUPER_DELEGATE_SUFFIX = "$$super";
    static final String COMBINED_INTERCEPTOR_AND_DECORATOR_STACK_METHOD_HANDLER_CLASS_NAME = CombinedInterceptorAndDecoratorStackMethodHandler.class.getName();
    static final String[] INVOKE_METHOD_PARAMETERS = new String[]{DescriptorUtils.makeDescriptor(InterceptionDecorationContext.Stack.class), "Ljava/lang/Object;", "Ljava/lang/reflect/Method;", "Ljava/lang/reflect/Method;", "[Ljava/lang/Object;"};
    protected static final String PRIVATE_METHOD_HANDLER_FIELD_NAME = "privateMethodHandler";
    private final Set<MethodSignature> enhancedMethodSignatures;
    private final Set<MethodSignature> interceptedMethodSignatures;
    private Set<Class<?>> interfacesToInspect;
    private final Class<?> proxiedBeanType;

    public InterceptedSubclassFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean, Set<MethodSignature> enhancedMethodSignatures, Set<MethodSignature> interceptedMethodSignatures) {
        this(contextId, proxiedBeanType, typeClosure, InterceptedSubclassFactory.getProxyName(contextId, proxiedBeanType, typeClosure, bean), bean, enhancedMethodSignatures, interceptedMethodSignatures);
    }

    public InterceptedSubclassFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, String proxyName, Bean<?> bean, Set<MethodSignature> enhancedMethodSignatures, Set<MethodSignature> interceptedMethodSignatures) {
        super(contextId, proxiedBeanType, typeClosure, proxyName, bean, true);
        this.enhancedMethodSignatures = enhancedMethodSignatures;
        this.interceptedMethodSignatures = interceptedMethodSignatures;
        this.proxiedBeanType = proxiedBeanType;
    }

    @Override
    public void addInterfacesFromTypeClosure(Set<? extends Type> typeClosure, Class<?> proxiedBeanType) {
        for (Class<?> c : proxiedBeanType.getInterfaces()) {
            this.addInterface(c);
        }
        for (Type type : typeClosure) {
            Class c = Reflections.getRawType(type);
            if (!c.isInterface()) continue;
            this.addInterfaceToInspect(c);
        }
    }

    private void addInterfaceToInspect(Class<?> iface) {
        if (this.interfacesToInspect == null) {
            this.interfacesToInspect = new HashSet();
        }
        this.interfacesToInspect.add(iface);
    }

    @Override
    protected String getProxyNameSuffix() {
        return PROXY_SUFFIX;
    }

    @Override
    protected void addMethods(ClassFile proxyClassType, ClassMethod staticConstructor) {
        this.addMethodsFromClass(proxyClassType, staticConstructor);
        this.addSpecialMethods(proxyClassType, staticConstructor);
    }

    private boolean skipIfBridgeMethod(Method method, Collection<Method> classDeclaredMethods) {
        if (method.isBridge()) {
            for (Method declaredMethod : classDeclaredMethods) {
                Class<?>[] declaredMethodParams;
                Class<?>[] methodParams;
                if (declaredMethod.isBridge() || !method.getName().equals(declaredMethod.getName()) || (methodParams = method.getParameterTypes()).length != (declaredMethodParams = declaredMethod.getParameterTypes()).length) continue;
                boolean paramsNotMatching = false;
                for (int i = 0; i < methodParams.length; ++i) {
                    String declaredMethodParamName;
                    String methodParamName = methodParams[i].getName();
                    if (methodParamName.equals(declaredMethodParamName = declaredMethodParams[i].getName()) || methodParamName.equals(Object.class.getName())) continue;
                    paramsNotMatching = true;
                    break;
                }
                if (paramsNotMatching || Modifier.isInterface(declaredMethod.getDeclaringClass().getModifiers())) continue;
                if (method.getReturnType().getName().equals(Object.class.getName()) || Modifier.isAbstract(declaredMethod.getModifiers())) {
                    return true;
                }
                if (!method.getReturnType().getName().equals(declaredMethod.getReturnType().getName())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected void addMethodsFromClass(ClassFile proxyClassType, final ClassMethod staticConstructor) {
        try {
            HashSet<MethodSignatureImpl> finalMethods = new HashSet<MethodSignatureImpl>();
            HashSet<BridgeMethod> processedBridgeMethods = new HashSet<BridgeMethod>();
            for (Class<?> cls = this.getBeanType(); cls != null; cls = cls.getSuperclass()) {
                HashSet<BridgeMethod> declaredBridgeMethods = new HashSet<BridgeMethod>();
                List<Method> classDeclaredMethods = Arrays.asList((Method[])AccessController.doPrivileged(new GetDeclaredMethodsAction(cls)).clone());
                for (Method method : classDeclaredMethods) {
                    BridgeMethod bridgeMethod;
                    MethodSignatureImpl methodSignature = new MethodSignatureImpl(method);
                    if (!Modifier.isFinal(method.getModifiers()) && !this.skipIfBridgeMethod(method, classDeclaredMethods) && this.enhancedMethodSignatures.contains(methodSignature) && !finalMethods.contains(methodSignature) && CommonProxiedMethodFilters.NON_PRIVATE_WITHOUT_PACK_PRIVATE_PARAMS.accept(method, this.getProxySuperclass()) && !this.bridgeMethodsContainsMethod(processedBridgeMethods, methodSignature, method.getGenericReturnType(), Modifier.isAbstract(method.getModifiers()))) {
                        try {
                            ClassMethod classMethod;
                            final RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                            if (this.interceptedMethodSignatures.contains(methodSignature)) {
                                this.createDelegateMethod(proxyClassType, method, methodInfo);
                                classMethod = proxyClassType.addMethod(method);
                                this.addConstructedGuardToMethodBody(classMethod);
                                this.createForwardingMethodBody(classMethod, methodInfo, staticConstructor);
                                BeanLogger.LOG.addingMethodToProxy(method);
                                continue;
                            }
                            classMethod = proxyClassType.addMethod(method);
                            new RunWithinInterceptionDecorationContextGenerator(classMethod, this){

                                @Override
                                void doWork(CodeAttribute b, ClassMethod classMethod) {
                                    if (Modifier.isPrivate(classMethod.getAccessFlags())) {
                                        InterceptedSubclassFactory.this.invokePrivateMethodHandler(b, classMethod, methodInfo, staticConstructor);
                                    } else {
                                        b.aload(0);
                                        b.loadMethodParameters();
                                        b.invokespecial(methodInfo.getDeclaringClass(), methodInfo.getName(), methodInfo.getDescriptor());
                                    }
                                }

                                @Override
                                void doReturn(CodeAttribute b, ClassMethod method) {
                                    b.returnInstruction();
                                }
                            }.runStartIfNotOnTop();
                        }
                        catch (DuplicateMemberException methodInfo) {}
                        continue;
                    }
                    if (Modifier.isFinal(method.getModifiers())) {
                        finalMethods.add(methodSignature);
                    }
                    if (!method.isBridge() || this.hasAbstractPackagePrivateSuperClassWithImplementation(cls, bridgeMethod = new BridgeMethod(methodSignature, method.getGenericReturnType()))) continue;
                    declaredBridgeMethods.add(bridgeMethod);
                }
                processedBridgeMethods.addAll(declaredBridgeMethods);
            }
            HashSet allInterfaces = new HashSet(this.getAdditionalInterfaces());
            if (this.interfacesToInspect != null) {
                allInterfaces.addAll(this.interfacesToInspect);
            }
            for (Class clazz : allInterfaces) {
                for (Method method : clazz.getMethods()) {
                    MethodSignatureImpl signature = new MethodSignatureImpl(method);
                    if (this.enhancedMethodSignatures.contains(signature) && !this.bridgeMethodsContainsMethod(processedBridgeMethods, signature, null, Modifier.isAbstract(method.getModifiers()))) {
                        try {
                            RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                            if (this.interceptedMethodSignatures.contains(signature) && Reflections.isDefault(method)) {
                                this.createDelegateMethod(proxyClassType, method, methodInfo);
                                ClassMethod classMethod = proxyClassType.addMethod(method);
                                this.addConstructedGuardToMethodBody(classMethod);
                                this.createForwardingMethodBody(classMethod, methodInfo, staticConstructor);
                                BeanLogger.LOG.addingMethodToProxy(method);
                            } else if (Reflections.isDefault(method)) {
                                this.createDelegateMethod(proxyClassType, method, methodInfo);
                            }
                        }
                        catch (DuplicateMemberException duplicateMemberException) {
                            // empty catch block
                        }
                    }
                    if (!method.isBridge()) continue;
                    processedBridgeMethods.add(new BridgeMethod(signature, method.getGenericReturnType()));
                }
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private boolean hasAbstractPackagePrivateSuperClassWithImplementation(Class<?> clazz, BridgeMethod bridgeMethod) {
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!Modifier.isAbstract(superClass.getModifiers()) || !Reflections.isPackagePrivate(superClass.getModifiers())) continue;
            for (Method method : superClass.getDeclaredMethods()) {
                if (!bridgeMethod.signature.matches(method) || !method.getGenericReturnType().equals(bridgeMethod.returnType) || Reflections.isAbstract(method)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean bridgeMethodsContainsMethod(Set<BridgeMethod> processedBridgeMethods, MethodSignature signature, Type returnType, boolean isMethodAbstract) {
        for (BridgeMethod bridgeMethod : processedBridgeMethods) {
            if (!bridgeMethod.signature.equals(signature)) continue;
            if (returnType != null) {
                if (bridgeMethod.returnType.equals(Object.class) || isMethodAbstract) {
                    return true;
                }
                if (bridgeMethod.returnType instanceof Class && returnType instanceof TypeVariable) {
                    return true;
                }
                return bridgeMethod.returnType.equals(returnType);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void createForwardingMethodBody(ClassMethod classMethod, MethodInformation method, ClassMethod staticConstructor) {
        this.createInterceptorBody(classMethod, method, true, staticConstructor);
    }

    protected void createInterceptorBody(ClassMethod method, MethodInformation methodInfo, boolean delegateToSuper, ClassMethod staticConstructor) {
        this.invokeMethodHandler(method, methodInfo, true, DEFAULT_METHOD_RESOLVER, delegateToSuper, staticConstructor);
    }

    private void createDelegateToSuper(ClassMethod classMethod, MethodInformation method) {
        this.createDelegateToSuper(classMethod, method, classMethod.getClassFile().getSuperclass());
    }

    private void createDelegateToSuper(ClassMethod classMethod, MethodInformation method, String className) {
        CodeAttribute b = classMethod.getCodeAttribute();
        b.aload(0);
        b.loadMethodParameters();
        b.invokespecial(className, method.getName(), method.getDescriptor());
        b.returnInstruction();
    }

    protected void invokeMethodHandler(ClassMethod method, MethodInformation methodInfo, boolean addReturnInstruction, BytecodeMethodResolver bytecodeMethodResolver, boolean addProceed, ClassMethod staticConstructor) {
        CodeAttribute b = method.getCodeAttribute();
        b.aload(0);
        this.getMethodHandlerField(method.getClassFile(), b);
        if (addProceed) {
            b.dup();
            b.invokestatic(InterceptionDecorationContext.class.getName(), "getStack", "()" + DescriptorUtils.makeDescriptor(InterceptionDecorationContext.Stack.class));
            if (!Reflections.isDefault(methodInfo.getMethod()) && !Modifier.isPrivate(method.getAccessFlags())) {
                b.dupX1();
                b.invokevirtual(COMBINED_INTERCEPTOR_AND_DECORATOR_STACK_METHOD_HANDLER_CLASS_NAME, "isDisabledHandler", "(" + DescriptorUtils.makeDescriptor(InterceptionDecorationContext.Stack.class) + ")" + "Z");
                b.iconst(0);
                BranchEnd invokeSuperDirectly = b.ifIcmpeq();
                b.pop2();
                b.aload(0);
                b.loadMethodParameters();
                b.invokespecial(methodInfo.getDeclaringClass(), methodInfo.getName(), methodInfo.getDescriptor());
                b.returnInstruction();
                b.branchEnd(invokeSuperDirectly);
            }
        } else {
            b.aconstNull();
        }
        b.aload(0);
        bytecodeMethodResolver.getDeclaredMethod(method, methodInfo.getDeclaringClass(), methodInfo.getName(), methodInfo.getParameterTypes(), staticConstructor);
        if (addProceed) {
            if (Modifier.isPrivate(method.getAccessFlags())) {
                bytecodeMethodResolver.getDeclaredMethod(method, methodInfo.getDeclaringClass(), methodInfo.getName(), methodInfo.getParameterTypes(), staticConstructor);
            } else {
                bytecodeMethodResolver.getDeclaredMethod(method, method.getClassFile().getName(), methodInfo.getName() + SUPER_DELEGATE_SUFFIX, methodInfo.getParameterTypes(), staticConstructor);
            }
        } else {
            b.aconstNull();
        }
        b.iconst(methodInfo.getParameterTypes().length);
        b.anewarray(Object.class.getName());
        int localVariableCount = 1;
        for (int i = 0; i < methodInfo.getParameterTypes().length; ++i) {
            String typeString = methodInfo.getParameterTypes()[i];
            b.dup();
            b.iconst(i);
            BytecodeUtils.addLoadInstruction(b, typeString, localVariableCount);
            Boxing.boxIfNessesary((CodeAttribute)b, (String)typeString);
            b.aastore();
            if (DescriptorUtils.isWide((String)typeString)) {
                localVariableCount += 2;
                continue;
            }
            ++localVariableCount;
        }
        b.invokeinterface(StackAwareMethodHandler.class.getName(), "invoke", "Ljava/lang/Object;", INVOKE_METHOD_PARAMETERS);
        if (addReturnInstruction) {
            if (methodInfo.getReturnType().equals("V")) {
                b.returnInstruction();
            } else if (DescriptorUtils.isPrimitive((String)methodInfo.getReturnType())) {
                Boxing.unbox((CodeAttribute)b, (String)method.getReturnType());
                b.returnInstruction();
            } else {
                b.checkcast(BytecodeUtils.getName(methodInfo.getReturnType()));
                b.returnInstruction();
            }
        }
    }

    @Override
    protected void addSpecialMethods(ClassFile proxyClassType, ClassMethod staticConstructor) {
        try {
            for (Method method : LifecycleMixin.class.getMethods()) {
                BeanLogger.LOG.addingMethodToProxy(method);
                RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                this.createInterceptorBody(proxyClassType.addMethod(method), methodInfo, false, staticConstructor);
            }
            Method getInstanceMethod = TargetInstanceProxy.class.getMethod("weld_getTargetInstance", new Class[0]);
            Method getInstanceClassMethod = TargetInstanceProxy.class.getMethod("weld_getTargetClass", new Class[0]);
            InterceptedSubclassFactory.generateGetTargetInstanceBody(proxyClassType.addMethod(getInstanceMethod));
            InterceptedSubclassFactory.generateGetTargetClassBody(proxyClassType.addMethod(getInstanceClassMethod));
            Method setMethodHandlerMethod = ProxyObject.class.getMethod("weld_setHandler", MethodHandler.class);
            this.generateSetMethodHandlerBody(proxyClassType.addMethod(setMethodHandlerMethod));
            Method getMethodHandlerMethod = ProxyObject.class.getMethod("weld_getHandler", new Class[0]);
            this.generateGetMethodHandlerBody(proxyClassType.addMethod(getMethodHandlerMethod));
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private static void generateGetTargetInstanceBody(ClassMethod method) {
        CodeAttribute b = method.getCodeAttribute();
        b.aload(0);
        b.returnInstruction();
    }

    private static void generateGetTargetClassBody(ClassMethod method) {
        CodeAttribute b = method.getCodeAttribute();
        BytecodeUtils.pushClassType(b, method.getClassFile().getSuperclass());
        b.returnInstruction();
    }

    @Override
    public Class<?> getBeanType() {
        return this.proxiedBeanType;
    }

    @Override
    protected Class<? extends MethodHandler> getMethodHandlerType() {
        return CombinedInterceptorAndDecoratorStackMethodHandler.class;
    }

    @Override
    protected boolean isUsingProxyInstantiator() {
        return false;
    }

    private void createDelegateMethod(ClassFile proxyClassType, Method method, MethodInformation methodInformation) {
        int modifiers = (method.getModifiers() | 0x1000 | 2) & 0xFFFFFFFE & 0xFFFFFFFB;
        ClassMethod delegatingMethod = proxyClassType.addMethod(modifiers, method.getName() + SUPER_DELEGATE_SUFFIX, DescriptorUtils.makeDescriptor(method.getReturnType()), DescriptorUtils.parameterDescriptors((Class[])method.getParameterTypes()));
        delegatingMethod.addCheckedExceptions((Class[])method.getExceptionTypes());
        this.createDelegateToSuper(delegatingMethod, methodInformation);
    }

    private void invokePrivateMethodHandler(CodeAttribute b, ClassMethod classMethod, MethodInformation methodInfo, ClassMethod staticConstructor) {
        try {
            classMethod.getClassFile().addField(2, PRIVATE_METHOD_HANDLER_FIELD_NAME, MethodHandler.class);
        }
        catch (DuplicateMemberException duplicateMemberException) {
            // empty catch block
        }
        b.aload(0);
        b.getfield(classMethod.getClassFile().getName(), PRIVATE_METHOD_HANDLER_FIELD_NAME, DescriptorUtils.makeDescriptor(MethodHandler.class));
        b.aload(0);
        DEFAULT_METHOD_RESOLVER.getDeclaredMethod(classMethod, methodInfo.getDeclaringClass(), methodInfo.getName(), methodInfo.getParameterTypes(), staticConstructor);
        b.aconstNull();
        b.iconst(methodInfo.getParameterTypes().length);
        b.anewarray(Object.class.getName());
        int localVariableCount = 1;
        for (int i = 0; i < methodInfo.getParameterTypes().length; ++i) {
            String typeString = methodInfo.getParameterTypes()[i];
            b.dup();
            b.iconst(i);
            BytecodeUtils.addLoadInstruction(b, typeString, localVariableCount);
            Boxing.boxIfNessesary((CodeAttribute)b, (String)typeString);
            b.aastore();
            if (DescriptorUtils.isWide((String)typeString)) {
                localVariableCount += 2;
                continue;
            }
            ++localVariableCount;
        }
        b.invokeinterface(MethodHandler.class.getName(), "invoke", "Ljava/lang/Object;", new String[]{"Ljava/lang/Object;", "Ljava/lang/reflect/Method;", "Ljava/lang/reflect/Method;", "[Ljava/lang/Object;"});
        if (!methodInfo.getReturnType().equals("V")) {
            if (DescriptorUtils.isPrimitive((String)methodInfo.getReturnType())) {
                Boxing.unbox((CodeAttribute)b, (String)methodInfo.getReturnType());
            } else {
                b.checkcast(BytecodeUtils.getName(methodInfo.getReturnType()));
            }
        }
    }

    public static <T> void setPrivateMethodHandler(T instance) {
        if (instance instanceof ProxyObject && instance.getClass().isSynthetic() && instance.getClass().getName().endsWith(PROXY_SUFFIX) && SecurityActions.hasDeclaredField(instance.getClass(), PRIVATE_METHOD_HANDLER_FIELD_NAME)) {
            try {
                Field privateMethodHandlerField = SecurityActions.getDeclaredField(instance.getClass(), PRIVATE_METHOD_HANDLER_FIELD_NAME);
                SecurityActions.ensureAccessible(privateMethodHandlerField);
                privateMethodHandlerField.set(instance, PrivateMethodHandler.INSTANCE);
            }
            catch (NoSuchFieldException privateMethodHandlerField) {
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class BridgeMethod {
        private final Type returnType;
        private final MethodSignature signature;

        public BridgeMethod(MethodSignature signature, Type returnType) {
            this.signature = signature;
            this.returnType = returnType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
            result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BridgeMethod)) {
                return false;
            }
            BridgeMethod other = (BridgeMethod)obj;
            if (this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType)) {
                return false;
            }
            return !(this.signature == null ? other.signature != null : !this.signature.equals(other.signature));
        }

        public String toString() {
            return "method " + this.returnType + " " + this.signature.getMethodName() + Arrays.toString(this.signature.getParameterTypes()).replace('[', '(').replace(']', ')');
        }
    }
}

