/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics23.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.impl.Clock;
import com.ibm.ws.microprofile.metrics.impl.CounterImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import java.util.concurrent.Callable;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.SimpleTimer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SimpleTimerImpl
implements SimpleTimer {
    private final Counter count;
    private Duration elapsedTime;
    private final Clock clock;
    static final long serialVersionUID = -9134365135703446406L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SimpleTimerImpl() {
        this(Clock.defaultClock());
    }

    public SimpleTimerImpl(Clock clock) {
        this.clock = clock;
        this.count = new CounterImpl();
        this.elapsedTime = Duration.ZERO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Duration duration) {
        SimpleTimerImpl simpleTimerImpl = this;
        synchronized (simpleTimerImpl) {
            this.elapsedTime = this.elapsedTime.plus(duration);
        }
        if (duration.toNanos() >= 0L) {
            this.count.inc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(Duration.ofNanos(this.clock.getTick() - startTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void time(Runnable event) {
        long startTime = this.clock.getTick();
        try {
            event.run();
        }
        finally {
            this.update(Duration.ofNanos(this.clock.getTick() - startTime));
        }
    }

    public Context time() {
        return new Context(this, this.clock);
    }

    public long getCount() {
        return this.count.getCount();
    }

    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.metrics23.impl.SimpleTimerImpl", SimpleTimerImpl.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Context
    implements SimpleTimer.Context {
        private final SimpleTimerImpl simpleTimer;
        private final Clock clock;
        private final long startTime;
        static final long serialVersionUID = 7233778364473423667L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private Context(SimpleTimerImpl simpleTimer, Clock clock) {
            this.simpleTimer = simpleTimer;
            this.clock = clock;
            this.startTime = clock.getTick();
        }

        public long stop() {
            long elapsed = this.clock.getTick() - this.startTime;
            this.simpleTimer.update(Duration.ofNanos(elapsed));
            return elapsed;
        }

        public void close() {
            this.stop();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.metrics23.impl.SimpleTimerImpl$Context", Context.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
        }
    }
}

