/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Optional;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpStatAttributes {
    private final String httpStat_ID;
    private static final TraceComponent tc = Tr.register(HttpStatAttributes.class, null, null);
    private final String requestMethod;
    private final String scheme;
    private final String networkProtocolName;
    private final String networkProtocolVersion;
    private final String serverName;
    private final int serverPort;
    private final Exception exception;
    private final String errorType;
    private final String httpRoute;
    private final int responseStatus;
    static final long serialVersionUID = 1486003602624096642L;

    HttpStatAttributes(Builder builder) throws IllegalStateException {
        if (!builder.validate()) {
            throw new IllegalStateException("Invalid HTTP Stats attributes");
        }
        this.requestMethod = builder.requestMethod;
        this.scheme = builder.scheme;
        this.networkProtocolName = builder.networkProtocolName;
        this.networkProtocolVersion = builder.networkProtocolVersion;
        this.serverName = builder.serverName;
        this.serverPort = builder.serverPort;
        this.exception = builder.exception.isPresent() ? (Exception)builder.exception.get() : null;
        this.errorType = builder.errorType.isPresent() ? (String)builder.errorType.get() : null;
        this.httpRoute = builder.httpRoute.isPresent() ? (String)builder.httpRoute.get() : null;
        this.responseStatus = builder.responseStatus.isPresent() ? (Integer)builder.responseStatus.get() : -1;
        this.httpStat_ID = this.resolveKeyID();
    }

    private String resolveKeyID() {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append("method:").append(this.requestMethod);
        if (this.responseStatus != -1) {
            sb.append(";status:").append(this.responseStatus);
        }
        if (this.httpRoute != null) {
            sb.append(";httpRoute:").append(this.httpRoute.replace("*", "\\*"));
        }
        if (this.errorType != null) {
            sb.append(";errorType:").append(this.errorType);
        }
        sb.append("\"");
        return sb.toString();
    }

    public String getErrorType() {
        return this.errorType;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getNetworkProtocolName() {
        return this.networkProtocolName;
    }

    public String getNetworkProtocolVersion() {
        return this.networkProtocolVersion;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getHttpRoute() {
        return this.httpRoute;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public String getHttpStatID() {
        return this.httpStat_ID;
    }

    public String toString() {
        return String.format(" ------- \nRequest Method (mandatory): [%s] \nScheme (mandatory): [%s] \nNetwork Protocol Name (optional): [%s] \nNetwork Protocol Version (mandatory): [%s] \nServer Name (mandatory): [%s] \nServer Port (mandatory): [%d] \nHTTP Route (Optional: can be empty): [%s] \nResponse Status (Optional: can be -1): [%d] \nError Type(Optional - can be empty): [%s]", this.requestMethod, this.scheme, this.networkProtocolName, this.networkProtocolVersion, this.serverName, this.serverPort, this.httpRoute, this.responseStatus, this.errorType);
    }

    public static Builder builder() {
        return new Builder();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Builder {
        private String requestMethod;
        private String scheme;
        private String networkProtocolName;
        private String networkProtocolVersion;
        private String serverName;
        private int serverPort;
        private Optional<Exception> exception = Optional.ofNullable(null);
        private Optional<String> errorType = Optional.ofNullable(null);
        private Optional<String> httpRoute = Optional.ofNullable(null);
        private Optional<Integer> responseStatus = Optional.ofNullable(null);
        static final long serialVersionUID = -2581228005803597281L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        Builder() {
        }

        @FFDCIgnore(value={IllegalStateException.class})
        public HttpStatAttributes build() {
            try {
                return new HttpStatAttributes(this);
            }
            catch (IllegalStateException ise) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)String.format("Invalid HTTP Stats attributes : \n %s", this.toString()), (Object[])new Object[0]);
                }
                return null;
            }
        }

        public Builder withRequestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public Builder withErrorType(String error) {
            this.errorType = Optional.ofNullable(error);
            return this;
        }

        public Builder withException(Exception exception) {
            this.exception = Optional.ofNullable(exception);
            return this;
        }

        public Builder withHttpRoute(String httpRoute) {
            this.httpRoute = Optional.ofNullable(httpRoute);
            return this;
        }

        public Builder withScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder withNetworkProtocolName(String networkProtocolName) {
            this.networkProtocolName = networkProtocolName;
            return this;
        }

        public Builder withNetworkProtocolVersion(String networkProtocolVersion) {
            this.networkProtocolVersion = networkProtocolVersion;
            return this;
        }

        public Builder withServerName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public Builder withServerPort(int serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        public Builder withResponseStatus(int responseStatus) {
            this.responseStatus = Optional.ofNullable(responseStatus);
            if (responseStatus >= 500) {
                this.withErrorType(Integer.toString(responseStatus));
            }
            return this;
        }

        public boolean validate() {
            return this.requestMethod != null && this.scheme != null && this.networkProtocolName != null && this.networkProtocolVersion != null && this.serverName != null && this.serverPort != 0;
        }

        public String toString() {
            return String.format(" ------- \nRequest Method (mandatory): [%s] \nScheme (mandatory): [%s] \nNetwork Protocol Name (optional): [%s] \nNetwork Protocol Version (mandatory): [%s] \nServer Name (mandatory): [%s] \nServer Port (mandatory): [%d] \nHTTP Route (Optional: can be empty): [%s] \nResponse Status (Optional: can be -1): [%d] \nError Type(Optional - can be empty): [%s]", this.requestMethod, this.scheme, this.networkProtocolName, this.networkProtocolVersion, this.serverName, this.serverPort, this.httpRoute.orElse(null), this.responseStatus.orElse(null), this.errorType.orElse(null));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.http.monitor.HttpStatAttributes$Builder", Builder.class, null, null);
        }
    }
}

