/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.view.facelets.compiler.Instruction;

final class CompositeTextInstruction
implements Instruction {
    private Instruction[] instructions;

    public CompositeTextInstruction(Instruction[] instructions) {
        this.instructions = instructions;
    }

    @Override
    public void write(FacesContext context) throws IOException {
        for (Instruction i : this.instructions) {
            i.write(context);
        }
    }

    @Override
    public Instruction apply(ExpressionFactory factory, ELContext ctx) {
        Instruction[] array = new Instruction[this.instructions.length];
        for (int i = 0; i < this.instructions.length; ++i) {
            array[i] = this.instructions[i].apply(factory, ctx);
        }
        return new CompositeTextInstruction(array);
    }

    @Override
    public boolean isLiteral() {
        boolean literal = true;
        for (Instruction i : this.instructions) {
            if (i.isLiteral()) continue;
            literal = false;
            break;
        }
        return literal;
    }
}

