/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ModuleRuntimeContainer;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.MetaDataService;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jca.internal.BootstrapContextImpl;
import com.ibm.ws.jca.internal.ConnectorModuleMetaDataImpl;
import com.ibm.ws.jca.internal.ConnectorModuleMetatype;
import com.ibm.ws.jca.internal.ResourceAdapterMetaData;
import com.ibm.ws.jca.internal.Utils;
import com.ibm.ws.jca.metadata.ConnectorModuleMetaData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import jakarta.resource.spi.BootstrapContext;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ModuleRuntimeContainer.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "type:String=connector"})
public class ConnectorModuleRuntimeContainer
implements ModuleRuntimeContainer {
    private static final TraceComponent tc = Tr.register(ConnectorModuleRuntimeContainer.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.internal.resources.J2CAMessages");
    private final BundleContext bundleContext;
    private final ConfigurationAdmin configAdmin;
    private final FutureMonitor futureMonitor;
    private final MetaDataService metaDataService;
    private final ConcurrentHashMap<String, ConnectorModuleMetatype> moduleMetatype = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ServiceListener[]> serviceListeners = new ConcurrentHashMap();
    static final long serialVersionUID = -6284260824203454974L;

    @Activate
    public ConnectorModuleRuntimeContainer(BundleContext bundleContext, @Reference ConfigurationAdmin configAdmin, @Reference FutureMonitor futureMonitor, @Reference MetaDataService metaDataService) {
        this.bundleContext = bundleContext;
        this.configAdmin = configAdmin;
        this.futureMonitor = futureMonitor;
        this.metaDataService = metaDataService;
    }

    /*
     * WARNING - void declaration
     */
    public ModuleMetaData createModuleMetaData(ExtendedModuleInfo moduleInfo) throws MetaDataException {
        ConnectorModuleMetaData cmmd;
        Container container = moduleInfo.getContainer();
        try {
            cmmd = (ConnectorModuleMetaData)container.adapt(ConnectorModuleMetaData.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jca.internal.ConnectorModuleRuntimeContainer", (String)"103", (Object)this, (Object[])new Object[]{moduleInfo});
            throw new MetaDataException((Throwable)e);
        }
        return cmmd;
    }

    private void removeServiceListeners(String id) {
        ServiceListener[] listeners = this.serviceListeners.remove(id);
        if (listeners != null) {
            for (ServiceListener listener : listeners) {
                if (listener == null) continue;
                this.bundleContext.removeServiceListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @FFDCIgnore(value={TimeoutException.class})
    public Future<Boolean> startModule(ExtendedModuleInfo moduleInfo) throws StateChangeException {
        RARInstallListener rarInstallListener;
        block31: {
            ConnectorModuleMetatype cmmt;
            boolean trace = TraceComponent.isAnyTracingEnabled();
            ConnectorModuleMetaDataImpl metadataImpl = (ConnectorModuleMetaDataImpl)moduleInfo.getMetaData();
            String id = metadataImpl.getIdentifier();
            ResourceAdapterMetaData raMetaData = (ResourceAdapterMetaData)metadataImpl.getComponentMetaDatas()[0];
            Container container = moduleInfo.getContainer();
            try {
                cmmt = (ConnectorModuleMetatype)container.adapt(ConnectorModuleMetatype.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jca.internal.ConnectorModuleRuntimeContainer", (String)"282", (Object)this, (Object[])new Object[]{moduleInfo});
                throw new StateChangeException((Throwable)e);
            }
            try {
                this.metaDataService.fireComponentMetaDataCreated((ComponentMetaData)raMetaData);
            }
            catch (MetaDataException e) {
                void mde;
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jca.internal.ConnectorModuleRuntimeContainer", (String)"288", (Object)this, (Object[])new Object[]{moduleInfo});
                throw new StateChangeException((Throwable)mde);
            }
            try {
                cmmt.generateMetatype();
            }
            catch (Exception mde) {
                void x;
                FFDCFilter.processException((Throwable)mde, (String)"com.ibm.ws.jca.internal.ConnectorModuleRuntimeContainer", (String)"294", (Object)this, (Object[])new Object[]{moduleInfo});
                if (x instanceof StateChangeException) {
                    throw (StateChangeException)x;
                }
                throw new StateChangeException((Throwable)x);
            }
            this.moduleMetatype.put(id.toUpperCase(), cmmt);
            String bootstrapContextFactoryPid = cmmt.getBootstrapContextFactoryPid();
            try {
                rarInstallListener = new RARInstallListener(id, bootstrapContextFactoryPid, cmmt.getAutoStart());
            }
            catch (Throwable throwable) {
                void x;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jca.internal.ConnectorModuleRuntimeContainer", (String)"309", (Object)this, (Object[])new Object[]{moduleInfo});
                throw new StateChangeException((Throwable)x);
            }
            try {
                cmmt.registerMetatype();
            }
            catch (Exception x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.jca.internal.ConnectorModuleRuntimeContainer", (String)"316", (Object)this, (Object[])new Object[]{moduleInfo});
                throw new StateChangeException((Throwable)x);
            }
            while (!FrameworkState.isStopping()) {
                try {
                    if (rarInstallListener.latch.await(1000L, TimeUnit.MILLISECONDS)) {
                        if (!trace || !tc.isEventEnabled()) break;
                        Tr.event((TraceComponent)tc, (String)("[" + id + "] BootstrapContext CountDownLatch complete"), (Object[])new Object[0]);
                        break;
                    }
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("[" + id + "] BootstrapContext service event has not arrived"), (Object[])new Object[0]);
                }
                catch (InterruptedException x) {
                    FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.jca.internal.ConnectorModuleRuntimeContainer", (String)"330", (Object)this, (Object[])new Object[]{moduleInfo});
                    x.getCause();
                }
            }
            if (!FrameworkState.isStopping()) {
                try {
                    rarInstallListener.future.get(metadataImpl.getMaxWaitForResources(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException x) {
                    FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.jca.internal.ConnectorModuleRuntimeContainer", (String)"338", (Object)this, (Object[])new Object[]{moduleInfo});
                    this.futureMonitor.setResult(rarInstallListener.future, (Throwable)x);
                }
                catch (ExecutionException x) {
                    FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.jca.internal.ConnectorModuleRuntimeContainer", (String)"340", (Object)this, (Object[])new Object[]{moduleInfo});
                    throw new StateChangeException((Throwable)x);
                }
                catch (TimeoutException x) {
                    if (trace && tc.isEventEnabled()) {
                        RARInstallListener rARInstallListener = rarInstallListener;
                        synchronized (rARInstallListener) {
                            Tr.event((TraceComponent)tc, (String)("[" + id + "] Timed out waiting for configured resource instances to be registered. Configured/Registered:"), (Object[])new Object[]{rarInstallListener.instancesConfigured, rarInstallListener.instancesRegistered});
                        }
                    }
                    try {
                        Collection refs = Utils.priv.getServiceReferences(this.bundleContext, BootstrapContext.class, "(id=" + id + ')');
                        if (refs == null || refs.isEmpty()) {
                            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"420", (Object)this, (Object[])new Object[]{id, bootstrapContextFactoryPid});
                            this.futureMonitor.setResult(rarInstallListener.future, (Throwable)x);
                            break block31;
                        }
                        this.futureMonitor.setResult(rarInstallListener.future, (Object)true);
                    }
                    catch (InvalidSyntaxException refs) {
                        void e;
                        FFDCFilter.processException((Throwable)refs, (String)"com.ibm.ws.jca.internal.ConnectorModuleRuntimeContainer", (String)"359", (Object)this, (Object[])new Object[]{moduleInfo});
                        this.futureMonitor.setResult(rarInstallListener.future, (Throwable)e);
                    }
                }
                finally {
                    this.removeServiceListeners(id);
                }
            }
        }
        return rarInstallListener.future;
    }

    /*
     * WARNING - void declaration
     */
    public void stopModule(ExtendedModuleInfo moduleInfo) {
        boolean stopped;
        ConnectorModuleMetaDataImpl metadataImpl = (ConnectorModuleMetaDataImpl)moduleInfo.getMetaData();
        String id = metadataImpl.getIdentifier();
        this.metaDataService.fireComponentMetaDataDestroyed(metadataImpl.getComponentMetaDatas()[0]);
        this.removeServiceListeners(id);
        CountDownLatch bcLatch = BootstrapContextImpl.latches.get(id);
        ConnectorModuleMetatype cmmt = this.moduleMetatype.remove(id.toUpperCase());
        if (cmmt != null) {
            try {
                cmmt.removeMetatype();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jca.internal.ConnectorModuleRuntimeContainer", (String)"391", (Object)this, (Object[])new Object[]{moduleInfo});
            }
        }
        boolean bl = stopped = bcLatch == null || FrameworkState.isStopping();
        while (!stopped) {
            try {
                stopped = bcLatch.await(1L, TimeUnit.SECONDS) || FrameworkState.isStopping();
            }
            catch (InterruptedException interruptedException) {
                void e;
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.jca.internal.ConnectorModuleRuntimeContainer", (String)"398", (Object)this, (Object[])new Object[]{moduleInfo});
                e.getCause();
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class RARInstallListener
    implements ServiceListener {
        private final boolean autoStart;
        private final CountDownLatch latch = new CountDownLatch(1);
        private final Future<Boolean> future;
        private final String id;
        private final Set<String> instancesConfigured = new HashSet<String>();
        private final Set<String> instancesRegistered = new HashSet<String>();
        static final long serialVersionUID = 6917410685550489191L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private RARInstallListener(String id, String bootstrapContextFactoryPid, boolean autoStart) throws InvalidSyntaxException, IOException {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            this.autoStart = autoStart;
            this.future = ConnectorModuleRuntimeContainer.this.futureMonitor.createFuture(Boolean.class);
            this.id = id;
            this.instancesConfigured.add("com.ibm.ws.jca.resourceAdapter.properties");
            String filter = "(|(service.factoryPid=properties." + id + ")(service.factoryPid=properties." + id + ".*))";
            Configuration[] configs = ConnectorModuleRuntimeContainer.this.configAdmin.listConfigurations(filter);
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)ConnectorModuleRuntimeContainer.this, (TraceComponent)tc, (String)("[" + id + "] " + filter), (Object[])configs);
            }
            HashSet<String> parentPIDs = new HashSet<String>();
            if (configs != null) {
                for (Configuration c : configs) {
                    String parentPID = (String)c.getProperties().get("config.parentPID");
                    if (parentPID == null || parentPID.length() <= 25 || parentPID.lastIndexOf(95) <= 0 || parentPID.charAt(15) == 'r' || parentPID.charAt(15) == 'e') continue;
                    parentPIDs.add(parentPID);
                }
            }
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)ConnectorModuleRuntimeContainer.this, (TraceComponent)tc, (String)("[" + id + "] parent pids"), (Object[])new Object[]{parentPIDs});
            }
            this.instancesConfigured.addAll(parentPIDs);
            ServiceListener[] listeners = new ServiceListener[4];
            ConnectorModuleRuntimeContainer.this.serviceListeners.put(id, listeners);
            listeners[0] = this;
            ConnectorModuleRuntimeContainer.this.bundleContext.addServiceListener(listeners[0], "(&(objectClass=ja*.resource.spi.BootstrapContext)(id=" + id + "))");
            listeners[1] = new ResourceListener();
            ConnectorModuleRuntimeContainer.this.bundleContext.addServiceListener(listeners[1], "(&(objectClass=com.ibm.ws.jca.service.AdminObjectService)(properties.0.config.referenceType=com.ibm.ws.jca.*.properties." + id + ".*))");
            listeners[2] = new ResourceListener();
            ConnectorModuleRuntimeContainer.this.bundleContext.addServiceListener(listeners[2], "(&(objectClass=com.ibm.ws.jca.service.ConnectionFactoryService)(properties.0.config.referenceType=com.ibm.ws.jca.*onnectionFactory.properties." + id + ".*))");
            listeners[3] = new ResourceListener();
            ConnectorModuleRuntimeContainer.this.bundleContext.addServiceListener(listeners[3], "(&(objectClass=com.ibm.ws.jca.service.EndpointActivationService)(properties.0.config.referenceType=com.ibm.ws.jca.*ctivationSpec.properties." + id + ".*))");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 1) {
                String pid;
                ServiceReference serviceRef = event.getServiceReference();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)ConnectorModuleRuntimeContainer.this, (TraceComponent)tc, (String)("[" + this.id + "] serviceChanged"), (Object[])new Object[]{serviceRef});
                }
                if ("com.ibm.ws.jca.resourceAdapter.properties".equals(pid = (String)serviceRef.getProperty("service.factoryPid"))) {
                    this.latch.countDown();
                    if (this.autoStart) {
                        try {
                            Utils.priv.getService(ConnectorModuleRuntimeContainer.this.bundleContext, event.getServiceReference());
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jca.internal.ConnectorModuleRuntimeContainer$RARInstallListener", (String)"238", (Object)this, (Object[])new Object[]{event});
                        }
                    }
                } else {
                    pid = (String)serviceRef.getProperty("ibm.extends.source.pid");
                    if (pid == null) {
                        pid = (String)serviceRef.getProperty("service.pid");
                    }
                }
                if (pid != null) {
                    boolean allInstancesAreRegistered;
                    RARInstallListener rARInstallListener = this;
                    synchronized (rARInstallListener) {
                        allInstancesAreRegistered = this.instancesRegistered.add(pid) && this.instancesConfigured.contains(pid) && this.instancesRegistered.containsAll(this.instancesConfigured);
                    }
                    if (allInstancesAreRegistered) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("[" + this.id + "] all instances registered"), (Object[])new Object[]{this.instancesConfigured, this.instancesRegistered});
                        }
                        ConnectorModuleRuntimeContainer.this.removeServiceListeners(this.id);
                        ConnectorModuleRuntimeContainer.this.futureMonitor.setResult(this.future, (Object)true);
                    }
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jca.internal.ConnectorModuleRuntimeContainer$RARInstallListener", RARInstallListener.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.internal.resources.J2CAMessages");
        }

        @Trivial
        private final class ResourceListener
        implements ServiceListener {
            private ResourceListener() {
            }

            public void serviceChanged(ServiceEvent event) {
                RARInstallListener.this.serviceChanged(event);
            }
        }
    }
}

