/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPInvalidRuntimeIDException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.TargetStreamManager;
import com.ibm.ws.sib.processor.impl.AOBrowserSession;
import com.ibm.ws.sib.processor.impl.AOBrowserSessionKey;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.ProducerInputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPLocalMsgsItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLocalQueuePointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPMessageHandlerControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueuedMessageControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteConsumerTransmitControllable;
import com.ibm.ws.sib.processor.runtime.anycast.RemoteBrowserIterator;
import com.ibm.ws.sib.processor.runtime.impl.AbstractRegisteredControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.QueuedMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class LocalQueuePoint
extends AbstractRegisteredControlAdapter
implements SIMPLocalQueuePointControllable {
    private BaseDestinationHandler destinationHandler;
    private ProducerInputHandler inputHandler;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static TraceComponent tc = SibTr.register(LocalQueuePoint.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private PtoPLocalMsgsItemStream itemStream;
    private SIMPMessageHandlerControllable handlerControl;
    private String messageHandlerName;
    private String id;

    public LocalQueuePoint(MessageProcessor messageProcessor, PtoPLocalMsgsItemStream itemStream) {
        super(messageProcessor, ControllableType.QUEUE_POINT);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LocalQueuePoint", (Object)new Object[]{messageProcessor, itemStream});
        }
        this.itemStream = itemStream;
        this.destinationHandler = itemStream.getDestinationHandler();
        this.handlerControl = (SIMPMessageHandlerControllable)this.destinationHandler.getControlAdapter();
        this.inputHandler = (ProducerInputHandler)this.destinationHandler.getInputHandler();
        this.messageHandlerName = this.handlerControl.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LocalQueuePoint", (Object)this);
        }
    }

    public void setDestinationHighMsgs(long newDestHighMsgs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestinationHighMsgs", (Object)new Long(newDestHighMsgs));
        }
        this.itemStream.setDestHighMsgs(newDestHighMsgs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestinationHighMsgs");
        }
    }

    public void setDestinationLowMsgs(long newDestLowMsgs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestinationLowMsgs", (Object)new Long(newDestLowMsgs));
        }
        this.itemStream.setDestHighMsgs(newDestLowMsgs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestinationLowMsgs");
        }
    }

    public long getDestinationHighMsgs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHighMsgs");
        }
        long destHighMsgs = this.itemStream.getDestHighMsgs();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHighMsgs", (Object)new Long(destHighMsgs));
        }
        return destHighMsgs;
    }

    public long getDestinationLowMsgs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationLowMsgs");
        }
        long destLowMsgs = this.itemStream.getDestLowMsgs();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationLowMsgs", (Object)new Long(destLowMsgs));
        }
        return destLowMsgs;
    }

    public boolean isSendAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed");
        }
        boolean isSendAllowed = this.itemStream.isSendAllowed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed", (Object)new Boolean(isSendAllowed));
        }
        return isSendAllowed;
    }

    public void setSendAllowed(boolean newSendAllowedValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSendAllowed", (Object)new Boolean(newSendAllowedValue));
        }
        this.itemStream.setSendAllowed(newSendAllowedValue);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSendAllowed", (Object)new Boolean(newSendAllowedValue));
        }
    }

    public SIMPMessageHandlerControllable getMessageHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageHandler");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageHandler", (Object)this.handlerControl);
        }
        return this.handlerControl;
    }

    public SIMPIterator getQueuedMessageIterator() throws SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuedMessageIterator");
        }
        ArrayList<ControlAdapter> messages = new ArrayList<ControlAdapter>();
        NonLockingCursor cursor = null;
        try {
            cursor = this.itemStream.newNonLockingItemCursor(null);
            cursor.allowUnavailableItems();
            MessageItem item = (MessageItem)cursor.next();
            while (item != null) {
                item.forceCurrentMEArrivalTimeToJsMessage();
                ControlAdapter cAdapter = item.getControlAdapter();
                if (cAdapter != null) {
                    messages.add(cAdapter);
                }
                item = (MessageItem)cursor.next();
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.LocalQueuePoint.getQueuedMessageIterator", (String)"1:264:1.58", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageIterator", (Object)((Object)e));
            }
            throw new SIMPRuntimeOperationFailedException((Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.finished();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageIterator");
        }
        return new BasicSIMPIterator(messages.iterator());
    }

    public void moveMessages(boolean discard) throws SIMPRuntimeOperationFailedException, SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteAllQueuedMessages", (Object)new Boolean(discard));
        }
        this.assertValidControllable();
        SIMPRuntimeOperationFailedException runtimeException = null;
        SIMPIterator msgItr = this.getQueuedMessageIterator();
        while (msgItr.hasNext()) {
            QueuedMessage msg = (QueuedMessage)msgItr.next();
            try {
                msg.moveMessage(discard);
            }
            catch (SIMPControllableNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.LocalQueuePoint.deleteAllQueuedMessages", (String)"1:311:1.58", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            catch (SIMPRuntimeOperationFailedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.LocalQueuePoint.deleteAllQueuedMessages", (String)"1:324:1.58", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (runtimeException != null) continue;
                runtimeException = e;
            }
        }
        if (runtimeException != null) {
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"QueuedMessage.removeMessage", "1:340:1.58", runtimeException, this.id}, null), (Throwable)runtimeException);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteAllQueuedMessages");
        }
    }

    public SIMPQueuedMessageControllable getQueuedMessageByID(String ID) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuedMessageByID", (Object)new Object[]{ID});
        }
        long messageID = -1L;
        try {
            messageID = Long.parseLong(ID);
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.LocalQueuePoint.getQueuedMessageByID", (String)"1:373:1.58", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageByID", (Object)"SIMPInvalidRuntimeIDException");
            }
            throw new SIMPInvalidRuntimeIDException((Throwable)e);
        }
        AbstractItem messageObject = null;
        try {
            messageObject = this.itemStream.findById(messageID);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.LocalQueuePoint.getQueuedMessageByID", (String)"1:391:1.58", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageByID", (Object)((Object)e));
            }
            throw new SIMPRuntimeOperationFailedException((Throwable)e);
        }
        SIMPMessage message = null;
        if (messageObject instanceof SIMPMessage) {
            message = (SIMPMessage)messageObject;
        }
        if (message == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageByID", (Object)"SIMPControllableNotFoundException");
            }
            throw new SIMPControllableNotFoundException(nls.getFormattedMessage("MESSAGE_EXISTS_ERROR_CWSIP0572", new Object[]{ID, this.destinationHandler.getName()}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageByID");
        }
        return (SIMPQueuedMessageControllable)message.getControlAdapter();
    }

    public SIMPIterator getPtoPInboundReceiverIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPtoPInboundReceiverIterator");
        }
        TargetStreamManager tsm = this.inputHandler.getTargetStreamManager();
        SIMPIterator itr = tsm.getTargetStreamSetControlIterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPtoPInboundReceiverIterator", (Object)itr);
        }
        return itr;
    }

    public String getName() {
        return this.messageHandlerName;
    }

    public String getId() {
        try {
            if (this.id == null) {
                this.id = this.destinationHandler.getUuid() + "_QUEUE_" + this.itemStream.getID();
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.LocalQueuePoint.getId", (String)"1:471:1.58", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        return this.id;
    }

    public long getNumberOfQueuedMessages() {
        long count = 0L;
        try {
            count = this.itemStream.getStatistics().getTotalItemCount();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.LocalQueuePoint.getNumberOfQueuedMessages", (String)"1:494:1.58", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        return count;
    }

    @Override
    public synchronized void registerControlAdapterAsMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        if (!this.isRegistered() && !this.getMessageHandler().isTemporary()) {
            super.registerControlAdapterAsMBean();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkValidControllable");
        }
        if (this.itemStream == null || !this.itemStream.isInStore()) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"LocalQueuePoint.assertValidControllable", "1:539:1.58", this.id}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        super.dereferenceControllable();
        this.itemStream = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public String getUuid() {
        LocalizationDefinition def = this.itemStream.getLocalizationDefinition();
        String uuid = null;
        if (def != null) {
            uuid = def.getUuid();
        }
        return uuid;
    }

    @Override
    public String getRemoteEngineUuid() {
        return this.itemStream.getLocalizingMEUuid().toString();
    }

    public String toString() {
        if (this.itemStream != null) {
            return ((SIMPMessageHandlerControllable)this.itemStream.getDestinationHandler().getControlAdapter()).getName();
        }
        return "LocalQueuePoint under construction.....";
    }

    public SIMPIterator getRemoteBrowserReceiverIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteBrowserReceiverIterator");
        }
        AnycastOutputHandler aoh = this.destinationHandler.getAnycastOutputHandler();
        Hashtable tableOfBrowserSessions = aoh.getBrowserSessions();
        Set keySet = tableOfBrowserSessions.keySet();
        ArrayList<AOBrowserSession> listOfBrowserSessions = new ArrayList<AOBrowserSession>();
        for (AOBrowserSessionKey browserSessionKey : keySet) {
            AOBrowserSession aoBrowserSession = (AOBrowserSession)tableOfBrowserSessions.get(browserSessionKey);
            listOfBrowserSessions.add(aoBrowserSession);
        }
        RemoteBrowserIterator remoteBrowserIterator = new RemoteBrowserIterator(listOfBrowserSessions.iterator());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteBrowserReceiverIterator", (Object)remoteBrowserIterator);
        }
        return remoteBrowserIterator;
    }

    public SIMPIterator getAllRemoteConsumerTransmitIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllRemoteConsumerTransmitIterator");
        }
        BasicSIMPIterator itr = new BasicSIMPIterator(this.destinationHandler.getAOControlAdapterIterator());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllRemoteConsumerTransmitIterator", (Object)itr);
        }
        return itr;
    }

    public SIMPIterator getNonGatheringRemoteConsumerTransmitIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNonGatheringRemoteConsumerTransmitIterator");
        }
        Iterator<ControlAdapter> itr = this.destinationHandler.getAOControlAdapterIterator();
        ArrayList<SIMPRemoteConsumerTransmitControllable> nonGathAOstreams = new ArrayList<SIMPRemoteConsumerTransmitControllable>();
        while (itr.hasNext()) {
            SIMPRemoteConsumerTransmitControllable adapter = (SIMPRemoteConsumerTransmitControllable)itr.next();
            if (adapter.isGathering()) continue;
            nonGathAOstreams.add(adapter);
        }
        BasicSIMPIterator nonGathItr = new BasicSIMPIterator(nonGathAOstreams.iterator());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNonGatheringRemoteConsumerTransmitIterator", (Object)nonGathItr);
        }
        return nonGathItr;
    }

    public SIMPIterator getQueuedMessageIterator(int fromIndex, int toIndex, int totalNumberOfMsgsPerPage) throws SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)("getQueuedMessageIterator(int fromIndex= " + fromIndex + ", int toIndex= " + toIndex + ", int totalNumberOfMsgsPerPage= " + totalNumberOfMsgsPerPage));
        }
        ArrayList<ControlAdapter> messages = new ArrayList<ControlAdapter>();
        NonLockingCursor cursor = null;
        try {
            cursor = this.itemStream.newNonLockingItemCursor(null);
            cursor.allowUnavailableItems();
            long totalQueuedMessages = this.getNumberOfQueuedMessages();
            MessageItem item = (MessageItem)cursor.next(fromIndex - 1);
            for (int iCount = fromIndex - 1; item != null && iCount < toIndex; ++iCount) {
                AbstractItem abItem;
                if ((long)iCount > totalQueuedMessages) {
                    break;
                }
                item.forceCurrentMEArrivalTimeToJsMessage();
                ControlAdapter cAdapter = item.getControlAdapter();
                if (cAdapter != null && iCount >= fromIndex - 1 && iCount <= toIndex && messages.size() <= totalNumberOfMsgsPerPage) {
                    messages.add(cAdapter);
                }
                if ((abItem = cursor.next(fromIndex - 1)) == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)(" Item retrieved from messagestore is null at index" + iCount));
                    }
                    break;
                }
                item = (MessageItem)abItem;
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.LocalQueuePoint.getQueuedMessageIterator", (String)"1:263:1.57", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageIterator", (Object)((Object)e));
            }
            throw new SIMPRuntimeOperationFailedException((Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.finished();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)("getQueuedMessageIterator fromIndex=" + fromIndex + " toIndex= " + toIndex + " totalMessagesPerpage= " + totalNumberOfMsgsPerPage));
        }
        return new BasicSIMPIterator(messages.iterator());
    }
}

