/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.eclipse.persistence.internal.helper.Helper;

public class IntegrityException
extends ValidationException {
    protected IntegrityChecker integrityChecker;

    public IntegrityException() {
    }

    public IntegrityException(IntegrityChecker integrityChecker) {
        this.integrityChecker = integrityChecker;
    }

    public IntegrityChecker getIntegrityChecker() {
        return this.integrityChecker;
    }

    @Override
    public String getMessage() {
        Exception e;
        String cr = Helper.cr();
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println(cr + ExceptionMessageGenerator.getHeader("DescriptorExceptionsHeader"));
        writer.println("---------------------------------------------------------");
        Enumeration<Exception> enumtr = this.getIntegrityChecker().getCaughtExceptions().elements();
        while (enumtr.hasMoreElements()) {
            e = enumtr.nextElement();
            if (!(e instanceof DescriptorException)) continue;
            writer.println(cr + e);
        }
        if (this.getIntegrityChecker().hasRuntimeExceptions()) {
            writer.println(cr + ExceptionMessageGenerator.getHeader("RuntimeExceptionsHeader"));
            writer.println("---------------------------------------------------------");
            enumtr = this.getIntegrityChecker().getCaughtExceptions().elements();
            while (enumtr.hasMoreElements()) {
                e = enumtr.nextElement();
                if (e instanceof DescriptorException) continue;
                writer.println(cr + e);
            }
        }
        writer.flush();
        swriter.flush();
        return swriter.toString();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream outStream) {
        this.printStackTrace(new PrintWriter(outStream));
    }

    @Override
    public void printStackTrace(PrintWriter writer) {
        Exception e;
        super.printStackTrace(writer);
        String cr = Helper.cr();
        writer.println(cr + ExceptionMessageGenerator.getHeader("DescriptorExceptionsHeader"));
        writer.println("---------------------------------------------------------");
        Enumeration<Exception> enumtr = this.getIntegrityChecker().getCaughtExceptions().elements();
        while (enumtr.hasMoreElements()) {
            e = enumtr.nextElement();
            if (!(e instanceof DescriptorException)) continue;
            writer.println(cr);
            e.printStackTrace(writer);
        }
        if (this.getIntegrityChecker().hasRuntimeExceptions()) {
            writer.println(cr + ExceptionMessageGenerator.getHeader("RuntimeExceptionsHeader"));
            writer.println("---------------------------------------------------------");
            enumtr = this.getIntegrityChecker().getCaughtExceptions().elements();
            while (enumtr.hasMoreElements()) {
                e = enumtr.nextElement();
                if (e instanceof DescriptorException) continue;
                writer.println(cr);
                e.printStackTrace(writer);
            }
        }
        writer.flush();
    }
}

