/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util.concurrent;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.apache.yoko.util.concurrent.NNode;
import org.apache.yoko.util.concurrent.PNode;
import org.apache.yoko.util.concurrent.VNode;

final class WeakNode<T>
extends WeakReference<T>
implements VNode<T> {
    final Runnable cleanup;
    private PNode<T> prev;
    private NNode<T> next;

    WeakNode(T value, ReferenceQueue<T> q, Runnable cleanup) {
        super(value, q);
        this.cleanup = cleanup;
    }

    @Override
    public PNode<T> prev() {
        return this.prev;
    }

    @Override
    public NNode<T> next() {
        return this.next;
    }

    @Override
    public void prev(PNode<T> pnode) {
        this.prev = pnode;
    }

    @Override
    public void next(NNode<T> nnode) {
        this.next = nnode;
    }

    @Override
    public void insertAfter(PNode<T> pnode) {
        NNode<T> nnode = pnode.next();
        this.next = nnode;
        this.prev = pnode;
        nnode.prev(this);
        pnode.next(this);
    }

    @Override
    public void delete() {
        this.prev.next(this.next);
        this.next.prev(this.prev);
        this.prev = null;
        this.next = null;
    }
}

