/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsByteBufferPool;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.ConversationStateFullException;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.DestinationSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;

public class StaticCATBrowser {
    private static String CLASS_NAME = StaticCATBrowser.class.getName();
    private static final TraceComponent tc = SibTr.register(StaticCATBrowser.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static CommsByteBufferPool poolManager = CommsByteBufferPool.getInstance();

    public static void rcvCreateBrowserSess(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        block21: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rcvCreateBrowserSess", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
            }
            ConversationState convState = (ConversationState)conversation.getAttachment();
            short connectionObjectID = request.getShort();
            short clientSessionId = request.getShort();
            int requestedBytes = request.getInt();
            short destinationTypeShort = request.getShort();
            boolean allowMessageGathering = false;
            HandshakeProperties handshakeProps = conversation.getHandshakeProperties();
            if (handshakeProps.getFapLevel() >= 9) {
                short browserFlags = request.getShort();
                if (browserFlags > 1) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Browser flags (" + browserFlags + ") > " + 1));
                    }
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INVALID_PROP_SICO8017", new Object[]{"" + browserFlags}, null));
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateBrowserSess"), (String)"3-015-0008");
                    throw e;
                }
                allowMessageGathering = (browserFlags & 1) != 0;
            }
            SIDestinationAddress destAddr = request.getSIDestinationAddress(conversation.getHandshakeProperties().getFapLevel());
            SelectionCriteria criteria = request.getSelectionCriteria();
            String alternateUser = request.getString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("\nrcvCreateBrowserSess> connectionObjectID    = " + connectionObjectID + "\nrcvCreateBrowserSess> clientSessionId       = " + clientSessionId + "\nrcvCreateBrowserSess> requestedBytes        = " + requestedBytes + "\nrcvCreateBrowserSess> destinationTypeShort  = " + destinationTypeShort + "\nrcvCreateBrowserSess> allowMessageGathering = " + allowMessageGathering + "\nrcvCreateBrowserSess> criteria              = " + criteria + "\nrcvCreateBrowserSess> alternateUser         = " + alternateUser));
            }
            request.release(allocatedFromBufferPool);
            DestinationType destinationType = null;
            if (destinationTypeShort != -1) {
                destinationType = DestinationType.getDestinationType((int)destinationTypeShort);
            }
            SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectID)).getSICoreConnection();
            BrowserSession browserSession = null;
            try {
                browserSession = connection.createBrowserSession(destAddr, destinationType, criteria, alternateUser, allowMessageGathering);
            }
            catch (SINotAuthorizedException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
            }
            catch (SIException e) {
                if (!convState.hasMETerminated()) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateBrowserSess"), (String)"3-015-0001");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                StaticCATHelper.sendExceptionToClient(e, "3-015-0001", conversation, requestNumber);
            }
            if (browserSession != null) {
                CATMainConsumer mainConsumer = new CATMainConsumer(conversation, clientSessionId, browserSession);
                try {
                    short sessionId = (short)convState.addObject(mainConsumer);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("browser session id = " + sessionId));
                    }
                    mainConsumer.requestMsgs(requestNumber, 0, requestedBytes);
                    StaticCATHelper.sendSessionCreateResponse(223, requestNumber, conversation, sessionId, (DestinationSession)browserSession, destAddr);
                }
                catch (ConversationStateFullException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateBrowserSess"), (String)"3-015-0002");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
                    }
                    StaticCATHelper.sendExceptionToClient(e, "3-015-0003", conversation, requestNumber);
                    try {
                        browserSession.close();
                    }
                    catch (SIException coreException) {
                        if (!convState.hasMETerminated()) {
                            FFDCFilter.processException((Throwable)coreException, (String)(CLASS_NAME + ".rcvCreateBrowserSess"), (String)"3-015-0003");
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block21;
                        SibTr.debug((TraceComponent)tc, (String)coreException.getMessage(), (Object)((Object)coreException));
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCreateBrowserSess");
        }
    }

    public static void rcvResetBrowse(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvResetBrowse", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        short connectionObjectId = request.getShort();
        short browserSessionId = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("rcvResetBrowse> connectionObjectId = " + connectionObjectId + "\nrcvResetBrowse> browserSessionId   = " + browserSessionId));
        }
        BrowserSession browserSession = null;
        ConversationState convState = null;
        try {
            convState = (ConversationState)conversation.getAttachment();
            CATMainConsumer mainConsumer = (CATMainConsumer)convState.getObject(browserSessionId);
            browserSession = mainConsumer.getBrowserSession();
            if (browserSession == null) {
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("BROWSER_SESSION_NULL_SICO20", null, null));
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvResetBrowse"), (String)"3-015-0007");
                throw e;
            }
        }
        catch (NullPointerException npe) {
            FFDCFilter.processException((Throwable)npe, (String)(CLASS_NAME + ".rcvResetBrowse"), (String)"3-015-0004");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Browser session was null!", (Object)npe);
            }
            StaticCATHelper.sendExceptionToClient(npe, "3-015-0004", conversation, requestNumber);
        }
        if (browserSession != null) {
            try {
                browserSession.reset();
            }
            catch (SIException e) {
                if (!convState.hasMETerminated()) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvResetBrowse"), (String)"3-015-0005");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                StaticCATHelper.sendExceptionToClient(e, "3-015-0005", conversation, requestNumber);
            }
        }
        CommsByteBuffer reply = poolManager.allocate();
        try {
            conversation.send((JFapByteBuffer)reply, 224, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvResetBrowse"), (String)"3-015-0006");
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2020", (Object)((Object)e));
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvResetBrowse");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATBrowser.java, SIB.comms, WASX.SIB, aa1225.01 1.50");
        }
    }
}

