/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.security.internal.Invocation;
import com.ibm.ws.jca.security.internal.J2CSecurityHelper;
import java.io.IOException;
import java.util.Hashtable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;

public class J2CSecurityCallbackHandler
implements CallbackHandler {
    static final TraceComponent tc = Tr.register(J2CSecurityCallbackHandler.class, (String)"WAS.j2c.security", (String)"com.ibm.ws.jca.security.resources.J2CAMessages");
    private Invocation[] _invocations;
    private Subject _executionSubject;
    private Hashtable<String, Object> _addedCred;
    private String _realmName;
    private String _unauthenticated;

    private J2CSecurityCallbackHandler() {
    }

    public J2CSecurityCallbackHandler(Subject executionSubject, String realm, String unauthenticated) {
        this._executionSubject = executionSubject;
        this._addedCred = new Hashtable();
        this._invocations = new Invocation[]{null, null, null};
        this._realmName = realm;
        this._unauthenticated = unauthenticated;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handle", (Object[])new Object[0]);
        }
        if (callbacks == null || callbacks.length == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handle", (Object)"No Callbacks received, do nothing.");
            }
            return;
        }
        this.arrangeCallbacks(callbacks);
        try {
            for (Callback callback : callbacks) {
                if (callback instanceof CallerPrincipalCallback) {
                    J2CSecurityHelper.handleCallerPrincipalCallback((CallerPrincipalCallback)callback, this._executionSubject, this._addedCred, this._realmName, this._unauthenticated, this._invocations);
                    continue;
                }
                if (callback instanceof GroupPrincipalCallback) {
                    J2CSecurityHelper.handleGroupPrincipalCallback((GroupPrincipalCallback)callback, this._executionSubject, this._addedCred, this._realmName, this._invocations);
                    continue;
                }
                if (callback instanceof PasswordValidationCallback) {
                    J2CSecurityHelper.handlePasswordValidationCallback((PasswordValidationCallback)callback, this._executionSubject, this._addedCred, this._realmName, this._invocations);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
            J2CSecurityHelper.addSubjectCustomData(this._executionSubject, this._addedCred);
        }
        catch (Exception ex) {
            Tr.error((TraceComponent)tc, (String)"ERROR_HANDLING_CALLBACK_J2CA0672", (Object[])new Object[]{ex.getClass().getName(), ex.getMessage()});
            FFDCFilter.processException((Throwable)ex, (String)(this.getClass().getName() + ".handle"), (String)"153");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The exception is " + ex), (Object[])new Object[0]);
            }
            if (ex instanceof IOException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"handle");
                }
                throw (IOException)ex;
            }
            if (ex instanceof UnsupportedCallbackException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"handle");
                }
                throw (UnsupportedCallbackException)ex;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handle");
            }
            throw new IOException(ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handle");
        }
    }

    public Invocation[] getInvocations() {
        Invocation[] invocations = new Invocation[]{null, null, null};
        for (int i = 0; i < this._invocations.length; ++i) {
            invocations[i] = this._invocations[i];
        }
        return invocations;
    }

    protected String getCacheKey() {
        return (String)this._addedCred.get("com.ibm.wsspi.security.cred.cacheKey");
    }

    private void arrangeCallbacks(Callback[] callbacks) {
        if (callbacks[0] instanceof CallerPrincipalCallback) {
            return;
        }
        int length = callbacks.length;
        for (int i = 0; i < length; ++i) {
            if (!(callbacks[i] instanceof CallerPrincipalCallback)) continue;
            Callback callback = callbacks[0];
            callbacks[0] = callbacks[i];
            callbacks[i] = callback;
            break;
        }
    }
}

