/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.NullAttributeException;
import org.apache.taglibs.standard.tag.common.core.ParamParent;
import org.apache.taglibs.standard.tag.common.core.ParamSupport;
import org.apache.taglibs.standard.tag.common.core.Util;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ImportSupport
extends BodyTagSupport
implements TryCatchFinally,
ParamParent {
    public static final String VALID_SCHEME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+.-";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    protected String url;
    protected String context;
    protected String charEncoding;
    private String var;
    private int scope;
    private String varReader;
    private Reader r;
    private boolean isAbsoluteUrl;
    private ParamSupport.ParamManager params;
    private String urlWithParams;
    static final long serialVersionUID = -311455807227120141L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ImportSupport() {
        this.init();
    }

    private void init() {
        this.urlWithParams = null;
        this.charEncoding = null;
        this.context = null;
        this.varReader = null;
        this.var = null;
        this.url = null;
        this.params = null;
        this.scope = 1;
    }

    /*
     * WARNING - void declaration
     */
    public int doStartTag() throws JspException {
        if (!(this.context == null || this.context.startsWith("/") && this.url.startsWith("/"))) {
            throw new JspTagException(Resources.getMessage("IMPORT_BAD_RELATIVE"));
        }
        this.urlWithParams = null;
        this.params = new ParamSupport.ParamManager();
        if (this.url == null || this.url.equals("")) {
            throw new NullAttributeException("import", "url");
        }
        this.isAbsoluteUrl = this.isAbsoluteUrl();
        try {
            if (this.varReader != null) {
                this.r = this.acquireReader();
                this.pageContext.setAttribute(this.varReader, (Object)this.r);
            }
        }
        catch (IOException iOException) {
            void ex;
            FFDCFilter.processException((Throwable)iOException, (String)"org.apache.taglibs.standard.tag.common.core.ImportSupport", (String)"148", (Object)this, (Object[])new Object[0]);
            throw new JspTagException(ex.toString(), (Throwable)ex);
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public int doEndTag() throws JspException {
        try {
            if (this.varReader == null) {
                if (this.var != null) {
                    this.pageContext.setAttribute(this.var, (Object)this.acquireString(), this.scope);
                } else {
                    this.pageContext.getOut().print(this.acquireString());
                }
            }
            return 6;
        }
        catch (IOException iOException) {
            void ex;
            FFDCFilter.processException((Throwable)iOException, (String)"org.apache.taglibs.standard.tag.common.core.ImportSupport", (String)"168", (Object)this, (Object[])new Object[0]);
            throw new JspTagException(ex.toString(), (Throwable)ex);
        }
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        try {
            if (this.varReader != null) {
                if (this.r != null) {
                    this.r.close();
                }
                this.pageContext.removeAttribute(this.varReader, 1);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"org.apache.taglibs.standard.tag.common.core.ImportSupport", (String)"188", (Object)this, (Object[])new Object[0]);
        }
    }

    public void release() {
        this.init();
        super.release();
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setVarReader(String varReader) {
        this.varReader = varReader;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
    }

    @Override
    public void addParameter(String name, String value) {
        this.params.addParameter(name, value);
    }

    /*
     * WARNING - void declaration
     */
    private String acquireString() throws IOException, JspException {
        if (this.isAbsoluteUrl) {
            StringBuffer sb = new StringBuffer();
            try (BufferedReader r = new BufferedReader(this.acquireReader());){
                int i;
                while ((i = r.read()) != -1) {
                    sb.append((char)i);
                }
            }
            return sb.toString();
        }
        if (!(this.pageContext.getRequest() instanceof HttpServletRequest) || !(this.pageContext.getResponse() instanceof HttpServletResponse)) {
            throw new JspTagException(Resources.getMessage("IMPORT_REL_WITHOUT_HTTP"));
        }
        ServletContext c = null;
        String targetUrl = this.targetUrl();
        if (this.context != null) {
            c = this.pageContext.getServletContext().getContext(this.context);
        } else {
            c = this.pageContext.getServletContext();
            if (!targetUrl.startsWith("/")) {
                String sp = ((HttpServletRequest)this.pageContext.getRequest()).getServletPath();
                targetUrl = sp.substring(0, sp.lastIndexOf(47)) + '/' + targetUrl;
            }
        }
        if (c == null) {
            throw new JspTagException(Resources.getMessage("IMPORT_REL_WITHOUT_DISPATCHER", this.context, targetUrl));
        }
        RequestDispatcher rd = c.getRequestDispatcher(ImportSupport.stripSession(targetUrl));
        if (rd == null) {
            throw new JspTagException(ImportSupport.stripSession(targetUrl));
        }
        ImportResponseWrapper irw = new ImportResponseWrapper(this.pageContext);
        try {
            rd.include(this.pageContext.getRequest(), (ServletResponse)irw);
        }
        catch (IOException iOException) {
            void ex;
            FFDCFilter.processException((Throwable)iOException, (String)"org.apache.taglibs.standard.tag.common.core.ImportSupport", (String)"309", (Object)this, (Object[])new Object[0]);
            throw new JspException((Throwable)ex);
        }
        catch (RuntimeException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"org.apache.taglibs.standard.tag.common.core.ImportSupport", (String)"311", (Object)this, (Object[])new Object[0]);
            throw new JspException((Throwable)ex);
        }
        catch (ServletException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"org.apache.taglibs.standard.tag.common.core.ImportSupport", (String)"313", (Object)this, (Object[])new Object[0]);
            Throwable rc = ex.getRootCause();
            if (rc == null) {
                throw new JspException((Throwable)ex);
            }
            throw new JspException(rc);
        }
        if (irw.getStatus() < 200 || irw.getStatus() > 299) {
            throw new JspTagException(irw.getStatus() + " " + ImportSupport.stripSession(targetUrl));
        }
        return irw.getString();
    }

    /*
     * WARNING - void declaration
     */
    private Reader acquireReader() throws IOException, JspException {
        if (!this.isAbsoluteUrl) {
            return new StringReader(this.acquireString());
        }
        String target = this.targetUrl();
        try {
            int status;
            String charSet;
            URL u = new URL(target);
            URLConnection uc = u.openConnection();
            InputStream i = uc.getInputStream();
            InputStreamReader r = null;
            if (this.charEncoding != null && !this.charEncoding.equals("")) {
                charSet = this.charEncoding;
            } else {
                String contentType = uc.getContentType();
                if (contentType != null) {
                    charSet = Util.getContentTypeAttribute(contentType, "charset");
                    if (charSet == null) {
                        charSet = DEFAULT_ENCODING;
                    }
                } else {
                    charSet = DEFAULT_ENCODING;
                }
            }
            try {
                r = new InputStreamReader(i, charSet);
            }
            catch (Exception contentType) {
                FFDCFilter.processException((Throwable)contentType, (String)"org.apache.taglibs.standard.tag.common.core.ImportSupport", (String)"362", (Object)this, (Object[])new Object[0]);
                r = new InputStreamReader(i, DEFAULT_ENCODING);
            }
            if (uc instanceof HttpURLConnection && ((status = ((HttpURLConnection)uc).getResponseCode()) < 200 || status > 299)) {
                throw new JspTagException(status + " " + target);
            }
            return r;
        }
        catch (IOException u) {
            void ex;
            FFDCFilter.processException((Throwable)u, (String)"org.apache.taglibs.standard.tag.common.core.ImportSupport", (String)"374", (Object)this, (Object[])new Object[0]);
            throw new JspException(Resources.getMessage("IMPORT_ABS_ERROR", target, ex), (Throwable)ex);
        }
        catch (RuntimeException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"org.apache.taglibs.standard.tag.common.core.ImportSupport", (String)"377", (Object)this, (Object[])new Object[0]);
            throw new JspException(Resources.getMessage("IMPORT_ABS_ERROR", target, ex), (Throwable)ex);
        }
    }

    private String targetUrl() {
        if (this.urlWithParams == null) {
            this.urlWithParams = this.params.aggregateParams(this.url);
        }
        return this.urlWithParams;
    }

    private boolean isAbsoluteUrl() throws JspTagException {
        return ImportSupport.isAbsoluteUrl(this.url);
    }

    public static boolean isAbsoluteUrl(String url) {
        if (url == null) {
            return false;
        }
        int colonPos = url.indexOf(":");
        if (colonPos == -1) {
            return false;
        }
        for (int i = 0; i < colonPos; ++i) {
            if (VALID_SCHEME_CHARS.indexOf(url.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static String stripSession(String url) {
        int sessionStart;
        StringBuffer u = new StringBuffer(url);
        while ((sessionStart = u.toString().indexOf(";jsessionid=")) != -1) {
            int sessionEnd = u.toString().indexOf(";", sessionStart + 1);
            if (sessionEnd == -1) {
                sessionEnd = u.toString().indexOf("?", sessionStart + 1);
            }
            if (sessionEnd == -1) {
                sessionEnd = u.length();
            }
            u.delete(sessionStart, sessionEnd);
        }
        return u.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.taglibs.standard.tag.common.core.ImportSupport", ImportSupport.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ImportResponseWrapper
    extends HttpServletResponseWrapper {
        private StringWriter sw;
        private ByteArrayOutputStream bos;
        private ServletOutputStream sos;
        private boolean isWriterUsed;
        private boolean isStreamUsed;
        private int status;
        private PageContext pageContext;
        static final long serialVersionUID = -4263072488229215251L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ImportResponseWrapper(PageContext pageContext) {
            super((HttpServletResponse)pageContext.getResponse());
            this.sw = new StringWriter();
            this.bos = new ByteArrayOutputStream();
            this.sos = new ServletOutputStream(){
                static final long serialVersionUID = -7491081426186876190L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public boolean isReady() {
                    return false;
                }

                public void setWriteListener(WriteListener writeListener) {
                }

                public void write(int b) throws IOException {
                    ImportResponseWrapper.this.bos.write(b);
                }

                public void flush() throws IOException {
                    ImportResponseWrapper.this.pageContext.getOut().write(ImportResponseWrapper.this.getString());
                    ImportResponseWrapper.this.bos.reset();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.taglibs.standard.tag.common.core.ImportSupport$ImportResponseWrapper$1", 1.class, null, null);
                }
            };
            this.status = 200;
            this.pageContext = pageContext;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.isStreamUsed) {
                throw new IllegalStateException(Resources.getMessage("IMPORT_ILLEGAL_STREAM"));
            }
            this.isWriterUsed = true;
            return new PrintWriter(this.sw);
        }

        public ServletOutputStream getOutputStream() {
            if (this.isWriterUsed) {
                throw new IllegalStateException(Resources.getMessage("IMPORT_ILLEGAL_WRITER"));
            }
            this.isStreamUsed = true;
            return this.sos;
        }

        public void setContentType(String x) {
        }

        public void setLocale(Locale x) {
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public String getString() throws UnsupportedEncodingException {
            if (this.isWriterUsed) {
                return this.sw.toString();
            }
            if (this.isStreamUsed) {
                if (ImportSupport.this.charEncoding != null && !ImportSupport.this.charEncoding.equals("")) {
                    return this.bos.toString(ImportSupport.this.charEncoding);
                }
                return this.bos.toString(ImportSupport.DEFAULT_ENCODING);
            }
            return "";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.taglibs.standard.tag.common.core.ImportSupport$ImportResponseWrapper", ImportResponseWrapper.class, null, null);
        }
    }
}

