/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.ParallelTaskResult;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JSEResultAdapter
implements ParallelTaskResult {
    private static final String sourceClass = JSEResultAdapter.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private Future result;
    static final long serialVersionUID = 4925246771225592163L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JSEResultAdapter(Future result) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JSEResultAdapter", "<init>", new Object[]{result});
        }
        this.result = result;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JSEResultAdapter", "<init>", this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void waitForResult() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JSEResultAdapter", "waitForResult", new Object[0]);
        }
        try {
            this.result.get();
        }
        catch (InterruptedException interruptedException) {
            void e;
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.jbatch.container.services.impl.JSEResultAdapter", (String)"46", (Object)this, (Object[])new Object[0]);
            throw new BatchContainerServiceException("Parallel thread was interrupted while waiting for result.", (Throwable)e);
        }
        catch (ExecutionException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.services.impl.JSEResultAdapter", (String)"48", (Object)this, (Object[])new Object[0]);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(sourceClass + ": caught exception/error: " + e.getMessage() + " : Stack trace: " + e.getCause().toString());
            }
        }
        catch (CancellationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.services.impl.JSEResultAdapter", (String)"55", (Object)this, (Object[])new Object[0]);
            throw new BatchContainerServiceException("Parallel thread was canceled before completion.", e);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JSEResultAdapter", "waitForResult");
        }
    }
}

