/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.http;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.oidcclientcore.storage.Storage;
import io.openliberty.security.oidcclientcore.storage.StorageFactory;
import io.openliberty.security.oidcclientcore.utils.Utils;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OriginalResourceRequest
extends HttpServletRequestWrapper {
    private String requestUrl = "";
    private String queryStringParams = null;
    private String method = "";
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private Map<String, String[]> params = new HashMap<String, String[]>();
    private final Storage storage;
    static final long serialVersionUID = 1458154581875780119L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OriginalResourceRequest(HttpServletRequest request, HttpServletResponse response, boolean useSession) {
        super(request);
        this.storage = StorageFactory.instantiateStorage(request, response, useSession);
        this.restoreOriginalRequest(request.getParameter("state"));
    }

    public static void storeFullRequest(HttpServletRequest request, Storage storage, String state) {
        Base64.Encoder encoder = Base64.getEncoder();
        String stateHash = Utils.getStrHashCode(state);
        OriginalResourceRequest.storeRequestCookies(request, storage, encoder, stateHash);
        OriginalResourceRequest.storeRequestMethod(request, storage, encoder, stateHash);
        OriginalResourceRequest.storeRequestHeaders(request, storage, encoder, stateHash);
        OriginalResourceRequest.storeRequestParameters(request, storage, encoder, stateHash);
    }

    private static void storeRequestCookies(HttpServletRequest request, Storage storage, Base64.Encoder encoder, String stateHash) {
    }

    private static void storeRequestMethod(HttpServletRequest request, Storage storage, Base64.Encoder encoder, String stateHash) {
        String method = request.getMethod();
        String encodedMethod = encoder.encodeToString(method.getBytes());
        storage.store("WASOidcReqMethod" + stateHash, encodedMethod);
    }

    private static void storeRequestHeaders(HttpServletRequest request, Storage storage, Base64.Encoder encoder, String stateHash) {
        StringJoiner headerJoiner = new StringJoiner("&");
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String encodedHeaderName = encoder.encodeToString(headerName.getBytes());
            StringJoiner valueJoiner = new StringJoiner(".");
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                String encodedHeaderValue = encoder.encodeToString(headerValue.getBytes());
                valueJoiner.add(encodedHeaderValue);
            }
            String encodedHeaderValues = valueJoiner.toString();
            headerJoiner.add(encodedHeaderName + ":" + encodedHeaderValues);
        }
        String encodedHeaders = headerJoiner.toString();
        storage.store("WASOidcReqHeaders" + stateHash, encodedHeaders);
    }

    private static void storeRequestParameters(HttpServletRequest request, Storage storage, Base64.Encoder encoder, String stateHash) {
        StringJoiner paramJoiner = new StringJoiner("&");
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String[] paramValues;
            String paramName = (String)paramNames.nextElement();
            String encodedParamName = encoder.encodeToString(paramName.getBytes());
            StringJoiner valueJoiner = new StringJoiner(".");
            for (String paramValue : paramValues = request.getParameterValues(paramName)) {
                String encodedParamValue = encoder.encodeToString(paramValue.getBytes());
                valueJoiner.add(encodedParamValue);
            }
            String encodedParamValues = valueJoiner.toString();
            paramJoiner.add(encodedParamName + ":" + encodedParamValues);
        }
        String encodedParams = paramJoiner.toString();
        storage.store("WASOidcReqParams" + stateHash, encodedParams);
    }

    private void restoreOriginalRequest(String state) {
        Base64.Decoder decoder = Base64.getDecoder();
        String stateHash = Utils.getStrHashCode(state);
        this.restoreReqUrlAndQueryParams(stateHash);
        this.restoreCookies(decoder, stateHash);
        this.restoreMethod(decoder, stateHash);
        this.restoreHeaders(decoder, stateHash);
        this.restoreParams(decoder, stateHash);
    }

    private void restoreReqUrlAndQueryParams(String stateHash) {
        String key = "WASReqURLOidc" + stateHash;
        String requestUrlWithQueryParams = this.storage.get(key);
        if (requestUrlWithQueryParams == null || requestUrlWithQueryParams.isEmpty()) {
            return;
        }
        String[] requestUrlSplitFromQueryParams = requestUrlWithQueryParams.split(Pattern.quote("?"));
        this.requestUrl = requestUrlSplitFromQueryParams[0];
        if (requestUrlSplitFromQueryParams.length > 1) {
            this.queryStringParams = requestUrlSplitFromQueryParams[1];
        }
    }

    private void restoreCookies(Base64.Decoder decoder, String stateHash) {
    }

    private void restoreMethod(Base64.Decoder decoder, String stateHash) {
        String key = "WASOidcReqMethod" + stateHash;
        String encodedMethod = this.getAndRemoveFromStorage(key);
        if (encodedMethod == null || encodedMethod.isEmpty()) {
            return;
        }
        this.method = new String(decoder.decode(encodedMethod));
    }

    private void restoreHeaders(Base64.Decoder decoder, String stateHash) {
        String[] encodedHeaders;
        String key = "WASOidcReqHeaders" + stateHash;
        String storedHeadersString = this.getAndRemoveFromStorage(key);
        if (storedHeadersString == null || storedHeadersString.isEmpty()) {
            return;
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        for (String encodedHeader : encodedHeaders = storedHeadersString.split("&")) {
            String[] splitEncodedHeader = encodedHeader.split(":");
            String headerName = new String(decoder.decode(splitEncodedHeader[0]));
            String[] encodedHeaderValues = splitEncodedHeader[1].split(Pattern.quote("."));
            ArrayList<String> headerValues = new ArrayList<String>();
            for (String encodedHeaderValue : encodedHeaderValues) {
                String headerValue = new String(decoder.decode(encodedHeaderValue));
                headerValues.add(headerValue);
            }
            headers.put(headerName, headerValues);
        }
        this.headers = headers;
    }

    private void restoreParams(Base64.Decoder decoder, String stateHash) {
        String[] encodedParams;
        String key = "WASOidcReqParams" + stateHash;
        String storedParamsString = this.getAndRemoveFromStorage(key);
        if (storedParamsString == null || storedParamsString.isEmpty()) {
            return;
        }
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        for (String encodedParam : encodedParams = storedParamsString.split("&")) {
            String[] splitEncodedParam = encodedParam.split(":");
            String paramName = new String(decoder.decode(splitEncodedParam[0]));
            String[] encodedParamValues = splitEncodedParam[1].split(Pattern.quote("."));
            String[] paramValues = new String[encodedParamValues.length];
            for (int i = 0; i < encodedParamValues.length; ++i) {
                String paramValue;
                String encodedParamValue = encodedParamValues[i];
                paramValues[i] = paramValue = new String(decoder.decode(encodedParamValue));
            }
            params.put(paramName, paramValues);
        }
        this.params = params;
    }

    @Trivial
    private String getAndRemoveFromStorage(String key) {
        String value = this.storage.get(key);
        if (value != null) {
            this.storage.remove(key);
        }
        return value;
    }

    public String getQueryString() {
        return this.queryStringParams;
    }

    public String getMethod() {
        return this.method;
    }

    @Sensitive
    public String getHeader(String name) {
        List<String> headerValues = this.headers.get(name);
        if (headerValues == null || headerValues.size() == 0) {
            return null;
        }
        return headerValues.get(0);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    @Sensitive
    public Enumeration<String> getHeaders(String name) {
        List<String> headerValues = this.headers.get(name);
        if (headerValues == null) {
            headerValues = Collections.emptyList();
        }
        return Collections.enumeration(headerValues);
    }

    @Sensitive
    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(header);
    }

    @Sensitive
    public String getParameter(String name) {
        String[] paramValues = this.params.get(name);
        if (paramValues == null || paramValues.length == 0) {
            return null;
        }
        return paramValues[0];
    }

    @Sensitive
    public Map<String, String[]> getParameterMap() {
        return new HashMap<String, String[]>(this.params);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.params.keySet());
    }

    @Sensitive
    public String[] getParameterValues(String name) {
        return this.params.get(name);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.security.oidcclientcore.http.OriginalResourceRequest", OriginalResourceRequest.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    }
}

