/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.impl.JWKSet;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import io.openliberty.security.oidcclientcore.authentication.AbstractFlow;
import io.openliberty.security.oidcclientcore.authentication.Flow;
import io.openliberty.security.oidcclientcore.client.LogoutConfig;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.exceptions.AuthenticationResponseException;
import io.openliberty.security.oidcclientcore.exceptions.TokenRequestException;
import io.openliberty.security.oidcclientcore.exceptions.UnsupportedResponseTypeException;
import io.openliberty.security.oidcclientcore.logout.LogoutHandler;
import io.openliberty.security.oidcclientcore.token.TokenRefresher;
import io.openliberty.security.oidcclientcore.token.TokenResponse;
import io.openliberty.security.oidcclientcore.token.TokenResponseValidator;
import io.openliberty.security.oidcclientcore.token.TokenValidationException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jose4j.jwt.JwtClaims;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Client {
    public static final TraceComponent tc = Tr.register(Client.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    private final OidcClientConfig oidcClientConfig;
    private final LogoutConfig logoutConfig;
    private static JWKSet jwkSet = null;
    static final long serialVersionUID = -5834310680142262430L;

    public Client(OidcClientConfig oidcClientConfig) {
        this.oidcClientConfig = oidcClientConfig;
        this.logoutConfig = oidcClientConfig.getLogoutConfig();
    }

    public OidcClientConfig getOidcClientConfig() {
        return this.oidcClientConfig;
    }

    public ProviderAuthenticationResult startFlow(HttpServletRequest request, HttpServletResponse response) throws UnsupportedResponseTypeException {
        Flow flow = AbstractFlow.getInstance(this.oidcClientConfig);
        return flow.startFlow(request, response);
    }

    public ProviderAuthenticationResult continueFlow(HttpServletRequest request, HttpServletResponse response) throws UnsupportedResponseTypeException, AuthenticationResponseException, TokenRequestException {
        Flow flow = AbstractFlow.getInstance(this.oidcClientConfig);
        return flow.continueFlow(request, response);
    }

    public JwtClaims validate(TokenResponse tokenResponse, HttpServletRequest request, HttpServletResponse response) throws TokenValidationException {
        TokenResponseValidator tokenResponseValidator = new TokenResponseValidator(this.oidcClientConfig, request, response);
        return tokenResponseValidator.validate(tokenResponse);
    }

    public static JWKSet getJwkSet() {
        if (jwkSet == null) {
            jwkSet = new JWKSet();
        }
        return jwkSet;
    }

    public ProviderAuthenticationResult checkForExpiredTokensAndProcessIfNeeded(HttpServletRequest request, HttpServletResponse response, boolean isAccessTokenExpired, boolean isIdTokenExpired, String idTokenString, String refreshTokenString) {
        TokenRefresher tokenRefresher = new TokenRefresher(request, this.oidcClientConfig, isAccessTokenExpired, isIdTokenExpired, refreshTokenString);
        if (tokenRefresher.isTokenExpired()) {
            if (this.oidcClientConfig.isTokenAutoRefresh()) {
                if (refreshTokenString == null) {
                    return this.logout(request, response, idTokenString);
                }
                ProviderAuthenticationResult providerAuthResult = tokenRefresher.refreshToken();
                if (AuthResult.SUCCESS.equals((Object)providerAuthResult.getStatus())) {
                    return providerAuthResult;
                }
                return this.logout(request, response, idTokenString);
            }
            if (this.logoutConfig.isAccessTokenExpiry() && tokenRefresher.isAccessTokenExpired() || this.logoutConfig.isIdentityTokenExpiry() && tokenRefresher.isIdTokenExpired()) {
                return this.logout(request, response, idTokenString);
            }
        }
        return new ProviderAuthenticationResult(AuthResult.CONTINUE, 200);
    }

    /*
     * WARNING - void declaration
     */
    public ProviderAuthenticationResult logout(HttpServletRequest request, HttpServletResponse response, String idTokenString) {
        LogoutHandler logoutHandler = new LogoutHandler(request, response, this.oidcClientConfig, this.logoutConfig, idTokenString);
        try {
            return logoutHandler.logout();
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, (String)"io.openliberty.security.oidcclientcore.client.Client", (String)"112", (Object)this, (Object[])new Object[]{request, response, idTokenString});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Logout failed with a ServletException exception on " + idTokenString), (Object[])new Object[]{e});
            }
            return new ProviderAuthenticationResult(AuthResult.FAILURE, 500);
        }
    }
}

