/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaConnectorConstants;
import com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaConnectorException;
import com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaOutput;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterException;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterFactory;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaProducer;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.eclipse.microprofile.reactive.messaging.spi.OutgoingConnectorFactory;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;

@Connector(value="liberty-kafka")
@ApplicationScoped
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class KafkaOutgoingConnector
implements OutgoingConnectorFactory {
    private static final TraceComponent tc = Tr.register(KafkaOutgoingConnector.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
    @Inject
    private KafkaAdapterFactory kafkaAdapterFactory;
    private final List<KafkaOutput<?, ?>> kafkaOutputs = Collections.synchronizedList(new ArrayList());
    static final long serialVersionUID = 369199060001387231L;

    /*
     * WARNING - void declaration
     */
    public SubscriberBuilder<Message<Object>, Void> getSubscriberBuilder(Config config) {
        String channelName = (String)config.getValue("channel-name", String.class);
        try {
            int retrySeconds = config.getOptionalValue("creation.retry.seconds", Integer.class).orElse(0);
            HashMap<String, Object> producerConfig = new HashMap<String, Object>();
            producerConfig.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            producerConfig.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            producerConfig.putAll(StreamSupport.stream(config.getPropertyNames().spliterator(), false).filter(k -> !KafkaConnectorConstants.NON_KAFKA_PROPS.contains(k)).collect(Collectors.toMap(Function.identity(), k -> (String)config.getValue(k, String.class))));
            KafkaProducer kafkaProducer = this.getKafkaProducerWithRetry(producerConfig, retrySeconds, channelName);
            String configuredTopic = config.getOptionalValue("topic", String.class).orElse(null);
            KafkaOutput kafkaOutput = new KafkaOutput(this.kafkaAdapterFactory, configuredTopic, channelName, kafkaProducer);
            this.kafkaOutputs.add(kafkaOutput);
            return ReactiveStreams.builder().to(kafkaOutput.getSubscriber());
        }
        catch (Exception retrySeconds) {
            void e;
            FFDCFilter.processException((Throwable)retrySeconds, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaOutgoingConnector", (String)"83", (Object)this, (Object[])new Object[]{config});
            throw new KafkaConnectorException(Tr.formatMessage((TraceComponent)tc, (String)"kafka.create.outgoing.error.CWMRX1008E", (Object[])new Object[]{channelName, e.getMessage()}), (Throwable)e);
        }
    }

    @FFDCIgnore(value={KafkaAdapterException.class})
    private <K, V> KafkaProducer<K, V> getKafkaProducerWithRetry(Map<String, Object> producerConfig, int retrySeconds, String channelName) throws InterruptedException {
        if (retrySeconds == 0) {
            return this.kafkaAdapterFactory.newKafkaProducer(producerConfig);
        }
        long retryNs = Duration.ofSeconds(retrySeconds).toNanos();
        long startTime = System.nanoTime();
        while (true) {
            try {
                return this.kafkaAdapterFactory.newKafkaProducer(producerConfig);
            }
            catch (KafkaAdapterException e) {
                if (System.nanoTime() - startTime > retryNs) {
                    throw e;
                }
                Tr.warning((TraceComponent)tc, (String)"kafka.create.outgoing.retry.CWMRX1010W", (Object[])new Object[]{channelName, e.getMessage()});
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void shutdown() {
        List<KafkaOutput<?, ?>> list = this.kafkaOutputs;
        synchronized (list) {
            for (KafkaOutput<?, ?> kafkaOutput : this.kafkaOutputs) {
                kafkaOutput.shutdown(Duration.ZERO);
            }
        }
    }
}

