/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openid20.consumer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openid20.OpenidClientConfig;
import com.ibm.ws.security.openid20.consumer.DefaultHostnameVerifier;
import com.ibm.ws.security.openid20.consumer.OpenidHttpFetcherFactory;
import javax.net.ssl.SSLContext;
import org.openid4java.association.AssociationException;
import org.openid4java.association.AssociationSessionType;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.InMemoryConsumerAssociationStore;
import org.openid4java.consumer.InMemoryNonceVerifier;
import org.openid4java.consumer.NonceVerifier;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.html.HtmlResolver;
import org.openid4java.discovery.xri.XriResolver;
import org.openid4java.discovery.yadis.YadisResolver;
import org.openid4java.server.RealmVerifierFactory;
import org.openid4java.util.HttpFetcherFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConsumerManagerFactory {
    static final TraceComponent tc = Tr.register(ConsumerManagerFactory.class, (String)"OpenId", (String)"com.ibm.ws.security.openid20.internal.resources.OpenIDMessages");
    public ConsumerManager consumerManager;
    static final long serialVersionUID = -6683434808831389760L;

    public ConsumerManagerFactory(ConsumerManager consumerManager) {
        this.consumerManager = consumerManager;
    }

    public ConsumerManager getConsumerManager(OpenidClientConfig openidClientConfig, SSLContext sslContext) {
        HttpFetcherFactory httpFetcherFactory = this.getHttpFetcherFactory(sslContext, openidClientConfig);
        YadisResolver yadisResolver = new YadisResolver(httpFetcherFactory);
        RealmVerifierFactory realmFactory = new RealmVerifierFactory(yadisResolver);
        HtmlResolver htmlResolver = new HtmlResolver(httpFetcherFactory);
        XriResolver xriResolver = Discovery.getXriResolver();
        Discovery discovery = new Discovery(htmlResolver, yadisResolver, xriResolver);
        this.consumerManager = this.createConsumerManager(httpFetcherFactory, realmFactory, discovery, openidClientConfig);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("discover socket time out: " + this.consumerManager.getDiscovery().getYadisResolver().getHttpFetcher().getRequestOptions().getSocketTimeout()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("discover conection time out: " + this.consumerManager.getDiscovery().getYadisResolver().getHttpFetcher().getRequestOptions().getConnTimeout()), (Object[])new Object[0]);
        }
        return this.consumerManager;
    }

    /*
     * WARNING - void declaration
     */
    protected ConsumerManager createConsumerManager(HttpFetcherFactory httpFetcherFactory, RealmVerifierFactory realmFactory, Discovery discovery, OpenidClientConfig openidClientConfig) {
        ConsumerManager cm;
        block4: {
            cm = new ConsumerManager(realmFactory, discovery, httpFetcherFactory);
            cm.setSocketTimeout((int)openidClientConfig.getSocketTimeout());
            cm.setConnectTimeout((int)openidClientConfig.getConnectTimeout());
            cm.setAllowStateless(openidClientConfig.getAllowStateless());
            cm.setMaxAssocAttempts(openidClientConfig.getMaxAssociationAttemps());
            AssociationSessionType associationSessionType = null;
            if (openidClientConfig.getMaxAssociationAttemps() > 0) {
                try {
                    associationSessionType = AssociationSessionType.create((String)openidClientConfig.getSessionEncryptionType(), (String)openidClientConfig.getSignatureAlgorithm());
                    cm.setPrefAssocSessEnc(associationSessionType);
                    cm.setMinAssocSessEnc(associationSessionType);
                }
                catch (AssociationException associationException) {
                    void e;
                    FFDCFilter.processException((Throwable)associationException, (String)"com.ibm.ws.security.openid20.consumer.ConsumerManagerFactory", (String)"85", (Object)this, (Object[])new Object[]{httpFetcherFactory, realmFactory, discovery, openidClientConfig});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)"Un-expected exception while performing association type create", (Object[])new Object[]{e});
                }
            }
        }
        cm.setAssociations((ConsumerAssociationStore)new InMemoryConsumerAssociationStore());
        cm.setNonceVerifier((NonceVerifier)new InMemoryNonceVerifier((int)openidClientConfig.getNonceValidTime()));
        cm.setMaxNonceAge((int)openidClientConfig.getNonceValidTime());
        cm.setImmediateAuth(openidClientConfig.isCheckImmediate());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isImmediateAuth:" + cm.isImmediateAuth()), (Object[])new Object[0]);
        }
        return cm;
    }

    protected HttpFetcherFactory getHttpFetcherFactory(SSLContext sslContext, OpenidClientConfig openidClientConfig) {
        OpenidHttpFetcherFactory httpFetcherFactory = null;
        httpFetcherFactory = openidClientConfig.isHostNameVerificationEnabled() ? new OpenidHttpFetcherFactory(sslContext, openidClientConfig) : new OpenidHttpFetcherFactory(sslContext, new DefaultHostnameVerifier(), openidClientConfig);
        return httpFetcherFactory;
    }
}

