/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.spi.expression.function;

import jakarta.data.expression.ComparableExpression;
import jakarta.data.expression.TextExpression;
import jakarta.data.messages.Messages;
import jakarta.data.spi.expression.function.FunctionExpression;
import jakarta.data.spi.expression.function.TextFunctionExpressionRecord;
import jakarta.data.spi.expression.literal.NumericLiteral;
import jakarta.data.spi.expression.literal.StringLiteral;
import java.util.List;

public interface TextFunctionExpression<T>
extends FunctionExpression<T, String>,
TextExpression<T> {
    public static final String CONCAT = "concat";
    public static final String LEFT = "left";
    public static final String LOWER = "lower";
    public static final String RIGHT = "right";
    public static final String UPPER = "upper";

    @Override
    public List<? extends ComparableExpression<? super T, ?>> arguments();

    public static <T> TextFunctionExpression<T> of(String name, String left, TextExpression<? super T> right) {
        Messages.requireNonNull(left, LEFT);
        Messages.requireNonNull(right, RIGHT);
        return new TextFunctionExpressionRecord(name, List.of(StringLiteral.of(left), right));
    }

    public static <T> TextFunctionExpression<T> of(String name, TextExpression<? super T> expression) {
        Messages.requireNonNull(expression, "expression");
        return new TextFunctionExpressionRecord(name, List.of(expression));
    }

    public static <T> TextFunctionExpression<T> of(String name, TextExpression<? super T> left, int literal) {
        Messages.requireNonNull(left, LEFT);
        return new TextFunctionExpressionRecord(name, List.of(left, NumericLiteral.of(literal)));
    }

    public static <T> TextFunctionExpression<T> of(String name, TextExpression<? super T> left, String right) {
        Messages.requireNonNull(left, LEFT);
        Messages.requireNonNull(right, RIGHT);
        return new TextFunctionExpressionRecord(name, List.of(left, StringLiteral.of(right)));
    }

    public static <T> TextFunctionExpression<T> of(String name, TextExpression<? super T> left, TextExpression<? super T> right) {
        Messages.requireNonNull(left, LEFT);
        Messages.requireNonNull(right, RIGHT);
        return new TextFunctionExpressionRecord(name, List.of(left, right));
    }
}

